/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.services.bytecode.BCClass;
import org.apache.derby.impl.services.bytecode.BCMethodDescriptor;
import org.apache.derby.impl.services.bytecode.Type;
import org.apache.derby.impl.services.bytecode.VMTypeIdCacheable;

public class BCJava
implements JavaFactory,
CacheableFactory,
ModuleControl {
    private CacheManager vmTypeIdCache;

    public void boot(boolean bl, Properties properties) throws StandardException {
        CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        this.vmTypeIdCache = cacheFactory.newCacheManager(this, "VMTypeIdCache", 64, 256);
    }

    public void stop() {
    }

    public ClassBuilder newClassBuilder(ClassFactory classFactory, String string2, int n, String string3, String string4) {
        return new BCClass(classFactory, string2, n, string3, string4, this);
    }

    public Cacheable newCacheable(CacheManager cacheManager) {
        return new VMTypeIdCacheable();
    }

    Type type(String string2) {
        try {
            VMTypeIdCacheable vMTypeIdCacheable = (VMTypeIdCacheable)this.vmTypeIdCache.find(string2);
            Type type = (Type)vMTypeIdCacheable.descriptor();
            this.vmTypeIdCache.release(vMTypeIdCacheable);
            return type;
        }
        catch (StandardException standardException) {
            Type type = new Type(string2, ClassHolder.convertToInternalDescriptor(string2));
            return type;
        }
    }

    String vmType(BCMethodDescriptor bCMethodDescriptor) {
        String string2;
        try {
            VMTypeIdCacheable vMTypeIdCacheable = (VMTypeIdCacheable)this.vmTypeIdCache.find(bCMethodDescriptor);
            string2 = vMTypeIdCacheable.descriptor().toString();
            this.vmTypeIdCache.release(vMTypeIdCacheable);
        }
        catch (StandardException standardException) {
            string2 = bCMethodDescriptor.buildMethodDescriptor();
        }
        return string2;
    }

    static short vmTypeId(String string2) {
        char c = string2.charAt(0);
        switch (c) {
            case 'L': {
                return 7;
            }
            case 'B': {
                return 0;
            }
            case 'C': {
                return 6;
            }
            case 'D': {
                return 5;
            }
            case 'F': {
                return 4;
            }
            case 'I': {
                return 2;
            }
            case 'J': {
                return 3;
            }
            case 'S': {
                return 1;
            }
            case 'Z': {
                return 2;
            }
            case '[': {
                return 7;
            }
            case 'V': {
                return -1;
            }
        }
        return -1;
    }
}

