/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportAbstract;
import org.apache.derby.impl.load.ExportWriteData;
import org.apache.derby.impl.load.ExportWriteDataAbstract;
import org.apache.derby.impl.load.LoadError;

public class Export
extends ExportAbstract {
    private String outputFileName;
    private String lobsFileName;

    private void doExport() throws SQLException {
        try {
            if (this.entityName == null && this.selectStatement == null) {
                throw LoadError.entityNameMissing();
            }
            if (this.outputFileName == null) {
                throw LoadError.dataFileNull();
            }
            if (this.dataFileExists(this.outputFileName)) {
                throw LoadError.dataFileExists(this.outputFileName);
            }
            if (this.lobsFileName != null && this.lobsFileExists(this.lobsFileName)) {
                throw LoadError.lobsFileExists(this.lobsFileName);
            }
            try {
                this.doAllTheWork();
            }
            catch (IOException iOException) {
                throw LoadError.errorWritingData(iOException);
            }
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    private Export(Connection connection, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws SQLException {
        this.con = connection;
        this.schemaName = string2;
        this.entityName = string3;
        this.selectStatement = string4;
        this.outputFileName = string5;
        try {
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(string6, string7, string8);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    private void setLobsExtFileName(String string2) throws SQLException {
        if (string2 == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0Q.S"));
        }
        this.lobsFileName = string2;
        this.lobsInExtFile = true;
    }

    private boolean lobsFileExists(String string2) throws SQLException {
        if (string2 == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0Q.S"));
        }
        string2 = FileUtil.stripProtocolFromFileName(string2);
        File file = new File(string2);
        return this.fileExists(file);
    }

    private boolean dataFileExists(String string2) throws SQLException {
        if (string2 == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE05.S"));
        }
        string2 = FileUtil.stripProtocolFromFileName(string2);
        File file = new File(string2);
        return this.fileExists(file);
    }

    private final boolean fileExists(final File file) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    public static void exportTable(Connection connection, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        Export export = new Export(connection, string2, string3, null, string4, string6, string5, string7);
        export.doExport();
    }

    public static void exportTable(Connection connection, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws SQLException {
        Export export = new Export(connection, string2, string3, null, string4, string6, string5, string7);
        export.setLobsExtFileName(string8);
        export.doExport();
    }

    public static void exportQuery(Connection connection, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Export export = new Export(connection, null, null, string2, string3, string5, string4, string6);
        export.doExport();
    }

    public static void exportQuery(Connection connection, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        Export export = new Export(connection, null, null, string2, string3, string5, string4, string6);
        export.setLobsExtFileName(string7);
        export.doExport();
    }

    protected ExportWriteDataAbstract getExportWriteData() throws Exception {
        if (this.lobsInExtFile) {
            return new ExportWriteData(this.outputFileName, this.lobsFileName, this.controlFileReader);
        }
        return new ExportWriteData(this.outputFileName, this.controlFileReader);
    }
}

