/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationSchemeBase;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationService;

public final class LDAPAuthenticationSchemeImpl
extends JNDIAuthenticationSchemeBase {
    private static final String dfltLDAPURL = "ldap://";
    private String searchBaseDN;
    private String leftSearchFilter;
    private String rightSearchFilter;
    private boolean useUserPropertyAsDN;
    private String searchAuthDN;
    private String searchAuthPW;
    private static final String[] attrDN = new String[]{"dn"};
    private static final String LDAP_SEARCH_BASE = "derby.authentication.ldap.searchBase";
    private static final String LDAP_SEARCH_FILTER = "derby.authentication.ldap.searchFilter";
    private static final String LDAP_SEARCH_AUTH_DN = "derby.authentication.ldap.searchAuthDN";
    private static final String LDAP_SEARCH_AUTH_PW = "derby.authentication.ldap.searchAuthPW";
    private static final String LDAP_LOCAL_USER_DN = "derby.user";
    private static final String LDAP_SEARCH_FILTER_USERNAME = "%USERNAME%";

    public LDAPAuthenticationSchemeImpl(JNDIAuthenticationService jNDIAuthenticationService, Properties properties) {
        super(jNDIAuthenticationService, properties);
    }

    public boolean authenticateUser(String string2, String string3, String string4, Properties properties) throws SQLException {
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            return false;
        }
        try {
            Properties properties2 = (Properties)this.initDirContextEnv.clone();
            String string5 = null;
            if (this.useUserPropertyAsDN) {
                string5 = this.authenticationService.getProperty("derby.user.");
            }
            if (string5 == (String)null) {
                string5 = this.getDNFromUID(string2);
            }
            properties2.put("java.naming.security.principal", string5);
            properties2.put("java.naming.security.credentials", string3);
            DirContext dirContext = this.privInitialDirContext(properties2);
            return true;
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        catch (NameNotFoundException nameNotFoundException) {
            return false;
        }
        catch (NamingException namingException) {
            NamingException namingException2 = namingException;
            throw LDAPAuthenticationSchemeImpl.getLoginSQLException(namingException2);
        }
    }

    private DirContext privInitialDirContext(final Properties properties) throws NamingException {
        try {
            return (InitialDirContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException, NamingException {
                    return new InitialDirContext(properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            throw (SecurityException)exception;
        }
    }

    protected void setJNDIProviderProperties() {
        String string2;
        if (this.initDirContextEnv.getProperty("java.naming.factory.initial") == (String)null) {
            this.initDirContextEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (this.initDirContextEnv.getProperty("java.naming.provider.url") == (String)null) {
            string2 = this.authenticationService.getProperty("derby.authentication.server");
            if (string2 == (String)null) {
                Monitor.logTextMessage("A011", "derby.authentication.server");
                this.providerURL = "ldap:///";
            } else {
                this.providerURL = string2.startsWith(dfltLDAPURL) || string2.startsWith("ldaps://") ? string2 : (string2.startsWith("//") ? "ldap:" + string2 : dfltLDAPURL + string2);
            }
            this.initDirContextEnv.put("java.naming.provider.url", this.providerURL);
        }
        if (this.initDirContextEnv.getProperty("java.naming.security.authentication") == (String)null) {
            this.initDirContextEnv.put("java.naming.security.authentication", "simple");
        }
        this.searchBaseDN = (string2 = this.authenticationService.getProperty(LDAP_SEARCH_BASE)) != (String)null ? string2 : "";
        this.searchAuthDN = this.authenticationService.getProperty(LDAP_SEARCH_AUTH_DN);
        this.searchAuthPW = this.authenticationService.getProperty(LDAP_SEARCH_AUTH_PW);
        String string3 = this.authenticationService.getProperty(LDAP_SEARCH_FILTER);
        if (string3 == (String)null) {
            this.leftSearchFilter = "(&(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        } else if (StringUtil.SQLEqualsIgnoreCase(string3, LDAP_LOCAL_USER_DN)) {
            this.leftSearchFilter = "(&(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
            this.useUserPropertyAsDN = true;
        } else if (string3.indexOf(LDAP_SEARCH_FILTER_USERNAME) != -1) {
            this.leftSearchFilter = string3.substring(0, string3.indexOf(LDAP_SEARCH_FILTER_USERNAME));
            this.rightSearchFilter = string3.substring(string3.indexOf(LDAP_SEARCH_FILTER_USERNAME) + LDAP_SEARCH_FILTER_USERNAME.length());
        } else {
            this.leftSearchFilter = "(&(" + string3 + ")" + "(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        }
    }

    private String getDNFromUID(String string2) throws NamingException {
        Properties properties = null;
        if (this.searchAuthDN != (String)null) {
            properties = (Properties)this.initDirContextEnv.clone();
            properties.put("java.naming.security.principal", this.searchAuthDN);
            properties.put("java.naming.security.credentials", this.searchAuthPW);
        } else {
            properties = this.initDirContextEnv;
        }
        DirContext dirContext = this.privInitialDirContext(properties);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(attrDN);
        String string3 = this.leftSearchFilter + string2 + this.rightSearchFilter;
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(this.searchBaseDN, string3, searchControls);
        if (namingEnumeration == null || !namingEnumeration.hasMore()) {
            throw new NameNotFoundException();
        }
        SearchResult searchResult = namingEnumeration.next();
        if (namingEnumeration.hasMore()) {
            throw new NameNotFoundException();
        }
        NameParser nameParser = dirContext.getNameParser(this.searchBaseDN);
        Name name = nameParser.parse(this.searchBaseDN);
        if (name == (Name)null) {
            throw new NameNotFoundException();
        }
        name.addAll(nameParser.parse(searchResult.getName()));
        return name.toString();
    }
}

