/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;

public final class BasicAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        String string2 = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return string2 == null || string2.length() == 0 || StringUtil.SQLEqualsIgnoreCase(string2, "BUILTIN");
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Monitor.exceptionStartingModule(noSuchAlgorithmException);
        }
        this.setAuthenticationService(this);
    }

    public boolean authenticateUser(String string2, String string3, String string4, Properties properties) throws SQLException {
        boolean bl;
        String string5;
        String string6 = null;
        int n = 0;
        if (string2 == null) {
            return false;
        }
        String string7 = null;
        String string8 = null;
        string6 = properties.getProperty("drdaSecMec");
        if (string6 != null) {
            n = Integer.parseInt(string6);
        }
        if ((string7 = this.getDatabaseProperty(string5 = "derby.user.".concat(string2))) != null) {
            if (n != 8) {
                try {
                    string8 = this.hashPasswordUsingStoredAlgorithm(string2, string3, string7);
                }
                catch (StandardException standardException) {
                    throw Util.generateCsSQLException(standardException);
                }
            } else {
                string7 = this.substitutePassword(string2, string7, properties, true);
                string8 = string3;
            }
        } else {
            try {
                Properties properties2 = this.getDatabaseProperties();
                if (properties2 != null) {
                    this.hashUsingDefaultAlgorithm(string2, string3, properties2);
                }
            }
            catch (StandardException standardException) {
                throw Util.generateCsSQLException(standardException);
            }
            string7 = this.getSystemProperty(string5);
            string8 = string3;
            if (string7 != null && n == 8) {
                string7 = this.substitutePassword(string2, string7, properties, false);
            }
        }
        boolean bl2 = bl = string7 != null && string7.equals(string8);
        if (!bl && n == 8) {
            throw Util.generateCsSQLException("08004.C.12");
        }
        return bl;
    }

    private String hashPasswordUsingStoredAlgorithm(String string2, String string3, String string4) throws StandardException {
        if (string4.startsWith("3b60")) {
            return this.hashPasswordSHA1Scheme(string3);
        }
        PasswordHasher passwordHasher = new PasswordHasher(string4);
        return passwordHasher.hashAndEncode(string2, string3);
    }
}

