/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericColumnDescriptor;

public class EmbedResultSetMetaData
implements ResultSetMetaData {
    private final ResultColumnDescriptor[] columnInfo;

    public EmbedResultSetMetaData(ResultColumnDescriptor[] resultColumnDescriptorArray) {
        this.columnInfo = resultColumnDescriptorArray;
    }

    public final int getColumnCount() {
        return this.columnInfo.length;
    }

    public final boolean isAutoIncrement(int n) throws SQLException {
        this.validColumnNumber(n);
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        return resultColumnDescriptor.isAutoincrement();
    }

    public final boolean isCaseSensitive(int n) throws SQLException {
        return DataTypeUtilities.isCaseSensitive(this.getColumnTypeDescriptor(n));
    }

    public final boolean isSearchable(int n) throws SQLException {
        this.validColumnNumber(n);
        return true;
    }

    public final boolean isCurrency(int n) throws SQLException {
        return DataTypeUtilities.isCurrency(this.getColumnTypeDescriptor(n));
    }

    public final int isNullable(int n) throws SQLException {
        return DataTypeUtilities.isNullable(this.getColumnTypeDescriptor(n));
    }

    public final boolean isSigned(int n) throws SQLException {
        return DataTypeUtilities.isSigned(this.getColumnTypeDescriptor(n));
    }

    public final int getColumnDisplaySize(int n) throws SQLException {
        return DataTypeUtilities.getColumnDisplaySize(this.getColumnTypeDescriptor(n));
    }

    public final String getColumnLabel(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string2 = resultColumnDescriptor.getName();
        return string2 == null ? "Column" + Integer.toString(n) : string2;
    }

    public final String getColumnName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string2 = resultColumnDescriptor.getName();
        return string2 == null ? "" : string2;
    }

    public final String getSchemaName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string2 = resultColumnDescriptor.getSourceSchemaName();
        return string2 == null ? "" : string2;
    }

    public final int getPrecision(int n) throws SQLException {
        return DataTypeUtilities.getDigitPrecision(this.getColumnTypeDescriptor(n));
    }

    public final int getScale(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getScale();
    }

    public final String getTableName(int n) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        String string2 = resultColumnDescriptor.getSourceTableName();
        return string2 == null ? "" : string2;
    }

    public final String getCatalogName(int n) throws SQLException {
        this.validColumnNumber(n);
        return "";
    }

    public final int getColumnType(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getTypeId().getJDBCTypeId();
    }

    public final String getColumnTypeName(int n) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n);
        return dataTypeDescriptor.getTypeId().getSQLTypeName();
    }

    public final boolean isReadOnly(int n) throws SQLException {
        this.validColumnNumber(n);
        return false;
    }

    public final boolean isWritable(int n) throws SQLException {
        this.validColumnNumber(n);
        return this.columnInfo[n - 1].updatableByCursor();
    }

    public final boolean isDefinitelyWritable(int n) throws SQLException {
        this.validColumnNumber(n);
        return false;
    }

    private void validColumnNumber(int n) throws SQLException {
        if (n < 1 || n > this.getColumnCount()) {
            throw Util.generateCsSQLException("S0022", new Integer(n));
        }
    }

    private DataTypeDescriptor getColumnTypeDescriptor(int n) throws SQLException {
        this.validColumnNumber(n);
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n - 1];
        return resultColumnDescriptor.getType();
    }

    public final String getColumnClassName(int n) throws SQLException {
        return this.getColumnTypeDescriptor(n).getTypeId().getResultSetMetaDataTypeName();
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string2, int n, boolean bl) {
        return new GenericColumnDescriptor(string2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, bl));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string2, int n, boolean bl, int n2) {
        return new GenericColumnDescriptor(string2, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, bl, n2));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string2, DataTypeDescriptor dataTypeDescriptor) {
        return new GenericColumnDescriptor(string2, dataTypeDescriptor);
    }
}

