/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;

public class EmbedResultSet20
extends EmbedResultSet {
    public EmbedResultSet20(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) throws SQLException {
        super(embedConnection, resultSet, bl, embedStatement, bl2);
    }

    public final BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            return bigDecimal.setScale(n2, 5);
        }
        return null;
    }

    public final BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dataValueDescriptor);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet20.noStateChangeException(standardException);
        }
    }

    public final BigDecimal getBigDecimal(String string2, int n) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        return this.getBigDecimal(this.findColumnName(string2), n);
    }

    public final InputStream getUnicodeStream(int n) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    public final InputStream getUnicodeStream(String string2) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    public final BigDecimal getBigDecimal(String string2) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        return this.getBigDecimal(this.findColumnName(string2));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateBigDecimal").setBigDecimal(bigDecimal);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet20.noStateChangeException(standardException);
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.checksBeforeUpdateOrDelete("updateObject", n);
        int n2 = this.getColumnType(n);
        if (object instanceof BigDecimal) {
            this.updateBigDecimal(n, (BigDecimal)object);
            return;
        }
        super.updateObject(n, object);
    }

    public void updateBigDecimal(String string2, BigDecimal bigDecimal) throws SQLException {
        this.checkIfClosed("updateBigDecimal");
        this.updateBigDecimal(this.findColumnName(string2), bigDecimal);
    }

    public Object getObject(int n, Map map2) throws SQLException {
        this.checkIfClosed("getObject");
        if (map2 == null) {
            throw Util.generateCsSQLException("XJ081.S", map2, "map", "java.sql.ResultSet.getObject");
        }
        if (!map2.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public Array getArray(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(String string2, Map map2) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumn(string2), map2);
    }

    public Ref getRef(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public Array getArray(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateRef(String string2, Ref ref) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw Util.notImplemented();
    }

    public void updateArray(String string2, Array array) throws SQLException {
        throw Util.notImplemented();
    }
}

