/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.jdbc.EngineResultSet;
import org.apache.derby.iapi.services.io.CloseFilterInputStream;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.execute.ScrollInsensitiveResultSet;

public abstract class EmbedResultSet
extends ConnectionChild
implements EngineResultSet,
Comparable {
    protected static final int FIRST = 1;
    protected static final int NEXT = 2;
    protected static final int LAST = 3;
    protected static final int PREVIOUS = 4;
    protected static final int BEFOREFIRST = 5;
    protected static final int AFTERLAST = 6;
    protected static final int ABSOLUTE = 7;
    protected static final int RELATIVE = 8;
    private ExecRow currentRow;
    protected boolean wasNull;
    boolean isClosed;
    private boolean isOnInsertRow;
    private Object currentStream;
    private ResultSet theResults;
    private boolean forMetaData;
    private SQLWarning topWarning;
    Activation singleUseActivation;
    final int order;
    private final ResultDescription resultDescription;
    private int maxRows;
    private final int maxFieldSize;
    private int NumberofFetchedRows;
    private final EmbedStatement stmt;
    private EmbedStatement owningStmt;
    private Statement applicationStmt;
    private final long timeoutMillis;
    private final boolean isAtomic;
    private final int concurrencyOfThisResultSet;
    private final ExecRow updateRow;
    private boolean[] columnGotUpdated;
    private boolean currentRowHasBeenUpdated;
    private int fetchDirection;
    private int fetchSize;
    private boolean[] columnUsedFlags;

    public EmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl, EmbedStatement embedStatement, boolean bl2) throws SQLException {
        super(embedConnection);
        this.theResults = resultSet;
        this.forMetaData = bl;
        if (this.forMetaData) {
            this.singleUseActivation = resultSet.getActivation();
        }
        this.stmt = this.owningStmt = embedStatement;
        this.applicationStmt = this.owningStmt;
        this.timeoutMillis = embedStatement == null ? 0L : embedStatement.timeoutMillis;
        this.isAtomic = bl2;
        if (embedStatement == null) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (embedStatement.resultSetConcurrency == 1007) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (!this.isForUpdate()) {
            this.concurrencyOfThisResultSet = 1007;
            SQLWarning sQLWarning = StandardException.newWarning("01J06");
            this.addWarning(sQLWarning);
        } else {
            this.concurrencyOfThisResultSet = 1008;
        }
        this.resultDescription = this.theResults.getResultDescription();
        if (this.concurrencyOfThisResultSet == 1008) {
            int n = this.resultDescription.getColumnCount();
            ExecutionFactory executionFactory = embedConnection.getLanguageConnection().getLanguageConnectionFactory().getExecutionFactory();
            try {
                this.columnGotUpdated = new boolean[n];
                this.updateRow = executionFactory.getValueRow(n);
                for (int i = 1; i <= n; ++i) {
                    this.updateRow.setColumn(i, this.resultDescription.getColumnDescriptor(i).getType().getNull());
                }
                this.initializeUpdateRowModifiers();
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
        } else {
            this.updateRow = null;
        }
        if (embedStatement != null) {
            if (embedStatement.resultSetType == 1003) {
                this.maxRows = embedStatement.maxRows;
            }
            this.maxFieldSize = embedStatement.MaxFieldSize;
        } else {
            this.maxFieldSize = 0;
        }
        this.order = embedConnection.getResultSetOrderId();
    }

    private void checkNotOnInsertRow() throws SQLException {
        if (this.isOnInsertRow) {
            throw this.newSQLException("24000");
        }
    }

    protected final void checkOnRow() throws SQLException {
        if (this.currentRow == null) {
            throw this.newSQLException("24000");
        }
    }

    private void initializeUpdateRowModifiers() {
        this.currentRowHasBeenUpdated = false;
        Arrays.fill(this.columnGotUpdated, false);
    }

    final int getColumnType(int n) throws SQLException {
        if (!this.isOnInsertRow) {
            this.checkOnRow();
        }
        if (n < 1 || n > this.resultDescription.getColumnCount()) {
            throw this.newSQLException("S0022", new Integer(n));
        }
        return this.resultDescription.getColumnDescriptor(n).getType().getJDBCTypeId();
    }

    public boolean next() throws SQLException {
        if (this.maxRows != 0) {
            ++this.NumberofFetchedRows;
            if (this.NumberofFetchedRows > this.maxRows) {
                this.closeCurrentStream();
                return false;
            }
        }
        return this.movePosition(2, 0, "next");
    }

    protected boolean movePosition(int n, String string2) throws SQLException {
        return this.movePosition(n, 0, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean movePosition(int n, int n2, String string2) throws SQLException {
        this.closeCurrentStream();
        this.checkExecIfClosed(string2);
        if (this.isOnInsertRow) {
            this.moveToCurrentRow();
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            this.setupContextStack();
            try {
                boolean bl2;
                ExecRow execRow;
                Object object2;
                LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                try {
                    object2 = languageConnectionContext.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, this.timeoutMillis);
                    switch (n) {
                        case 5: {
                            execRow = this.theResults.setBeforeFirstRow();
                            break;
                        }
                        case 1: {
                            execRow = this.theResults.getFirstRow();
                            break;
                        }
                        case 2: {
                            execRow = this.theResults.getNextRow();
                            break;
                        }
                        case 3: {
                            execRow = this.theResults.getLastRow();
                            break;
                        }
                        case 6: {
                            execRow = this.theResults.setAfterLastRow();
                            break;
                        }
                        case 4: {
                            execRow = this.theResults.getPreviousRow();
                            break;
                        }
                        case 7: {
                            execRow = this.theResults.getAbsoluteRow(n2);
                            break;
                        }
                        case 8: {
                            execRow = this.theResults.getRelativeRow(n2);
                            break;
                        }
                        default: {
                            execRow = null;
                        }
                    }
                    languageConnectionContext.popStatementContext((StatementContext)object2, null);
                    InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                }
                catch (Throwable throwable) {
                    throw this.closeOnTransactionError(throwable);
                }
                object2 = this.theResults.getWarnings();
                if (object2 != null) {
                    this.addWarning((SQLWarning)object2);
                }
                boolean bl3 = bl2 = (this.currentRow = execRow) != null;
                if (!(bl2 || n != 2 || this.forMetaData && languageConnectionContext.getActivationCount() > 1 || this.owningStmt == null || this.owningStmt.getResultSetType() != 1003)) {
                    this.owningStmt.resultSetClosing(this);
                }
                if (this.columnUsedFlags != null) {
                    Arrays.fill(this.columnUsedFlags, false);
                }
                if (this.columnGotUpdated != null && this.currentRowHasBeenUpdated) {
                    this.initializeUpdateRowModifiers();
                }
                bl = bl2;
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeCurrentStream();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack();
            }
            catch (SQLException sQLException) {
                return;
            }
            try {
                LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                try {
                    this.theResults.close();
                    if (this.singleUseActivation != null) {
                        this.singleUseActivation.close();
                        this.singleUseActivation = null;
                    }
                    InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                if (this.forMetaData) {
                    if (languageConnectionContext.getActivationCount() > 1) {
                    } else if (this.owningStmt != null) {
                        this.owningStmt.resultSetClosing(this);
                    }
                } else if (this.owningStmt != null) {
                    this.owningStmt.resultSetClosing(this);
                }
            }
            finally {
                this.markClosed();
                this.restoreContextStack();
            }
            this.currentRow = null;
        }
    }

    private void markClosed() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.stmt != null) {
            this.stmt.closeMeOnCompletion();
        }
        if (this.owningStmt != null && this.owningStmt != this.stmt) {
            this.owningStmt.closeMeOnCompletion();
        }
    }

    public final boolean wasNull() throws SQLException {
        this.checkIfClosed("wasNull");
        return this.wasNull;
    }

    public final String getString(int n) throws SQLException {
        this.checkIfClosed("getString");
        int n2 = this.getColumnType(n);
        if (n2 == 2004 || n2 == 2005) {
            this.checkLOBMultiCall(n);
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            String string2 = dataValueDescriptor.getString();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(n2) && string2.length() > this.maxFieldSize) {
                string2 = string2.substring(0, this.maxFieldSize);
            }
            return string2;
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final boolean getBoolean(int n) throws SQLException {
        this.checkIfClosed("getBoolean");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return false;
            }
            return dataValueDescriptor.getBoolean();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final byte getByte(int n) throws SQLException {
        this.checkIfClosed("getByte");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getByte();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final short getShort(int n) throws SQLException {
        this.checkIfClosed("getShort");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getShort();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final int getInt(int n) throws SQLException {
        this.checkIfClosed("getInt");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getInt();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final long getLong(int n) throws SQLException {
        this.checkIfClosed("getLong");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0L;
            }
            return dataValueDescriptor.getLong();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final float getFloat(int n) throws SQLException {
        this.checkIfClosed("getFloat");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0f;
            }
            return dataValueDescriptor.getFloat();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final double getDouble(int n) throws SQLException {
        this.checkIfClosed("getDouble");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0;
            }
            return dataValueDescriptor.getDouble();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final byte[] getBytes(int n) throws SQLException {
        this.checkIfClosed("getBytes");
        int n2 = this.getColumnType(n);
        if (n2 == 2004) {
            this.checkLOBMultiCall(n);
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            byte[] byArray = dataValueDescriptor.getBytes();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(n2) && byArray.length > this.maxFieldSize) {
                byte[] byArray2 = new byte[this.maxFieldSize];
                System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
                byArray = byArray2;
            }
            return byArray;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final Date getDate(int n) throws SQLException {
        return this.getDate(n, (Calendar)null);
    }

    public final Time getTime(int n) throws SQLException {
        return this.getTime(n, (Calendar)null);
    }

    public final Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, (Calendar)null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkIfClosed("getDate");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getDate(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Date getDate(String string2, Calendar calendar) throws SQLException {
        this.checkIfClosed("getDate");
        return this.getDate(this.findColumnName(string2), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkIfClosed("getTime");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTime(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Time getTime(String string2, Calendar calendar) throws SQLException {
        this.checkIfClosed("getTime");
        return this.getTime(this.findColumnName(string2), calendar);
    }

    public Timestamp getTimestamp(String string2, Calendar calendar) throws SQLException {
        this.checkIfClosed("getTimestamp");
        return this.getTimestamp(this.findColumnName(string2), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkIfClosed("getTimestamp");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTimestamp(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Reader getCharacterStream(int n) throws SQLException {
        Object object;
        int n2;
        this.checkIfClosed("getCharacterStream");
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                n2 = this.maxFieldSize;
                break;
            }
            case 2005: {
                n2 = 0;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream inputStream = this.getBinaryStream(n);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16BE");
                    this.currentStream = inputStreamReader;
                    return inputStreamReader;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.getMessage());
                }
            }
            default: {
                throw this.dataTypeConversion("java.io.Reader", n);
            }
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            boolean bl = false;
            try {
                Reader reader;
                Object object3;
                this.useStreamOrLOB(n);
                StringDataValue stringDataValue = (StringDataValue)this.getColumn(n);
                this.wasNull = stringDataValue.isNull();
                if (this.wasNull) {
                    Reader reader2 = null;
                    return reader2;
                }
                bl = true;
                this.setupContextStack();
                if (stringDataValue.hasStream()) {
                    object3 = stringDataValue.getStreamWithDescriptor();
                    if (n2 > 0) {
                        object3 = new CharacterStreamDescriptor.Builder().copyState((CharacterStreamDescriptor)object3).maxCharLength(n2).build();
                    }
                    reader = new UTF8Reader((CharacterStreamDescriptor)object3, this, object);
                } else {
                    object3 = stringDataValue.getString();
                    if (n2 > 0 && ((String)object3).length() > n2) {
                        object3 = ((String)object3).substring(0, n2);
                    }
                    reader = new StringReader((String)object3);
                }
                this.currentStream = reader;
                object3 = reader;
                return object3;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    public final InputStream getAsciiStream(int n) throws SQLException {
        this.checkIfClosed("getAsciiStream");
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBinaryStream(n);
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream(ASCII)", n);
            }
        }
        Reader reader = this.getCharacterStream(n);
        if (reader == null) {
            return null;
        }
        return new ReaderToAscii(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream getBinaryStream(int n) throws SQLException {
        Object object;
        int n2;
        this.checkIfClosed("getBinaryStream");
        int n3 = this.getColumnType(n);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: {
                n2 = this.maxFieldSize;
                break;
            }
            case 2004: {
                n2 = 0;
                break;
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream", n);
            }
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            boolean bl = false;
            try {
                InputStream inputStream;
                this.useStreamOrLOB(n);
                DataValueDescriptor dataValueDescriptor = this.getColumn(n);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InputStream inputStream2 = null;
                    return inputStream2;
                }
                bl = true;
                this.setupContextStack();
                InputStream inputStream3 = dataValueDescriptor.hasStream() ? new BinaryToRawStream(dataValueDescriptor.getStream(), dataValueDescriptor) : new ByteArrayInputStream(dataValueDescriptor.getBytes());
                if (n2 > 0) {
                    inputStream = new LimitInputStream(inputStream3);
                    inputStream.setLimit(n2);
                    inputStream3 = inputStream;
                }
                inputStream3 = new CloseFilterInputStream(inputStream3);
                this.currentStream = inputStream3;
                inputStream = inputStream3;
                return inputStream;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    public final String getString(String string2) throws SQLException {
        this.checkIfClosed("getString");
        return this.getString(this.findColumnName(string2));
    }

    public final boolean getBoolean(String string2) throws SQLException {
        this.checkIfClosed("getBoolean");
        return this.getBoolean(this.findColumnName(string2));
    }

    public final byte getByte(String string2) throws SQLException {
        this.checkIfClosed("getByte");
        return this.getByte(this.findColumnName(string2));
    }

    public final short getShort(String string2) throws SQLException {
        this.checkIfClosed("getShort");
        return this.getShort(this.findColumnName(string2));
    }

    public final int getInt(String string2) throws SQLException {
        this.checkIfClosed("getInt");
        return this.getInt(this.findColumnName(string2));
    }

    public final long getLong(String string2) throws SQLException {
        this.checkIfClosed("getLong");
        return this.getLong(this.findColumnName(string2));
    }

    public final float getFloat(String string2) throws SQLException {
        this.checkIfClosed("getFloat");
        return this.getFloat(this.findColumnName(string2));
    }

    public final double getDouble(String string2) throws SQLException {
        this.checkIfClosed("getDouble");
        return this.getDouble(this.findColumnName(string2));
    }

    public final byte[] getBytes(String string2) throws SQLException {
        this.checkIfClosed("getBytes");
        return this.getBytes(this.findColumnName(string2));
    }

    public final Date getDate(String string2) throws SQLException {
        this.checkIfClosed("getDate");
        return this.getDate(this.findColumnName(string2));
    }

    public final Time getTime(String string2) throws SQLException {
        this.checkIfClosed("getTime");
        return this.getTime(this.findColumnName(string2));
    }

    public final Timestamp getTimestamp(String string2) throws SQLException {
        this.checkIfClosed("getTimestamp");
        return this.getTimestamp(this.findColumnName(string2));
    }

    public final Reader getCharacterStream(String string2) throws SQLException {
        this.checkIfClosed("getCharacterStream");
        return this.getCharacterStream(this.findColumnName(string2));
    }

    public final InputStream getAsciiStream(String string2) throws SQLException {
        this.checkIfClosed("getAsciiStream");
        return this.getAsciiStream(this.findColumnName(string2));
    }

    public final InputStream getBinaryStream(String string2) throws SQLException {
        this.checkIfClosed("getBinaryStream");
        return this.getBinaryStream(this.findColumnName(string2));
    }

    public URL getURL(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public URL getURL(String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public final SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed("getWarnings");
        return this.topWarning;
    }

    public final void clearWarnings() throws SQLException {
        this.checkIfClosed("clearWarnings");
        this.topWarning = null;
    }

    public final String getCursorName() throws SQLException {
        this.checkIfClosed("getCursorName");
        return this.theResults.getCursorName();
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        this.checkIfClosed("getMetaData");
        ResultSetMetaData resultSetMetaData = this.resultDescription.getMetaData();
        if (resultSetMetaData == null) {
            resultSetMetaData = this.factory.newEmbedResultSetMetaData(this.resultDescription.getColumnInfo());
            this.resultDescription.setMetaData(resultSetMetaData);
        }
        return resultSetMetaData;
    }

    public final int getHoldability() throws SQLException {
        this.checkIfClosed("getHoldability");
        if (this.theResults.getActivation().getResultSetHoldability()) {
            return 1;
        }
        return 2;
    }

    public final Object getObject(int n) throws SQLException {
        this.checkIfClosed("getObject");
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n);
            }
            case 2005: {
                return this.getClob(n);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
            case 2004: {
                return this.getBlob(n);
            }
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return dataValueDescriptor.getObject();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final Object getObject(String string2) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumnName(string2));
    }

    public final int findColumn(String string2) throws SQLException {
        this.checkIfClosed("findColumn");
        return this.findColumnName(string2);
    }

    public final Statement getStatement() throws SQLException {
        this.checkIfClosed("getStatement");
        return this.applicationStmt;
    }

    public final void setApplicationStatement(Statement statement) {
        this.applicationStmt = statement;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.checkRowPosition(101, "isBeforeFirst");
    }

    public boolean isAfterLast() throws SQLException {
        return this.checkRowPosition(104, "isAfterLast");
    }

    public boolean isFirst() throws SQLException {
        return this.checkRowPosition(102, "isFirst");
    }

    public boolean isLast() throws SQLException {
        return this.checkRowPosition(103, "isLast");
    }

    public void beforeFirst() throws SQLException {
        this.checkScrollCursor("beforeFirst()");
        this.movePosition(5, "beforeFirst");
    }

    public void afterLast() throws SQLException {
        this.checkScrollCursor("afterLast()");
        this.movePosition(6, "afterLast");
    }

    public boolean first() throws SQLException {
        this.checkScrollCursor("first()");
        return this.movePosition(1, "first");
    }

    public boolean last() throws SQLException {
        this.checkScrollCursor("last()");
        return this.movePosition(3, "last");
    }

    public int getRow() throws SQLException {
        this.checkScrollCursor("getRow()");
        return this.theResults.getRowNumber();
    }

    public boolean absolute(int n) throws SQLException {
        this.checkScrollCursor("absolute()");
        return this.movePosition(7, n, "absolute");
    }

    public boolean relative(int n) throws SQLException {
        this.checkScrollCursor("relative()");
        return this.movePosition(8, n, "relative");
    }

    public boolean previous() throws SQLException {
        this.checkScrollCursor("previous()");
        return this.movePosition(4, "previous");
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkScrollCursor("setFetchDirection()");
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        this.checkIfClosed("getFetchDirection");
        if (this.fetchDirection == 0) {
            return this.stmt.getFetchDirection();
        }
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkIfClosed("setFetchSize");
        if (n < 0 || this.stmt.getMaxRows() != 0 && n > this.stmt.getMaxRows()) {
            throw Util.generateCsSQLException("XJ062.S", new Integer(n));
        }
        if (n > 0) {
            this.fetchSize = n;
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkIfClosed("getFetchSize");
        if (this.fetchSize == 0) {
            return this.stmt.getFetchSize();
        }
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        this.checkIfClosed("getType");
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLException {
        this.checkIfClosed("getConcurrency");
        return this.concurrencyOfThisResultSet;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkIfClosed("rowUpdated");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        boolean bl = false;
        try {
            if (this.isForUpdate() && this.getType() == 1004) {
                bl = ((ScrollInsensitiveResultSet)this.theResults).isUpdated();
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return bl;
    }

    public boolean rowInserted() throws SQLException {
        this.checkIfClosed("rowInserted");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkIfClosed("rowDeleted");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        boolean bl = false;
        try {
            if (this.isForUpdate() && this.getType() == 1004) {
                bl = ((ScrollInsensitiveResultSet)this.theResults).isDeleted();
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return bl;
    }

    protected void checksBeforeUpdateXXX(String string2, int n) throws SQLException {
        this.checksBeforeUpdateOrDelete(string2, n);
        ResultDescription resultDescription = this.theResults.getResultDescription();
        if (n < 1 || n > resultDescription.getColumnCount()) {
            throw Util.generateCsSQLException("XCL14.S", (Object)new Integer(n), String.valueOf(resultDescription.getColumnCount()));
        }
        if (resultDescription.getColumnDescriptor(n).getSourceTableName() == null) {
            throw Util.generateCsSQLException("XJ084.U", string2);
        }
        if (!this.getMetaData().isWritable(n)) {
            throw Util.generateCsSQLException("42X31", (Object)this.theResults.getResultDescription().getColumnDescriptor(n).getName(), this.getCursorName());
        }
    }

    protected void checksBeforeUpdateOrDelete(String string2, int n) throws SQLException {
        this.checkIfClosed(string2);
        this.checkUpdatableCursor(string2);
        if (!this.isOnInsertRow) {
            this.checkOnRow();
        }
    }

    protected DataValueDescriptor getDVDforColumnToBeUpdated(int n, String string2) throws StandardException, SQLException {
        this.checksBeforeUpdateXXX(string2, n);
        this.columnGotUpdated[n - 1] = true;
        this.currentRowHasBeenUpdated = true;
        return this.updateRow.getColumn(n);
    }

    protected void checksBeforeInsert() throws SQLException {
        this.checkIfClosed("insertRow");
        this.checkUpdatableCursor("insertRow");
        if (!this.isOnInsertRow) {
            throw this.newSQLException("XJ086.S");
        }
    }

    private void checksBeforeUpdateAsciiStream(int n) throws SQLException {
        this.checksBeforeUpdateXXX("updateAsciiStream", n);
        int n2 = this.getColumnType(n);
        if (!DataTypeDescriptor.isAsciiStreamAssignable(n2)) {
            throw this.dataTypeConversion(n, "java.io.InputStream");
        }
    }

    private void checksBeforeUpdateBinaryStream(int n) throws SQLException {
        this.checksBeforeUpdateXXX("updateBinaryStream", n);
        int n2 = this.getColumnType(n);
        if (!DataTypeDescriptor.isBinaryStreamAssignable(n2)) {
            throw this.dataTypeConversion(n, "java.io.InputStream");
        }
    }

    private void checksBeforeUpdateCharacterStream(int n) throws SQLException {
        this.checksBeforeUpdateXXX("updateCharacterStream", n);
        int n2 = this.getColumnType(n);
        if (!DataTypeDescriptor.isCharacterStreamAssignable(n2)) {
            throw this.dataTypeConversion(n, "java.io.Reader");
        }
    }

    public void updateNull(int n) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateNull").setToNull();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateBoolean").setValue(bl);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateByte(int n, byte by2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateByte").setValue(by2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateShort").setValue(s);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateInt").setValue(n2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateLong").setValue(l);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateFloat(int n, float f2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateFloat").setValue(f2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateDouble").setValue(d);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateString(int n, String string2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateString").setValue(string2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateBytes").setValue(byArray);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateDate").setValue(date);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateTime").setValue(time);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n, "updateTimestamp").setValue(timestamp);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checksBeforeUpdateAsciiStream(n);
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        this.updateCharacterStreamInternal(n, inputStreamReader, false, l, "updateAsciiStream");
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.checksBeforeUpdateAsciiStream(n);
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        this.updateCharacterStreamInternal(n, inputStreamReader, true, -1L, "updateAsciiStream");
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checksBeforeUpdateBinaryStream(n);
        if (inputStream == null) {
            this.updateNull(n);
            return;
        }
        this.updateBinaryStreamInternal(n, inputStream, false, l, "updateBinaryStream");
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.checksBeforeUpdateBinaryStream(n);
        this.updateBinaryStreamInternal(n, inputStream, true, -1L, "updateBinaryStream");
    }

    private void updateBinaryStreamInternal(int n, InputStream inputStream, boolean bl, long l, String string2) throws SQLException {
        RawToBinaryFormatStream rawToBinaryFormatStream;
        if (!bl) {
            if (l < 0L) {
                throw this.newSQLException("XJ025.S");
            }
            if (l > Integer.MAX_VALUE) {
                throw this.newSQLException("22003", this.getColumnSQLType(n));
            }
            rawToBinaryFormatStream = new RawToBinaryFormatStream(inputStream, (int)l);
        } else {
            l = -1L;
            rawToBinaryFormatStream = new RawToBinaryFormatStream(inputStream, this.getMaxColumnWidth(n), this.getColumnSQLType(n));
        }
        try {
            this.getDVDforColumnToBeUpdated(n, string2).setValue(rawToBinaryFormatStream, (int)l);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checksBeforeUpdateCharacterStream(n);
        this.updateCharacterStreamInternal(n, reader, false, l, "updateCharacterStream");
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.checksBeforeUpdateCharacterStream(n);
        this.updateCharacterStreamInternal(n, reader, true, -1L, "updateCharacterStream");
    }

    private void updateCharacterStreamInternal(int n, Reader reader, boolean bl, long l, String string2) throws SQLException {
        try {
            ReaderToUTF8Stream readerToUTF8Stream;
            if (reader == null) {
                this.updateNull(n);
                return;
            }
            StringDataValue stringDataValue = (StringDataValue)this.getDVDforColumnToBeUpdated(n, string2);
            stringDataValue.setStreamHeaderFormat(!this.getEmbedConnection().getDatabase().getDataDictionary().checkVersion(170, null));
            int n2 = -1;
            if (!bl) {
                int n3;
                if (l < 0L) {
                    throw this.newSQLException("XJ025.S");
                }
                if (l > Integer.MAX_VALUE) {
                    throw this.newSQLException("22003", this.getColumnSQLType(n));
                }
                n2 = (int)l;
                int n4 = 0;
                if (this.getColumnType(n) == 2005 && n2 > (n3 = this.getMaxColumnWidth(n))) {
                    n4 = n2 - n3;
                    n2 = n3;
                }
                readerToUTF8Stream = new ReaderToUTF8Stream(reader, n2, n4, this.getColumnSQLType(n), stringDataValue.getStreamHeaderGenerator());
            } else {
                int n5 = this.getMaxColumnWidth(n);
                readerToUTF8Stream = new ReaderToUTF8Stream(reader, n5, this.getColumnSQLType(n), stringDataValue.getStreamHeaderGenerator());
            }
            stringDataValue.setValue(readerToUTF8Stream, n2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
        int n3 = this.getColumnType(n);
        if (n3 == 3 || n3 == 2) {
            if (n2 < 0) {
                throw this.newSQLException("XJ044.S", new Integer(n2));
            }
            try {
                DataValueDescriptor dataValueDescriptor = this.updateRow.getColumn(n);
                int n4 = dataValueDescriptor.getLength();
                ((VariableSizeDataValue)((Object)dataValueDescriptor)).setWidth(-1, n2, false);
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.checksBeforeUpdateXXX("updateObject", n);
        int n2 = this.getColumnType(n);
        if (n2 == 2000) {
            try {
                ((UserDataValue)this.getDVDforColumnToBeUpdated(n, "updateObject")).setValue(object);
                return;
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
        }
        if (object == null) {
            this.updateNull(n);
            return;
        }
        if (object instanceof String) {
            this.updateString(n, (String)object);
            return;
        }
        if (object instanceof Boolean) {
            this.updateBoolean(n, (boolean)((Boolean)object));
            return;
        }
        if (object instanceof Short) {
            this.updateShort(n, (short)((Short)object));
            return;
        }
        if (object instanceof Integer) {
            this.updateInt(n, (int)((Integer)object));
            return;
        }
        if (object instanceof Long) {
            this.updateLong(n, (long)((Long)object));
            return;
        }
        if (object instanceof Float) {
            this.updateFloat(n, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.updateDouble(n, (double)((Double)object));
            return;
        }
        if (object instanceof byte[]) {
            this.updateBytes(n, (byte[])object);
            return;
        }
        if (object instanceof Date) {
            this.updateDate(n, (Date)object);
            return;
        }
        if (object instanceof Time) {
            this.updateTime(n, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.updateTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof Blob) {
            this.updateBlob(n, (Blob)object);
            return;
        }
        if (object instanceof Clob) {
            this.updateClob(n, (Clob)object);
            return;
        }
        throw this.dataTypeConversion(n, object.getClass().getName());
    }

    public void updateNull(String string2) throws SQLException {
        this.checkIfClosed("updateNull");
        this.updateNull(this.findColumnName(string2));
    }

    public void updateBoolean(String string2, boolean bl) throws SQLException {
        this.checkIfClosed("updateBoolean");
        this.updateBoolean(this.findColumnName(string2), bl);
    }

    public void updateByte(String string2, byte by2) throws SQLException {
        this.checkIfClosed("updateByte");
        this.updateByte(this.findColumnName(string2), by2);
    }

    public void updateShort(String string2, short s) throws SQLException {
        this.checkIfClosed("updateShort");
        this.updateShort(this.findColumnName(string2), s);
    }

    public void updateInt(String string2, int n) throws SQLException {
        this.checkIfClosed("updateInt");
        this.updateInt(this.findColumnName(string2), n);
    }

    public void updateLong(String string2, long l) throws SQLException {
        this.checkIfClosed("updateLong");
        this.updateLong(this.findColumnName(string2), l);
    }

    public void updateFloat(String string2, float f2) throws SQLException {
        this.checkIfClosed("updateFloat");
        this.updateFloat(this.findColumnName(string2), f2);
    }

    public void updateDouble(String string2, double d) throws SQLException {
        this.checkIfClosed("updateDouble");
        this.updateDouble(this.findColumnName(string2), d);
    }

    public void updateString(String string2, String string3) throws SQLException {
        this.checkIfClosed("updateString");
        this.updateString(this.findColumnName(string2), string3);
    }

    public void updateBytes(String string2, byte[] byArray) throws SQLException {
        this.checkIfClosed("updateBytes");
        this.updateBytes(this.findColumnName(string2), byArray);
    }

    public void updateDate(String string2, Date date) throws SQLException {
        this.checkIfClosed("updateDate");
        this.updateDate(this.findColumnName(string2), date);
    }

    public void updateTime(String string2, Time time) throws SQLException {
        this.checkIfClosed("updateTime");
        this.updateTime(this.findColumnName(string2), time);
    }

    public void updateTimestamp(String string2, Timestamp timestamp) throws SQLException {
        this.checkIfClosed("updateTimestamp");
        this.updateTimestamp(this.findColumnName(string2), timestamp);
    }

    public void updateAsciiStream(String string2, InputStream inputStream, int n) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(string2), inputStream, n);
    }

    public void updateBinaryStream(String string2, InputStream inputStream, int n) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(string2), inputStream, n);
    }

    public void updateCharacterStream(String string2, Reader reader, int n) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(string2), reader, n);
    }

    public void updateObject(String string2, Object object, int n) throws SQLException {
        this.checkIfClosed("updateObject");
        this.updateObject(this.findColumnName(string2), object, n);
    }

    public void updateObject(String string2, Object object) throws SQLException {
        this.checkIfClosed("updateObject");
        this.updateObject(this.findColumnName(string2), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.checksBeforeInsert();
            this.setupContextStack();
            LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
            StatementContext statementContext = null;
            try {
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
                StringBuffer stringBuffer2 = new StringBuffer("VALUES (");
                CursorActivation cursorActivation = languageConnectionContext.lookupCursorActivation(this.getCursorName());
                ExecCursorTableReference execCursorTableReference = cursorActivation.getPreparedStatement().getTargetTable();
                stringBuffer.append(this.getFullBaseTableName(execCursorTableReference));
                ResultDescription resultDescription = this.theResults.getResultDescription();
                stringBuffer.append(" (");
                for (int i = 1; i <= resultDescription.getColumnCount(); ++i) {
                    if (bl) {
                        stringBuffer.append(",");
                        stringBuffer2.append(",");
                    }
                    stringBuffer.append(IdUtil.normalToDelimited(resultDescription.getColumnDescriptor(i).getName()));
                    if (this.columnGotUpdated[i - 1]) {
                        stringBuffer2.append("?");
                    } else {
                        stringBuffer2.append("DEFAULT");
                    }
                    bl = true;
                }
                stringBuffer.append(") ");
                stringBuffer2.append(") ");
                stringBuffer.append(stringBuffer2);
                StatementContext statementContext2 = languageConnectionContext.getStatementContext();
                Activation activation = null;
                if (statementContext2 != null) {
                    activation = statementContext2.getActivation();
                }
                statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, false, stringBuffer.toString(), null, false, 0L);
                statementContext.setActivation(activation);
                PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
                Activation activation2 = preparedStatement.getActivation(languageConnectionContext, false);
                statementContext.setActivation(activation2);
                int n = 0;
                for (int i = 1; i <= resultDescription.getColumnCount(); ++i) {
                    if (!this.columnGotUpdated[i - 1]) continue;
                    activation2.getParameterValueSet().getParameterForSet(n++).setValue(this.updateRow.getColumn(i));
                }
                ResultSet resultSet = preparedStatement.executeSubStatement(cursorActivation, activation2, true, 0L);
                activation2.close();
                languageConnectionContext.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                if (statementContext != null) {
                    languageConnectionContext.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable throwable) {
                try {
                    throw this.closeOnTransactionError(throwable);
                }
                catch (Throwable throwable2) {
                    if (statementContext != null) {
                        languageConnectionContext.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    throw throwable2;
                }
            }
            this.restoreContextStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            StatementContext statementContext;
            LanguageConnectionContext languageConnectionContext;
            block17: {
                block18: {
                    this.checksBeforeUpdateOrDelete("updateRow", -1);
                    this.checkNotOnInsertRow();
                    this.setupContextStack();
                    languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
                    statementContext = null;
                    if (this.currentRowHasBeenUpdated) break block17;
                    if (statementContext == null) break block18;
                    languageConnectionContext.popStatementContext(statementContext, null);
                }
                this.restoreContextStack();
                this.initializeUpdateRowModifiers();
                return;
            }
            try {
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer("UPDATE ");
                CursorActivation cursorActivation = languageConnectionContext.lookupCursorActivation(this.getCursorName());
                ExecCursorTableReference execCursorTableReference = cursorActivation.getPreparedStatement().getTargetTable();
                stringBuffer.append(this.getFullBaseTableName(execCursorTableReference));
                stringBuffer.append(" SET ");
                ResultDescription resultDescription = this.theResults.getResultDescription();
                for (int i = 1; i <= resultDescription.getColumnCount(); ++i) {
                    if (!this.columnGotUpdated[i - 1]) continue;
                    if (bl) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(IdUtil.normalToDelimited(resultDescription.getColumnDescriptor(i).getName()) + "=?");
                    bl = true;
                }
                stringBuffer.append(" WHERE CURRENT OF " + IdUtil.normalToDelimited(this.getCursorName()));
                StatementContext statementContext2 = languageConnectionContext.getStatementContext();
                Activation activation = null;
                if (statementContext2 != null) {
                    activation = statementContext2.getActivation();
                }
                statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, false, stringBuffer.toString(), null, false, 0L);
                statementContext.setActivation(activation);
                PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
                Activation activation2 = preparedStatement.getActivation(languageConnectionContext, false);
                statementContext.setActivation(activation2);
                int n = 0;
                for (int i = 1; i <= resultDescription.getColumnCount(); ++i) {
                    if (!this.columnGotUpdated[i - 1]) continue;
                    activation2.getParameterValueSet().getParameterForSet(n++).setValue(this.updateRow.getColumn(i));
                }
                ResultSet resultSet = preparedStatement.executeSubStatement(cursorActivation, activation2, true, 0L);
                SQLWarning sQLWarning = activation2.getWarnings();
                if (sQLWarning != null) {
                    this.addWarning(sQLWarning);
                }
                activation2.close();
                if (this.getType() == 1003) {
                    this.currentRow = null;
                } else {
                    this.movePosition(8, 0, "relative");
                }
                languageConnectionContext.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                if (statementContext != null) {
                    languageConnectionContext.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable throwable) {
                try {
                    throw this.closeOnTransactionError(throwable);
                }
                catch (Throwable throwable2) {
                    if (statementContext != null) {
                        languageConnectionContext.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    this.initializeUpdateRowModifiers();
                    throw throwable2;
                }
            }
            this.restoreContextStack();
            this.initializeUpdateRowModifiers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.checksBeforeUpdateOrDelete("deleteRow", -1);
            this.checkNotOnInsertRow();
            this.setupContextStack();
            LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
            StatementContext statementContext = null;
            try {
                StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
                CursorActivation cursorActivation = languageConnectionContext.lookupCursorActivation(this.getCursorName());
                stringBuffer.append(this.getFullBaseTableName(cursorActivation.getPreparedStatement().getTargetTable()));
                stringBuffer.append(" WHERE CURRENT OF " + IdUtil.normalToDelimited(this.getCursorName()));
                StatementContext statementContext2 = languageConnectionContext.getStatementContext();
                Activation activation = null;
                if (statementContext2 != null) {
                    activation = statementContext2.getActivation();
                }
                statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, false, stringBuffer.toString(), null, false, 0L);
                statementContext.setActivation(activation);
                PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
                Activation activation2 = preparedStatement.getActivation(languageConnectionContext, false);
                statementContext.setActivation(activation2);
                ResultSet resultSet = preparedStatement.executeSubStatement(cursorActivation, activation2, true, 0L);
                SQLWarning sQLWarning = activation2.getWarnings();
                if (sQLWarning != null) {
                    this.addWarning(sQLWarning);
                }
                activation2.close();
                this.currentRow = null;
                languageConnectionContext.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                if (statementContext != null) {
                    languageConnectionContext.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable throwable) {
                try {
                    throw this.closeOnTransactionError(throwable);
                }
                catch (Throwable throwable2) {
                    if (statementContext != null) {
                        languageConnectionContext.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    this.initializeUpdateRowModifiers();
                    throw throwable2;
                }
            }
            this.restoreContextStack();
            this.initializeUpdateRowModifiers();
        }
    }

    private String getFullBaseTableName(ExecCursorTableReference execCursorTableReference) {
        return IdUtil.mkQualifiedName(execCursorTableReference.getSchemaName(), execCursorTableReference.getBaseName());
    }

    public void refreshRow() throws SQLException {
        throw Util.notImplemented();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checksBeforeUpdateOrDelete("cancelRowUpdates", -1);
        this.checkNotOnInsertRow();
        this.initializeUpdateRowModifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        this.checkExecIfClosed("moveToInsertRow");
        this.checkUpdatableCursor("moveToInsertRow");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack();
                this.initializeUpdateRowModifiers();
                this.isOnInsertRow = true;
                for (int i = 1; i <= this.columnGotUpdated.length; ++i) {
                    this.updateRow.setColumn(i, this.resultDescription.getColumnDescriptor(i).getType().getNull());
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.getEmbedConnection().getLanguageConnection());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        this.checkExecIfClosed("moveToCurrentRow");
        this.checkUpdatableCursor("moveToCurrentRow");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                if (this.isOnInsertRow) {
                    this.initializeUpdateRowModifiers();
                    this.isOnInsertRow = false;
                }
                InterruptStatus.restoreIntrFlagIfSeen();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Blob getBlob(int n) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getBlob");
        this.useStreamOrLOB(n);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int n2 = this.getColumnType(n);
            if (n2 != 2004) {
                throw this.dataTypeConversion("java.sql.Blob", n);
            }
            boolean bl = false;
            try {
                DataValueDescriptor dataValueDescriptor = this.getColumn(n);
                EmbedConnection embedConnection = this.getEmbedConnection();
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    Blob blob = null;
                    return blob;
                }
                if (dataValueDescriptor.hasStream()) {
                    bl = true;
                }
                if (bl) {
                    this.setupContextStack();
                }
                EmbedBlob embedBlob = new EmbedBlob(dataValueDescriptor, embedConnection);
                EmbedResultSet.restoreIntrFlagIfSeen(bl, embedConnection);
                EmbedBlob embedBlob2 = embedBlob;
                return embedBlob2;
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Clob getClob(int n) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getClob");
        this.useStreamOrLOB(n);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int n2 = this.getColumnType(n);
            if (n2 != 2005) {
                throw this.dataTypeConversion("java.sql.Clob", n);
            }
            boolean bl = false;
            EmbedConnection embedConnection = this.getEmbedConnection();
            try {
                StringDataValue stringDataValue = (StringDataValue)this.getColumn(n);
                LanguageConnectionContext languageConnectionContext = embedConnection.getLanguageConnection();
                this.wasNull = stringDataValue.isNull();
                if (this.wasNull) {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    Clob clob = null;
                    return clob;
                }
                if (stringDataValue.hasStream()) {
                    bl = true;
                    this.setupContextStack();
                }
                EmbedClob embedClob = new EmbedClob(embedConnection, stringDataValue);
                EmbedResultSet.restoreIntrFlagIfSeen(bl, embedConnection);
                EmbedClob embedClob2 = embedClob;
                return embedClob2;
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    public final Blob getBlob(String string2) throws SQLException {
        this.checkIfClosed("getBlob");
        return this.getBlob(this.findColumnName(string2));
    }

    public final Clob getClob(String string2) throws SQLException {
        this.checkIfClosed("getClob");
        return this.getClob(this.findColumnName(string2));
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", n);
        int n2 = this.getColumnType(n);
        if (n2 != 2004) {
            throw this.dataTypeConversion(n, "java.sql.Blob");
        }
        if (blob == null) {
            this.updateNull(n);
        } else {
            long l = blob.length();
            this.updateBinaryStreamInternal(n, blob.getBinaryStream(), false, l, "updateBlob");
        }
    }

    public void updateBlob(String string2, Blob blob) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(string2), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", n);
        int n2 = this.getColumnType(n);
        if (n2 != 2005) {
            throw this.dataTypeConversion(n, "java.sql.Clob");
        }
        if (clob == null) {
            this.updateNull(n);
        } else {
            long l = clob.length();
            this.updateCharacterStreamInternal(n, clob.getCharacterStream(), false, l, "updateClob");
        }
    }

    public void updateClob(String string2, Clob clob) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(string2), clob);
    }

    protected int findColumnName(String string2) throws SQLException {
        if (string2 == null) {
            throw this.newSQLException("XJ018.S");
        }
        int n = this.resultDescription.findColumnInsenstive(string2);
        if (n == -1) {
            throw this.newSQLException("S0022", string2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCurrentStream() {
        if (this.currentStream != null) {
            try {
                EmbedResultSet embedResultSet = this;
                synchronized (embedResultSet) {
                    if (this.currentStream != null) {
                        if (this.currentStream instanceof Reader) {
                            ((Reader)this.currentStream).close();
                        } else {
                            ((InputStream)this.currentStream).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.currentStream = null;
            }
        }
    }

    final void checkIfClosed(String string2) throws SQLException {
        if (this.isClosed || this.theResults.isClosed()) {
            if (!this.isClosed) {
                this.closeCurrentStream();
                this.markClosed();
            }
            throw this.newSQLException("XCL16.S", string2);
        }
    }

    final void checkExecIfClosed(String string2) throws SQLException {
        this.checkIfClosed(string2);
        Connection connection = this.getEmbedConnection().getApplicationConnection();
        if (connection == null) {
            throw Util.noCurrentConnection();
        }
        if (connection.isClosed()) {
            this.closeCurrentStream();
            this.markClosed();
            throw Util.noCurrentConnection();
        }
    }

    protected String getSQLText() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getSQLText();
    }

    protected ParameterValueSet getParameterValueSet() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getParameterValueSet();
    }

    private static boolean isMaxFieldSizeType(int n) {
        return n == -2 || n == -3 || n == -4 || n == 1 || n == 12 || n == -1;
    }

    final SQLException closeOnTransactionError(Throwable throwable) throws SQLException {
        StandardException standardException;
        int n;
        SQLException sQLException = this.handleException(throwable);
        if (throwable instanceof StandardException && (n = (standardException = (StandardException)throwable).getSeverity()) == 30000) {
            try {
                this.close();
            }
            catch (Throwable throwable2) {
                sQLException.setNextException(this.handleException(throwable2));
            }
        }
        return sQLException;
    }

    protected final DataValueDescriptor getColumn(int n) throws SQLException, StandardException {
        this.closeCurrentStream();
        if (n < 1 || n > this.resultDescription.getColumnCount()) {
            throw this.newSQLException("S0022", new Integer(n));
        }
        if (this.isOnInsertRow || this.currentRowHasBeenUpdated && this.columnGotUpdated[n - 1]) {
            return this.updateRow.getColumn(n);
        }
        this.checkOnRow();
        return this.currentRow.getColumn(n);
    }

    static final SQLException noStateChangeException(Throwable throwable) {
        return TransactionResourceImpl.wrapInSQLException(throwable);
    }

    void setDynamicResultSet(EmbedStatement embedStatement) {
        if (embedStatement != null) {
            this.owningStmt = embedStatement;
            this.applicationStmt = embedStatement.applicationStatement;
            this.localConn = embedStatement.getEmbedConnection();
        } else {
            this.localConn = this.localConn.rootConnection;
        }
        this.singleUseActivation = this.theResults.getActivation();
    }

    public final int compareTo(Object object) {
        EmbedResultSet embedResultSet = (EmbedResultSet)object;
        return this.order - embedResultSet.order;
    }

    private void checkScrollCursor(String string2) throws SQLException {
        this.checkIfClosed(string2);
        if (this.stmt.getResultSetType() == 1003) {
            throw Util.newEmbedSQLException("XJ061.S", new Object[]{string2}, StandardException.getSeverityFromIdentifier("XJ061.S"));
        }
    }

    private void checkUpdatableCursor(String string2) throws SQLException {
        if (this.getConcurrency() != 1008) {
            throw Util.generateCsSQLException("XJ083.U", string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRowPosition(int n, String string2) throws SQLException {
        this.checkScrollCursor(string2);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            LanguageConnectionContext languageConnectionContext = this.getEmbedConnection().getLanguageConnection();
            try {
                StatementContext statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, 0L);
                boolean bl = this.theResults.checkRowPosition(n);
                languageConnectionContext.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                boolean bl2 = bl;
                return bl2;
            }
            catch (Throwable throwable) {
                throw this.closeOnTransactionError(throwable);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean isForUpdate() {
        if (this.theResults instanceof NoPutResultSet) {
            return ((NoPutResultSet)this.theResults).isForUpdate();
        }
        return false;
    }

    final String getColumnSQLType(int n) {
        return this.resultDescription.getColumnDescriptor(n).getType().getTypeId().getSQLTypeName();
    }

    private final int getMaxColumnWidth(int n) {
        return this.resultDescription.getColumnDescriptor(n).getType().getMaximumWidth();
    }

    private final SQLException dataTypeConversion(String string2, int n) {
        return this.newSQLException("22005", string2, this.getColumnSQLType(n));
    }

    private final SQLException dataTypeConversion(int n, String string2) {
        return this.newSQLException("22005", this.getColumnSQLType(n), string2);
    }

    final void useStreamOrLOB(int n) throws SQLException {
        this.checkLOBMultiCall(n);
        this.columnUsedFlags[n - 1] = true;
    }

    private void checkLOBMultiCall(int n) throws SQLException {
        if (this.columnUsedFlags == null) {
            this.columnUsedFlags = new boolean[this.getMetaData().getColumnCount()];
        } else if (this.columnUsedFlags[n - 1]) {
            throw this.newSQLException("XCL18.S");
        }
    }

    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            this.checkExecIfClosed("");
            return false;
        }
        catch (SQLException sQLException) {
            return this.isClosed;
        }
    }

    private void addWarning(SQLWarning sQLWarning) {
        if (this.topWarning == null) {
            this.topWarning = sQLWarning;
        } else {
            this.topWarning.setNextWarning(sQLWarning);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(n, inputStream, (long)n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(n, inputStream, (long)n2);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(n, reader, (long)n2);
    }

    public void updateAsciiStream(String string2, InputStream inputStream, long l) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(string2), inputStream, l);
    }

    public void updateAsciiStream(String string2, InputStream inputStream) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(string2), inputStream);
    }

    public void updateBinaryStream(String string2, InputStream inputStream, long l) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(string2), inputStream, l);
    }

    public void updateBinaryStream(String string2, InputStream inputStream) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(string2), inputStream);
    }

    public void updateCharacterStream(String string2, Reader reader, long l) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(string2), reader, l);
    }

    public void updateCharacterStream(String string2, Reader reader) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(string2), reader);
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", n);
        int n2 = this.getColumnType(n);
        if (n2 != 2004) {
            throw this.dataTypeConversion(n, "java.sql.Blob");
        }
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            this.updateBinaryStreamInternal(n, inputStream, false, l, "updateBlob");
        }
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", n);
        int n2 = this.getColumnType(n);
        if (n2 != 2004) {
            throw this.dataTypeConversion(n, "java.sql.Blob");
        }
        this.updateBinaryStreamInternal(n, inputStream, true, -1L, "updateBlob");
    }

    public void updateBlob(String string2, InputStream inputStream, long l) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(string2), inputStream, l);
    }

    public void updateBlob(String string2, InputStream inputStream) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(string2), inputStream);
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", n);
        int n2 = this.getColumnType(n);
        if (n2 != 2005) {
            throw this.dataTypeConversion(n, "java.sql.Clob");
        }
        if (reader == null) {
            this.updateNull(n);
        } else {
            this.updateCharacterStreamInternal(n, reader, false, l, "updateClob");
        }
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", n);
        int n2 = this.getColumnType(n);
        if (n2 != 2005) {
            throw this.dataTypeConversion(n, "java.sql.Clob");
        }
        this.updateCharacterStreamInternal(n, reader, true, -1L, "updateClob");
    }

    public void updateClob(String string2, Reader reader, long l) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(string2), reader, l);
    }

    public void updateClob(String string2, Reader reader) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(string2), reader);
    }

    public boolean isNull(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            return dataValueDescriptor.isNull();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public int getLength(int n) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n);
            return dataValueDescriptor.getLength();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }
}

