/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.File;

public class PathUtil {
    public static final char SEP = File.separatorChar;
    public static final String SEP_STR = String.valueOf(SEP);

    private PathUtil() {
    }

    private static void basicPathChecks(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Path is null");
        }
        if (!string2.equals(string2.trim())) {
            throw new IllegalArgumentException("Path has not been trimmed: '" + string2 + "'");
        }
    }

    public static String getBaseName(String string2) {
        PathUtil.basicPathChecks(string2);
        int n = string2.lastIndexOf(SEP);
        if (n != -1 && n != string2.length() - 1) {
            return string2.substring(n + 1);
        }
        return string2;
    }

    public static String getParent(String string2) {
        int n;
        PathUtil.basicPathChecks(string2);
        if (string2.equals(SEP_STR)) {
            return null;
        }
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == SEP) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((n = string2.lastIndexOf(SEP)) == 0) {
            return SEP_STR;
        }
        if (n > 0) {
            return string2.substring(0, n);
        }
        return null;
    }

    public static String join(String string2, String string3) {
        if (string2.charAt(string2.length() - 1) == SEP) {
            return string2 + string3;
        }
        return string2 + SEP + string3;
    }
}

