/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derby.io.StorageFile;

public final class DataStore {
    private static final char SEP = PathUtil.SEP;
    private static final String[] EMPTY_STR_ARR = new String[0];
    private final Object LOCK = new Object();
    private final Object TMP_COUNTER_LOCK = new Object();
    private final Map files = new HashMap(80);
    private final String databaseName;
    private long tmpFileCounter = 0L;
    private boolean deleteMe;

    public DataStore(String string2) {
        this.databaseName = string2;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean scheduledForDeletion() {
        return this.deleteMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreEntry createEntry(String string2, boolean bl) {
        String string3 = new File(string2).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.files.containsKey(string3)) {
                return null;
            }
            String[] stringArray = this.getParentList(string3);
            for (int i = stringArray.length - 1; i >= 0; --i) {
                DataStoreEntry dataStoreEntry = (DataStoreEntry)this.files.get(stringArray[i]);
                if (dataStoreEntry == null) {
                    return null;
                }
                if (dataStoreEntry.isDirectory()) continue;
                return null;
            }
            DataStoreEntry dataStoreEntry = new DataStoreEntry(string3, bl);
            this.files.put(string3, dataStoreEntry);
            return dataStoreEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createAllParents(String string2) {
        String string3 = new File(string2).getPath();
        String[] stringArray = this.getParentList(string3);
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                String string4 = stringArray[i];
                DataStoreEntry dataStoreEntry = (DataStoreEntry)this.files.get(string4);
                if (dataStoreEntry == null) {
                    this.createEntry(string4, true);
                    continue;
                }
                if (dataStoreEntry.isDirectory()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntry(String string2) {
        DataStoreEntry dataStoreEntry;
        String string3 = new File(string2).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            dataStoreEntry = (DataStoreEntry)this.files.remove(string3);
            if (dataStoreEntry != null) {
                if (dataStoreEntry.isDirectory()) {
                    String[] stringArray = this.listChildren(string3);
                    if (stringArray.length > 0) {
                        this.files.put(string3, dataStoreEntry);
                        return false;
                    }
                    if (string3.equals(this.databaseName) && this.files.get(this.databaseName) == null) {
                        this.deleteMe = true;
                    }
                }
                dataStoreEntry.release();
            }
        }
        return dataStoreEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreEntry getEntry(String string2) {
        Object object = this.LOCK;
        synchronized (object) {
            return (DataStoreEntry)this.files.get(new File(string2).getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAll(String string2) {
        String string3 = new File(string2).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            DataStoreEntry dataStoreEntry = (DataStoreEntry)this.files.remove(string3);
            if (dataStoreEntry == null) {
                return false;
            }
            if (dataStoreEntry.isDirectory()) {
                boolean bl = this._deleteAll(string3);
                if (this.files.get(this.databaseName) == null) {
                    this.deleteMe = true;
                }
                return bl;
            }
            dataStoreEntry.release();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listChildren(String string2) {
        if (string2.equals("")) {
            throw new IllegalArgumentException("The empty string is not a valid path");
        }
        String string3 = new File(string2).getPath();
        if (string3.charAt(string3.length() - 1) != SEP) {
            string3 = string3 + SEP;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.LOCK;
        synchronized (object) {
            Iterator iterator2 = this.files.keySet().iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                if (!string4.startsWith(string3)) continue;
                arrayList.add(string4.substring(string3.length()));
            }
        }
        return arrayList.toArray(EMPTY_STR_ARR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(StorageFile storageFile, StorageFile storageFile2) {
        String string2 = new File(storageFile.getPath()).getPath();
        String string3 = new File(storageFile2.getPath()).getPath();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.files.containsKey(string3)) {
                return false;
            }
            DataStoreEntry dataStoreEntry = (DataStoreEntry)this.files.remove(string2);
            if (dataStoreEntry == null) {
                return false;
            }
            this.files.put(string3, dataStoreEntry);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object = this.LOCK;
        synchronized (object) {
            Iterator iterator2 = this.files.values().iterator();
            while (iterator2.hasNext()) {
                ((DataStoreEntry)iterator2.next()).release();
            }
            this.files.clear();
        }
    }

    private boolean _deleteAll(String string2) {
        Object object;
        if (string2.charAt(string2.length() - 1) != SEP) {
            string2 = string2 + SEP;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator2 = this.files.keySet().iterator();
        while (iterator2.hasNext()) {
            object = (String)iterator2.next();
            if (!((String)object).startsWith(string2)) continue;
            arrayList.add(object);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            DataStoreEntry dataStoreEntry = (DataStoreEntry)this.files.remove((String)object.next());
            dataStoreEntry.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTempFileCounter() {
        Object object = this.TMP_COUNTER_LOCK;
        synchronized (object) {
            return ++this.tmpFileCounter;
        }
    }

    private String[] getParentList(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = string2;
        while ((string3 = new File(string3).getParent()) != null) {
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

