/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import org.apache.derby.impl.io.vfmem.BlockedByteArrayInputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayOutputStream;

public class BlockedByteArray {
    private static final int _4K = 4096;
    private static final int _8K = 8192;
    private static final int _16K = 16384;
    private static final int _32K = 32768;
    private static final int DEFAULT_BLOCKSIZE = 4096;
    private static final int INITIAL_BLOCK_HOLDER_SIZE = 1024;
    private static final int MIN_HOLDER_GROWTH = 1024;
    private byte[][] blocks = new byte[1024][];
    private int blockSize;
    private int allocatedBlocks;
    private long length;

    public synchronized int read(long l) {
        if (l < this.length) {
            int n = (int)(l / (long)this.blockSize);
            int n2 = (int)(l % (long)this.blockSize);
            return this.blocks[n][n2] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(long l, byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (l >= this.length) {
            return -1;
        }
        n2 = (int)Math.min((long)n2, this.length - l);
        int n3 = (int)(l / (long)this.blockSize);
        int n4 = (int)(l % (long)this.blockSize);
        int n5 = 0;
        while (n5 < n2) {
            int n6 = Math.min(n2 - n5, this.blockSize - n4);
            System.arraycopy(this.blocks[n3], n4, byArray, n + n5, n6);
            n5 += n6;
            ++n3;
            n4 = 0;
        }
        return n5;
    }

    public synchronized long length() {
        return this.length;
    }

    public synchronized void setLength(long l) {
        long l2;
        if (this.blockSize == 0) {
            this.checkBlockSize((int)Math.min(Integer.MAX_VALUE, l));
        }
        if (l > (l2 = (long)this.allocatedBlocks * (long)this.blockSize)) {
            this.increaseCapacity(l);
        } else if (l < l2) {
            if (l <= 0L) {
                this.allocatedBlocks = 0;
                this.blocks = new byte[1024][];
            } else {
                int n;
                for (int i = n = (int)(l / (long)this.blockSize) + 1; i <= this.allocatedBlocks; ++i) {
                    this.blocks[i] = null;
                }
                this.allocatedBlocks = Math.min(this.allocatedBlocks, n);
            }
        }
        this.length = Math.max(0L, l);
    }

    public synchronized int writeBytes(long l, byte[] byArray, int n, int n2) {
        if (this.blockSize == 0) {
            this.checkBlockSize(n2);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.increaseCapacity(l + (long)n2);
        int n3 = (int)(l / (long)this.blockSize);
        int n4 = (int)(l % (long)this.blockSize);
        int n5 = 0;
        while (n5 < n2) {
            int n6 = Math.min(n2 - n5, this.blockSize - n4);
            System.arraycopy(byArray, n, this.blocks[n3], n4, n6);
            n += n6;
            if ((n5 += n6) < n2) {
                ++n3;
                n4 = 0;
                continue;
            }
            n4 += n6;
        }
        this.length = Math.max(this.length, l + (long)n2);
        return n5;
    }

    public synchronized int writeByte(long l, byte by2) {
        if (this.blockSize == 0) {
            this.checkBlockSize(0);
        }
        this.increaseCapacity(l);
        int n = (int)(l / (long)this.blockSize);
        int n2 = (int)(l % (long)this.blockSize);
        this.blocks[n][n2] = by2;
        this.length = Math.max(this.length, l + 1L);
        return 1;
    }

    synchronized BlockedByteArrayInputStream getInputStream() {
        return new BlockedByteArrayInputStream(this, 0L);
    }

    synchronized BlockedByteArrayOutputStream getOutputStream(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Position cannot be negative: " + l);
        }
        return new BlockedByteArrayOutputStream(this, l);
    }

    synchronized void release() {
        this.blocks = null;
        this.allocatedBlocks = -1;
        this.length = -1;
    }

    private void checkBlockSize(int n) {
        this.blockSize = n == 4096 || n == 8192 || n == 16384 || n == 32768 ? n : 4096;
    }

    private void increaseCapacity(long l) {
        int n;
        if (l < (long)this.allocatedBlocks * (long)this.blockSize) {
            return;
        }
        int n2 = (int)(l / (long)this.blockSize) + 1;
        if (n2 > this.blocks.length) {
            n = Math.max(this.blocks.length + this.blocks.length / 3, n2 + 1024);
            byte[][] byArray = this.blocks;
            this.blocks = new byte[n][];
            System.arraycopy(byArray, 0, this.blocks, 0, this.allocatedBlocks);
        }
        for (n = this.allocatedBlocks; n < n2; ++n) {
            this.blocks[n] = new byte[this.blockSize];
        }
        this.allocatedBlocks = n2;
    }
}

