/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.impl.io.JarStorageFactory;
import org.apache.derby.io.StorageFile;

class JarDBFile
extends InputStreamFile {
    private final JarStorageFactory storageFactory;

    JarDBFile(JarStorageFactory jarStorageFactory, String string2) {
        super(jarStorageFactory, string2);
        this.storageFactory = jarStorageFactory;
    }

    JarDBFile(JarStorageFactory jarStorageFactory, String string2, String string3) {
        super((BaseStorageFactory)jarStorageFactory, string2, string3);
        this.storageFactory = jarStorageFactory;
    }

    JarDBFile(JarDBFile jarDBFile, String string2) {
        super(jarDBFile, string2);
        this.storageFactory = jarDBFile.storageFactory;
    }

    private JarDBFile(JarStorageFactory jarStorageFactory, String string2, int n) {
        super((BaseStorageFactory)jarStorageFactory, string2, n);
        this.storageFactory = jarStorageFactory;
    }

    public boolean exists() {
        return this.getEntry() != null;
    }

    private ZipEntry getEntry() {
        return this.storageFactory.zipData.getEntry(this.path);
    }

    public long length() {
        ZipEntry zipEntry = this.getEntry();
        if (zipEntry == null) {
            return 0L;
        }
        return zipEntry.getSize();
    }

    StorageFile getParentDir(int n) {
        return new JarDBFile(this.storageFactory, this.path, n);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        ZipEntry zipEntry = this.getEntry();
        if (zipEntry == null) {
            throw new FileNotFoundException(this.path);
        }
        try {
            return this.storageFactory.zipData.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(this.path);
        }
    }

    public String toString() {
        return this.path;
    }

    public URL getURL() throws MalformedURLException {
        File file = new File(this.storageFactory.zipData.getName());
        String string2 = file.toURL().toString();
        return new URL("jar:" + string2 + "!/" + this.path);
    }
}

