/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SyncFailedException;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public class DirStorageFactory
extends BaseStorageFactory
implements WritableStorageFactory {
    public final StorageFile newStorageFile(String string2) {
        return this.newPersistentFile(string2);
    }

    public final StorageFile newStorageFile(String string2, String string3) {
        return this.newPersistentFile(string2, string3);
    }

    public final StorageFile newStorageFile(StorageFile storageFile, String string2) {
        return this.newPersistentFile(storageFile, string2);
    }

    StorageFile newPersistentFile(String string2) {
        if (string2 == null) {
            return new DirFile(this.dataDirectory);
        }
        return new DirFile(this.dataDirectory, string2);
    }

    StorageFile newPersistentFile(String string2, String string3) {
        return new DirFile(this.separatedDataDirectory + string2, string3);
    }

    StorageFile newPersistentFile(StorageFile storageFile, String string2) {
        return new DirFile((DirFile)storageFile, string2);
    }

    public void sync(OutputStream outputStream, boolean bl) throws IOException, SyncFailedException {
        ((FileOutputStream)outputStream).getFD().sync();
    }

    public boolean supportsWriteSync() {
        return false;
    }

    public boolean isReadOnlyDatabase() {
        return false;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    void doInit() throws IOException {
        if (this.dataDirectory != null) {
            File file = new File(this.dataDirectory);
            File file2 = null;
            if (file.isAbsolute()) {
                file2 = file;
            } else if (this.home != null && this.dataDirectory.startsWith(this.home)) {
                file2 = file;
            } else {
                file2 = new File(this.home, this.dataDirectory);
                if (this.home != null) {
                    this.dataDirectory = this.home + this.getSeparator() + this.dataDirectory;
                }
            }
            this.canonicalName = file2.getCanonicalPath();
            this.createTempDir();
            this.separatedDataDirectory = this.dataDirectory + this.getSeparator();
        } else if (this.home != null) {
            File file = new File(this.home);
            this.dataDirectory = file.getCanonicalPath();
            this.separatedDataDirectory = this.dataDirectory + this.getSeparator();
        }
    }
}

