/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.io.DirRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class DirFile
extends File
implements StorageFile {
    DirFile(String string2) {
        super(string2);
    }

    DirFile(String string2, String string3) {
        super(string2, string3);
    }

    DirFile(DirFile dirFile, String string2) {
        super(dirFile, string2);
    }

    public StorageFile getParentDir() {
        String string2 = this.getParent();
        if (string2 == null) {
            return null;
        }
        return new DirFile(string2);
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        boolean bl = this.exists();
        FileOutputStream fileOutputStream = new FileOutputStream(this);
        if (!bl) {
            FileUtil.limitAccessToOwner(this);
        }
        return fileOutputStream;
    }

    public OutputStream getOutputStream(boolean bl) throws FileNotFoundException {
        boolean bl2 = this.exists();
        FileOutputStream fileOutputStream = new FileOutputStream(this.getPath(), bl);
        if (!bl2) {
            FileUtil.limitAccessToOwner(this);
        }
        return fileOutputStream;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this);
    }

    public synchronized int getExclusiveFileLock() throws StandardException {
        if (this.exists()) {
            this.delete();
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this, "rw");
            this.limitAccessToOwner();
            randomAccessFile.getFD().sync();
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public synchronized void releaseExclusiveFileLock() {
        if (this.exists()) {
            this.delete();
        }
    }

    public StorageRandomAccessFile getRandomAccessFile(String string2) throws FileNotFoundException {
        if ("rws".equals(string2) || "rwd".equals(string2)) {
            string2 = "rw";
        }
        return new DirRandomAccessFile(this, string2);
    }

    public boolean renameTo(StorageFile storageFile) {
        boolean bl = super.renameTo((File)((Object)storageFile));
        for (int i = 1; !bl && i <= 5; ++i) {
            try {
                Thread.sleep(1000 * i);
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
            }
            bl = super.renameTo((File)((Object)storageFile));
        }
        return bl;
    }

    public boolean deleteAll() {
        if (!this.exists()) {
            return false;
        }
        if (this.isDirectory()) {
            String[] stringArray = super.list();
            String string2 = this.getPath();
            for (int i = 0; i < stringArray.length; ++i) {
                DirFile dirFile;
                if (stringArray[i].equals(".") || stringArray[i].equals("..") || (dirFile = new DirFile(string2, stringArray[i])).deleteAll()) continue;
                return false;
            }
        }
        return this.delete();
    }

    public URL getURL() throws MalformedURLException {
        return this.toURL();
    }

    public void limitAccessToOwner() {
        FileUtil.limitAccessToOwner(this);
    }
}

