/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.IOException;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;

abstract class BaseStorageFactory
implements StorageFactory {
    String home;
    protected StorageFile tempDir;
    protected String tempDirPath;
    protected String dataDirectory;
    protected String separatedDataDirectory;
    protected String uniqueName;
    protected String canonicalName;
    private static final String TEMP_DIR_PREFIX = "derbytmp_";

    BaseStorageFactory() {
    }

    public void init(String string2, String string3, String string4, String string5) throws IOException {
        if (string3 != null) {
            this.dataDirectory = string3;
            this.separatedDataDirectory = string3 + this.getSeparator();
        }
        this.home = string2;
        this.uniqueName = string5;
        this.tempDirPath = string4;
        this.doInit();
    }

    abstract void doInit() throws IOException;

    public void shutdown() {
    }

    public String getCanonicalName() throws IOException {
        return this.canonicalName;
    }

    public void setCanonicalName(String string2) {
        this.canonicalName = string2;
    }

    public StorageFile newStorageFile(String string2) {
        if (string2 != null && this.tempDirPath != null && string2.startsWith(this.tempDirPath)) {
            return new DirFile(string2);
        }
        return this.newPersistentFile(string2);
    }

    public StorageFile newStorageFile(String string2, String string3) {
        if (string2 == null) {
            return this.newStorageFile(string3);
        }
        if (this.tempDirPath != null && string2.startsWith(this.tempDirPath)) {
            return new DirFile(string2, string3);
        }
        return this.newPersistentFile(string2, string3);
    }

    public StorageFile newStorageFile(StorageFile storageFile, String string2) {
        if (storageFile == null) {
            return this.newStorageFile(string2);
        }
        if (string2 == null) {
            return storageFile;
        }
        if (this.tempDirPath != null && storageFile.getPath().startsWith(this.tempDirPath)) {
            return new DirFile((DirFile)storageFile, string2);
        }
        return this.newPersistentFile(storageFile, string2);
    }

    abstract StorageFile newPersistentFile(String var1);

    abstract StorageFile newPersistentFile(String var1, String var2);

    abstract StorageFile newPersistentFile(StorageFile var1, String var2);

    public char getSeparator() {
        return File.separatorChar;
    }

    public StorageFile getTempDir() {
        return this.tempDir;
    }

    public boolean isFast() {
        return false;
    }

    public boolean isReadOnlyDatabase() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    void createTempDir() throws IOException {
        if (this.uniqueName == null) {
            return;
        }
        this.tempDir = this.tempDirPath != null ? new DirFile(this.tempDirPath, TEMP_DIR_PREFIX.concat(this.uniqueName)) : (this.isReadOnlyDatabase() ? new DirFile(this.readOnlyTempRoot(), TEMP_DIR_PREFIX.concat(this.uniqueName)) : new DirFile(this.canonicalName, "tmp"));
        this.tempDir.deleteAll();
        this.tempDir.mkdirs();
        this.tempDir.limitAccessToOwner();
        this.tempDirPath = this.tempDir.getPath();
    }

    private String readOnlyTempRoot() throws IOException {
        File file = File.createTempFile("derby", "tmp");
        String string2 = file.getParent();
        file.delete();
        return string2;
    }

    public int getStorageFactoryVersion() {
        return 1;
    }

    public StorageFile createTemporaryFile(String string2, String string3) throws IOException {
        File file = File.createTempFile(string2, string3, new File(this.getTempDir().getPath()));
        return this.newStorageFile(this.getTempDir(), file.getName());
    }
}

