/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.Locale;
import java.util.StringTokenizer;

public class StringUtil {
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String[] split(String string2, char c) {
        if (string2 == null) {
            throw new NullPointerException("str can't be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, String.valueOf(c));
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static final String formatForPrint(String string2) {
        if (string2.length() > 60) {
            StringBuffer stringBuffer = new StringBuffer(string2.substring(0, 60));
            stringBuffer.append("&");
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String[] toStringArray(Object[] objectArray) {
        int n = objectArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public static byte[] getAsciiBytes(String string2) {
        char[] cArray = string2.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)(cArray[i] & 0x7F);
        }
        return byArray;
    }

    public static String trimTrailing(String string2) {
        int n;
        if (string2 == null) {
            return null;
        }
        for (n = string2.length(); n > 0 && Character.isWhitespace(string2.charAt(n - 1)); --n) {
        }
        return string2.substring(0, n);
    }

    public static String truncate(String string2, int n) {
        if (string2 != null && string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String slice(String string2, int n, int n2, boolean bl) {
        String string3 = string2.substring(n, n2 + 1);
        if (bl) {
            string3 = string3.trim();
        }
        return string3;
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            int n4 = (byArray[i] & 0xF0) >>> 4;
            int n5 = byArray[i] & 0xF;
            stringBuffer.append(hex_table[n4]);
            stringBuffer.append(hex_table[n5]);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexString(String string2, int n, int n2) {
        if (n2 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; i += 2) {
            int n5 = Character.digit(string2.charAt(i), 16);
            int n6 = Character.digit(string2.charAt(i + 1), 16);
            if (n5 == -1 || n6 == -1) {
                return null;
            }
            byArray[n3++] = (byte)(n5 << 4 & 0xF0 | n6 & 0xF);
        }
        return byArray;
    }

    public static String hexDump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("Hex dump:\n");
        for (int i = 0; i < byArray.length; i += 16) {
            char c;
            int n;
            String string2 = Integer.toHexString(i);
            for (n = string2.length(); n < 8; ++n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string2);
            stringBuffer.append(":");
            for (n = 0; n < 16 && i + n < byArray.length; ++n) {
                byte by2 = byArray[i + n];
                if (n % 2 == 0) {
                    stringBuffer.append(" ");
                }
                c = (char)((by2 & 0xF0) >>> 4);
                byte by3 = (byte)(by2 & 0xF);
                stringBuffer.append(hex_table[c]);
                stringBuffer.append(hex_table[by3]);
            }
            stringBuffer.append("  ");
            for (n = 0; n < 16 && i + n < byArray.length; ++n) {
                c = (char)byArray[i + n];
                if (Character.isLetterOrDigit(c)) {
                    stringBuffer.append(String.valueOf(c));
                    continue;
                }
                stringBuffer.append(".");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String SQLToUpperCase(String string2) {
        return string2.toUpperCase(Locale.ENGLISH);
    }

    public static boolean SQLEqualsIgnoreCase(String string2, String string3) {
        if (string3 == null) {
            return false;
        }
        return StringUtil.SQLToUpperCase(string2).equals(StringUtil.SQLToUpperCase(string3));
    }

    public static String normalizeSQLIdentifier(String string2) {
        if (string2.length() == 0) {
            return string2;
        }
        if (string2.charAt(0) == '\"' && string2.length() >= 3 && string2.charAt(string2.length() - 1) == '\"') {
            return StringUtil.compressQuotes(string2.substring(1, string2.length() - 1), "\"\"");
        }
        return StringUtil.SQLToUpperCase(string2);
    }

    public static String compressQuotes(String string2, String string3) {
        String string4 = string2;
        int n = string4.indexOf(string3);
        while (n != -1) {
            string4 = string4.substring(0, n + 1) + string4.substring(n + 2);
            n = string4.indexOf(string3, n + 1);
        }
        return string4;
    }

    static String quoteString(String string2, char c) {
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 2);
        stringBuffer.append(c);
        for (int i = 0; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            if (c2 == c) {
                stringBuffer.append(c);
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    public static String quoteStringLiteral(String string2) {
        return StringUtil.quoteString(string2, '\'');
    }

    public static String stringify(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        stringBuffer.append("[ ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public static String ensureIndent(String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append("\t");
        }
        if (string2 == null) {
            return stringBuffer.toString() + "null";
        }
        string2 = StringUtil.doRegExpA(string2, stringBuffer.toString());
        string2 = StringUtil.doRegExpB(string2);
        string2 = StringUtil.doRegExpC(string2, stringBuffer.toString());
        return string2;
    }

    private static String doRegExpA(String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string2.length() && string2.charAt(n) == '\t'; ++n) {
        }
        stringBuffer.append(string3);
        stringBuffer.append(string2.substring(n));
        return stringBuffer.toString();
    }

    private static String doRegExpB(String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = string2.length() - 1; n >= 0 && string2.charAt(n) == '\n'; --n) {
        }
        stringBuffer.append(string2.substring(0, n + 1));
        return stringBuffer.toString();
    }

    private static String doRegExpC(String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c == '\n') {
                int n2;
                stringBuffer.append(c);
                for (n2 = n + 1; n2 < string2.length() && string2.charAt(n2) == '\t'; ++n2) {
                }
                stringBuffer.append(string3);
                n = n2;
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }
}

