/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.XMLDataValue;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathExpression;
import org.w3c.dom.xpath.XPathResult;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SqlXmlUtil {
    private DocumentBuilder dBuilder;
    private Transformer serializer;
    private XPathExpression query;
    private String queryExpr;
    private String opName;
    private boolean recompileQuery;
    private static final Method TO_PLAIN_STRING;

    public SqlXmlUtil() throws StandardException {
        try {
            DocumentBuilderFactory documentBuilderFactory = null;
            try {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            catch (Throwable throwable) {
                throw StandardException.newException("XML00", "JAXP");
            }
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            this.dBuilder = documentBuilderFactory.newDocumentBuilder();
            this.dBuilder.setErrorHandler(new XMLErrorHandler());
            this.loadSerializer();
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.newException("XML01", throwable, (Object)throwable.getMessage());
        }
        this.query = null;
    }

    public void compileXQExpr(String string2, String string3) throws StandardException {
        try {
            XPathEvaluator xPathEvaluator = (XPathEvaluator)this.dBuilder.getDOMImplementation().getFeature("+XPath", "3.0");
            this.query = xPathEvaluator.createExpression(string2, null);
            this.queryExpr = string2;
            this.opName = string3;
            this.recompileQuery = false;
        }
        catch (Throwable throwable) {
            throw StandardException.newException("10000", throwable, (Object)string3, (Object)throwable.getMessage());
        }
    }

    protected String serializeToString(String string2) throws Exception {
        ArrayList arrayList = new ArrayList();
        try {
            final InputSource inputSource = new InputSource(new StringReader(string2));
            arrayList.add(AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, SAXException {
                    return SqlXmlUtil.this.dBuilder.parse(inputSource);
                }
            }));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
        return this.serializeToString(arrayList, null);
    }

    protected String serializeToString(List list2, XMLDataValue xMLDataValue) throws TransformerException {
        if (list2 == null || list2.isEmpty()) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        int n = list2.size();
        Object var5_5 = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            var5_5 = list2.get(i);
            if (var5_5 instanceof String) {
                if (bl) {
                    stringWriter.write(" ");
                }
                stringWriter.write((String)var5_5);
                bl = true;
                continue;
            }
            if (var5_5 instanceof Attr) {
                if (xMLDataValue != null) {
                    xMLDataValue.markAsHavingTopLevelAttr();
                }
                this.serializer.transform(new DOMSource(var5_5), new StreamResult(stringWriter));
                bl = false;
                continue;
            }
            Node node = var5_5;
            if (node instanceof Text) {
                stringWriter.write(node.getNodeValue());
            } else {
                this.serializer.transform(new DOMSource(node), new StreamResult(stringWriter));
            }
            bl = false;
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    protected List evalXQExpression(XMLDataValue xMLDataValue, boolean bl, int[] nArray) throws Exception {
        List<String> list2;
        if (this.recompileQuery) {
            this.compileXQExpr(this.queryExpr, this.opName);
        }
        if (xMLDataValue.getXType() != 0) {
            throw StandardException.newException("2200V", bl ? "XMLQUERY" : "XMLEXISTS");
        }
        Document document2 = null;
        document2 = this.dBuilder.parse(new InputSource(new StringReader(xMLDataValue.getString())));
        XPathResult xPathResult = (XPathResult)this.query.evaluate(document2, (short)0, null);
        if (!bl) {
            switch (xPathResult.getResultType()) {
                case 4: 
                case 5: {
                    if (xPathResult.iterateNext() == null) {
                        return null;
                    }
                    return Collections.EMPTY_LIST;
                }
            }
            return Collections.EMPTY_LIST;
        }
        switch (xPathResult.getResultType()) {
            case 1: {
                String string2 = SqlXmlUtil.numberToString(xPathResult.getNumberValue());
                list2 = Collections.singletonList(string2);
                break;
            }
            case 2: {
                list2 = Collections.singletonList(xPathResult.getStringValue());
                break;
            }
            case 3: {
                list2 = Collections.singletonList(String.valueOf(xPathResult.getBooleanValue()));
                break;
            }
            case 4: 
            case 5: {
                Node node;
                list2 = new ArrayList<String>();
                while ((node = xPathResult.iterateNext()) != null) {
                    list2.add((String)((Object)node));
                }
                break;
            }
            default: {
                list2 = null;
            }
        }
        nArray[0] = list2.size() == 1 && list2.get(0) instanceof Document ? 0 : 1;
        return list2;
    }

    private void loadSerializer() throws TransformerConfigurationException {
        Properties properties = new Properties();
        properties.setProperty("method", "xml");
        properties.setProperty("omit-xml-declaration", "yes");
        properties.setProperty("encoding", "UTF-8");
        this.serializer = TransformerFactory.newInstance().newTransformer();
        this.serializer.setOutputProperties(properties);
    }

    private static String numberToString(double d) throws IllegalAccessException, InvocationTargetException {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        long l = bigDecimal.unscaledValue().longValue();
        int n = bigDecimal.scale();
        while (n > 0 && l % 10L == 0L) {
            --n;
            l /= 10L;
        }
        if (n != bigDecimal.scale()) {
            bigDecimal = BigDecimal.valueOf(l, n);
        }
        if (TO_PLAIN_STRING == null) {
            return bigDecimal.toString();
        }
        return (String)TO_PLAIN_STRING.invoke((Object)bigDecimal, (Object[])null);
    }

    static {
        Method method = null;
        try {
            method = BigDecimal.class.getMethod("toPlainString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        TO_PLAIN_STRING = method;
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }
    }
}

