/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Clob;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.CollatorSQLVarchar;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.StringDataValue;

public class SQLVarchar
extends SQLChar {
    public String getTypeName() {
        return "VARCHAR";
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        try {
            return new SQLVarchar(this.getString());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLVarchar();
    }

    public StringDataValue getValue(RuleBasedCollator ruleBasedCollator) {
        if (ruleBasedCollator == null) {
            return this;
        }
        CollatorSQLVarchar collatorSQLVarchar = new CollatorSQLVarchar(ruleBasedCollator);
        collatorSQLVarchar.copyState(this);
        return collatorSQLVarchar;
    }

    public int getTypeFormatId() {
        return 85;
    }

    public SQLVarchar() {
    }

    public SQLVarchar(String string2) {
        super(string2);
    }

    public SQLVarchar(Clob clob) {
        super(clob);
    }

    public SQLVarchar(char[] cArray) {
        super(cArray);
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.normalize(dataTypeDescriptor, dataValueDescriptor.getString());
    }

    protected void normalize(DataTypeDescriptor dataTypeDescriptor, String string2) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        int n2 = string2.length();
        if (n2 > n) {
            this.hasNonBlankChars(string2, n, n2);
            string2 = string2.substring(0, n);
        }
        this.setValue(string2);
    }

    public int typePrecedence() {
        return 10;
    }

    protected final int growBy() {
        return 4096;
    }
}

