/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DateTimeParser;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.util.StringUtil;

public final class SQLTime
extends DataType
implements DateTimeDataValue {
    private int encodedTime;
    private int encodedTimeFraction;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTime.class);
    private static final char IBM_EUR_SEPARATOR = '.';
    private static final char[] IBM_EUR_SEPARATOR_OR_END = new char[]{'.', '\u0000'};
    static final char JIS_SEPARATOR = ':';
    private static final char[] US_OR_JIS_MINUTE_END = new char[]{':', ' ', '\u0000'};
    private static final char[] ANY_SEPARATOR = new char[]{'.', ':', ' '};
    private static final String[] AM_PM = new String[]{"AM", "PM"};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    public String getString() {
        if (!this.isNull()) {
            return SQLTime.encodedTimeToString(this.encodedTime);
        }
        return null;
    }

    int getEncodedTime() {
        return this.encodedTime;
    }

    public Timestamp getTimestamp(Calendar calendar) {
        if (this.isNull()) {
            return null;
        }
        if (calendar == null) {
            calendar = new GregorianCalendar();
        } else {
            calendar.clear();
            calendar.setTimeInMillis(System.currentTimeMillis());
        }
        SQLTime.setTimeInCalendar(calendar, this.encodedTime);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public Object getObject() {
        return this.getTime(null);
    }

    public int getLength() {
        return 8;
    }

    public String getTypeName() {
        return "TIME";
    }

    public int getTypeFormatId() {
        return 299;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.encodedTime);
        objectOutput.writeInt(this.encodedTimeFraction);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.encodedTime = objectInput.readInt();
        this.encodedTimeFraction = objectInput.readInt();
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.encodedTime = arrayInputStream.readInt();
        this.encodedTimeFraction = arrayInputStream.readInt();
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLTime(this.encodedTime, this.encodedTimeFraction);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLTime();
    }

    public void restoreToNull() {
        this.encodedTime = -1;
        this.encodedTimeFraction = 0;
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException, StandardException {
        this.restoreToNull();
        this.encodedTime = this.computeEncodedTime(resultSet.getTime(n));
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        int n = 0;
        n = dataValueDescriptor instanceof SQLTime ? ((SQLTime)dataValueDescriptor).encodedTime : this.computeEncodedTime(dataValueDescriptor.getTime(null));
        int n2 = this.encodedTime < n ? -1 : (this.encodedTime > n ? 1 : 0);
        return n2;
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public SQLTime() {
        this.encodedTime = -1;
    }

    public SQLTime(Time time) throws StandardException {
        this.parseTime(time);
    }

    private void parseTime(java.util.Date date) throws StandardException {
        this.encodedTime = this.computeEncodedTime(date);
    }

    private SQLTime(int n, int n2) {
        this.encodedTime = n;
        this.encodedTimeFraction = n2;
    }

    public SQLTime(String string2, boolean bl, LocaleFinder localeFinder) throws StandardException {
        this.parseTime(string2, bl, localeFinder, null);
    }

    public SQLTime(String string2, boolean bl, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        this.parseTime(string2, bl, localeFinder, calendar);
    }

    private void parseTime(String string2, boolean bl, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        boolean bl2 = true;
        DateTimeParser dateTimeParser = new DateTimeParser(string2);
        StandardException standardException = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        try {
            if (dateTimeParser.nextSeparator() == '-') {
                this.encodedTime = SQLTimestamp.parseDateOrTimestamp(dateTimeParser, true)[1];
                return;
            }
            n = dateTimeParser.parseInt(2, true, ANY_SEPARATOR, false);
            block3 : switch (dateTimeParser.getCurrentSeparator()) {
                case '.': {
                    if (bl) {
                        bl2 = false;
                        break;
                    }
                    n2 = dateTimeParser.parseInt(2, false, IBM_EUR_SEPARATOR_OR_END, false);
                    if (dateTimeParser.getCurrentSeparator() == '.') {
                        n3 = dateTimeParser.parseInt(2, false, END_OF_STRING, false);
                    }
                    break;
                }
                case ':': {
                    n2 = dateTimeParser.parseInt(2, false, US_OR_JIS_MINUTE_END, false);
                    switch (dateTimeParser.getCurrentSeparator()) {
                        case ' ': {
                            if (bl) {
                                bl2 = false;
                                break block3;
                            }
                            n4 = dateTimeParser.parseChoice(AM_PM);
                            dateTimeParser.checkEnd();
                            break block3;
                        }
                        case ':': {
                            n3 = dateTimeParser.parseInt(2, false, END_OF_STRING, false);
                        }
                    }
                    break;
                }
                case ' ': {
                    if (bl) {
                        bl2 = false;
                        break;
                    }
                    n4 = dateTimeParser.parseChoice(AM_PM);
                    break;
                }
                default: {
                    bl2 = false;
                    break;
                }
            }
        }
        catch (StandardException standardException2) {
            bl2 = false;
            standardException = standardException2;
        }
        if (bl2) {
            if (n4 == 0) {
                if (n == 12) {
                    n = n2 == 0 && n3 == 0 ? 24 : 0;
                } else if (n > 12) {
                    throw StandardException.newException("22007.S.180");
                }
            } else if (n4 == 1) {
                if (n < 12) {
                    n += 12;
                } else if (n > 12) {
                    throw StandardException.newException("22007.S.180");
                }
            }
            dateTimeParser.checkEnd();
            this.encodedTime = SQLTime.computeEncodedTime(n, n2, n3);
        } else {
            string2 = StringUtil.trimTrailing(string2);
            DateFormat dateFormat = null;
            dateFormat = localeFinder == null ? DateFormat.getTimeInstance() : (calendar == null ? localeFinder.getTimeFormat() : (DateFormat)localeFinder.getTimeFormat().clone());
            if (calendar != null) {
                dateFormat.setCalendar(calendar);
            }
            try {
                this.encodedTime = SQLTime.computeEncodedTime(dateFormat.parse(string2), calendar);
            }
            catch (ParseException parseException) {
                try {
                    this.encodedTime = SQLTimestamp.parseLocalTimestamp(string2, localeFinder, calendar)[1];
                }
                catch (ParseException parseException2) {
                    if (standardException != null) {
                        throw standardException;
                    }
                    throw StandardException.newException("22007.S.181");
                }
            }
        }
    }

    void setObject(Object object) throws StandardException {
        this.setValue((Time)object);
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLTime) {
            this.restoreToNull();
            SQLTime sQLTime = (SQLTime)dataValueDescriptor;
            this.encodedTime = sQLTime.encodedTime;
            this.encodedTimeFraction = sQLTime.encodedTimeFraction;
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            this.setValue(dataValueDescriptor.getTime(gregorianCalendar), (Calendar)gregorianCalendar);
        }
    }

    public void setValue(Time time, Calendar calendar) throws StandardException {
        this.restoreToNull();
        this.encodedTime = SQLTime.computeEncodedTime(time, calendar);
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.restoreToNull();
        this.encodedTime = SQLTime.computeEncodedTime(timestamp, calendar);
    }

    public void setValue(String string2) throws StandardException {
        this.restoreToNull();
        if (string2 != null) {
            DatabaseContext databaseContext = (DatabaseContext)ContextService.getContext("Database");
            this.parseTime(string2, false, databaseContext == null ? null : databaseContext.getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    public NumberDataValue getYear(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getYear", (Object)"Time");
    }

    public NumberDataValue getMonth(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getMonth", (Object)"Time");
    }

    public NumberDataValue getDate(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getDate", (Object)"Time");
    }

    public NumberDataValue getHours(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getHour(this.encodedTime), numberDataValue);
    }

    public NumberDataValue getMinutes(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getMinute(this.encodedTime), numberDataValue);
    }

    public NumberDataValue getSeconds(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getSecond(this.encodedTime), numberDataValue);
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getTime(null).toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.encodedTime + this.encodedTimeFraction + 1;
    }

    public int typePrecedence() {
        return 120;
    }

    public final boolean isNull() {
        return this.encodedTime == -1;
    }

    public Time getTime(Calendar calendar) {
        if (this.isNull()) {
            return null;
        }
        return SQLTime.getTime(calendar, this.encodedTime, 0);
    }

    static void setTimeInCalendar(Calendar calendar, int n) {
        calendar.set(11, SQLTime.getHour(n));
        calendar.set(12, SQLTime.getMinute(n));
        calendar.set(13, SQLTime.getSecond(n));
    }

    static Time getTime(Calendar calendar, int n, int n2) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.clear();
        calendar.set(1970, 0, 1);
        SQLTime.setTimeInCalendar(calendar, n);
        calendar.set(14, n2 / 1000000);
        return new Time(calendar.getTimeInMillis());
    }

    protected static int getHour(int n) {
        return n >>> 16 & 0xFF;
    }

    protected static int getMinute(int n) {
        return n >>> 8 & 0xFF;
    }

    protected static int getSecond(int n) {
        return n & 0xFF;
    }

    static int computeEncodedTime(Calendar calendar) throws StandardException {
        return SQLTime.computeEncodedTime(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    static int computeEncodedTime(int n, int n2, int n3) throws StandardException {
        if (n == 24 ? n2 != 0 || n3 != 0 : n < 0 || n > 23 || n2 < 0 || n2 > 59 || n3 < 0 || n3 > 59) {
            throw StandardException.newException("22007.S.180");
        }
        return (n << 16) + (n2 << 8) + n3;
    }

    static void timeToString(int n, int n2, int n3, StringBuffer stringBuffer) {
        String string2 = Integer.toString(n);
        String string3 = Integer.toString(n2);
        String string4 = Integer.toString(n3);
        if (string2.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string2);
        stringBuffer.append(':');
        if (string3.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string3);
        stringBuffer.append(':');
        if (string4.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string4);
    }

    protected static String encodedTimeToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        SQLTime.timeToString(SQLTime.getHour(n), SQLTime.getMinute(n), SQLTime.getSecond(n), stringBuffer);
        return stringBuffer.toString();
    }

    private int computeEncodedTime(java.util.Date date) throws StandardException {
        return SQLTime.computeEncodedTime(date, null);
    }

    static int computeEncodedTime(java.util.Date date, Calendar calendar) throws StandardException {
        if (date == null) {
            return -1;
        }
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.setTime(date);
        return SQLTime.computeEncodedTime(calendar);
    }

    public void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setTime(n, this.getTime(null));
    }

    public DateTimeDataValue timestampAdd(int n, NumberDataValue numberDataValue, Date date, DateTimeDataValue dateTimeDataValue) throws StandardException {
        return this.toTimestamp(date).timestampAdd(n, numberDataValue, date, dateTimeDataValue);
    }

    private SQLTimestamp toTimestamp(Date date) throws StandardException {
        return new SQLTimestamp(SQLDate.computeEncodedDate(date, null), this.getEncodedTime(), 0);
    }

    public NumberDataValue timestampDiff(int n, DateTimeDataValue dateTimeDataValue, Date date, NumberDataValue numberDataValue) throws StandardException {
        return this.toTimestamp(date).timestampDiff(n, dateTimeDataValue, date, numberDataValue);
    }
}

