/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLInteger
extends NumberDataType {
    static final int INTEGER_LENGTH = 4;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLInteger.class);
    private int value;
    private boolean isnull;

    public int getInt() {
        return this.value;
    }

    public byte getByte() throws StandardException {
        if (this.value > 127 || this.value < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    public short getShort() throws StandardException {
        if (this.value > Short.MAX_VALUE || this.value < Short.MIN_VALUE) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    public long getLong() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public boolean getBoolean() {
        return this.value != 0;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Integer.toString(this.value);
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.value);
    }

    public int getLength() {
        return 4;
    }

    public String getTypeName() {
        return "INTEGER";
    }

    public int getTypeFormatId() {
        return 80;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.value);
    }

    public final void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readInt();
        this.isnull = false;
    }

    public final void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.value = arrayInputStream.readInt();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n;
        int n2 = this.getInt();
        if (n2 == (n = dataValueDescriptor.getInt())) {
            return 0;
        }
        if (n2 > n) {
            return 1;
        }
        return -1;
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        SQLInteger sQLInteger = new SQLInteger(this.value);
        sQLInteger.isnull = this.isnull;
        return sQLInteger;
    }

    public DataValueDescriptor getNewNull() {
        return new SQLInteger();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getInt(n);
        this.isnull = this.value == 0 ? bl && resultSet.wasNull() : false;
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, 4);
            return;
        }
        preparedStatement.setInt(n, this.value);
    }

    public final void setInto(ResultSet resultSet, int n) throws SQLException {
        resultSet.updateInt(n, this.value);
    }

    public SQLInteger() {
        this.isnull = true;
    }

    public SQLInteger(int n) {
        this.value = n;
    }

    public SQLInteger(char c) {
        this.value = c;
    }

    public SQLInteger(Integer n) {
        this.isnull = n == null;
        if (!this.isnull) {
            this.value = n;
        }
    }

    public void setValue(String string2) throws StandardException {
        if (string2 == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Integer.parseInt(string2.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    public void setValue(int n) {
        this.value = n;
        this.isnull = false;
    }

    public void setValue(long l) throws StandardException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw this.outOfRange();
        }
        this.value = (int)l;
        this.isnull = false;
    }

    public void setValue(float f2) throws StandardException {
        if ((f2 = NumberDataType.normalizeREAL(f2)) > 2.1474836E9f || f2 < -2.1474836E9f) {
            throw this.outOfRange();
        }
        float f3 = (float)Math.floor(f2);
        this.value = (int)f3;
        this.isnull = false;
    }

    public void setValue(double d) throws StandardException {
        if ((d = NumberDataType.normalizeDOUBLE(d)) > 2.147483647E9 || d < -2.147483648E9) {
            throw this.outOfRange();
        }
        double d2 = Math.floor(d);
        this.value = (int)d2;
        this.isnull = false;
    }

    public void setValue(boolean bl) {
        this.value = bl ? 1 : 0;
        this.isnull = false;
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getInt());
    }

    public int typePrecedence() {
        return 50;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getInt() == dataValueDescriptor2.getInt());
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getInt() != dataValueDescriptor2.getInt());
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getInt() < dataValueDescriptor2.getInt());
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getInt() > dataValueDescriptor2.getInt());
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getInt() <= dataValueDescriptor2.getInt());
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getInt() >= dataValueDescriptor2.getInt());
    }

    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLInteger();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue.getLong() * numberDataValue2.getLong();
        numberDataValue3.setValue(l);
        return numberDataValue3;
    }

    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLInteger();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue2.getInt();
        if (n == 0) {
            throw StandardException.newException("22012");
        }
        numberDataValue3.setValue(numberDataValue.getInt() % n);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLInteger();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        int n = this.getInt();
        if (n == Integer.MIN_VALUE) {
            throw this.outOfRange();
        }
        numberDataValue.setValue(-n);
        return numberDataValue;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

