/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PushbackInputStream;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.RuleBasedCollator;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CloneableStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.ClobStreamHeaderGenerator;
import org.apache.derby.iapi.types.CollatorSQLClob;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.UTF8Util;

public class SQLClob
extends SQLVarchar {
    private static final StreamHeaderGenerator TEN_FOUR_CLOB_HEADER_GENERATOR = new ClobStreamHeaderGenerator(true);
    private static final StreamHeaderGenerator TEN_FIVE_CLOB_HEADER_GENERATOR = new ClobStreamHeaderGenerator(false);
    private static final int MAX_STREAM_HEADER_LENGTH = TEN_FIVE_CLOB_HEADER_GENERATOR.getMaxHeaderLength();
    private CharacterStreamDescriptor csd;
    private Boolean inSoftUpgradeMode = null;

    public String getTypeName() {
        return "CLOB";
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        SQLClob sQLClob = new SQLClob();
        sQLClob.inSoftUpgradeMode = this.inSoftUpgradeMode;
        if (this.isNull()) {
            return sQLClob;
        }
        if (!bl) {
            if (this.stream != null && this.stream instanceof CloneableStream) {
                int n = -1;
                if (this.csd != null && this.csd.getCharLength() > 0L) {
                    n = (int)this.csd.getCharLength();
                }
                sQLClob.setValue(((CloneableStream)((Object)this.stream)).cloneStream(), n);
            } else if (this._clobValue != null) {
                sQLClob.setValue(this._clobValue);
            }
        }
        if (sQLClob.isNull() || bl) {
            try {
                sQLClob.setValue(this.getString());
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        return sQLClob;
    }

    public DataValueDescriptor getNewNull() {
        SQLClob sQLClob = new SQLClob();
        sQLClob.inSoftUpgradeMode = this.inSoftUpgradeMode;
        return sQLClob;
    }

    public StringDataValue getValue(RuleBasedCollator ruleBasedCollator) {
        if (ruleBasedCollator == null) {
            return this;
        }
        CollatorSQLClob collatorSQLClob = new CollatorSQLClob(ruleBasedCollator);
        collatorSQLClob.copyState(this);
        return collatorSQLClob;
    }

    public int getTypeFormatId() {
        return 447;
    }

    public SQLClob() {
    }

    public SQLClob(String string2) {
        super(string2);
    }

    public SQLClob(Clob clob) {
        super(clob);
    }

    public int typePrecedence() {
        return 14;
    }

    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    public int getLength() throws StandardException {
        boolean bl;
        if (this.stream == null) {
            return super.getLength();
        }
        if (!(this.stream instanceof Resetable)) {
            return super.getLength();
        }
        boolean bl2 = bl = this.csd != null;
        if (this.csd == null) {
            this.getStreamWithDescriptor();
        }
        if (this.csd.getCharLength() != 0L) {
            return (int)this.csd.getCharLength();
        }
        long l = 0L;
        try {
            if (bl) {
                this.rewindStream(this.stream, this.csd.getDataOffset());
            }
            l = UTF8Util.skipUntilEOF(this.stream);
            this.rewindStream(this.stream, 0L);
        }
        catch (IOException iOException) {
            this.throwStreamingIOException(iOException);
        }
        this.csd = new CharacterStreamDescriptor.Builder().copyState(this.csd).charLength(l).curBytePos(0L).curCharPos(0L).build();
        return (int)l;
    }

    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    public Date getDate(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    public Object getObject() throws StandardException {
        if (this._clobValue != null) {
            return this._clobValue;
        }
        String string2 = this.getString();
        if (string2 == null) {
            return null;
        }
        return new HarmonySerialClob(string2.toCharArray());
    }

    public CharacterStreamDescriptor getStreamWithDescriptor() throws StandardException {
        if (this.stream == null) {
            this.csd = null;
            throw StandardException.newException("42Z12.U", this.getTypeName());
        }
        if (this.csd != null && this.stream instanceof Resetable) {
            try {
                ((Resetable)((Object)this.stream)).resetStream();
                InputStreamUtil.skipFully(this.stream, this.csd.getCurBytePos());
            }
            catch (IOException iOException) {
                this.throwStreamingIOException(iOException);
            }
        }
        if (this.csd == null) {
            try {
                byte[] byArray = new byte[MAX_STREAM_HEADER_LENGTH];
                int n = this.stream.read(byArray);
                HeaderInfo headerInfo = this.investigateHeader(byArray, n);
                if (n > headerInfo.headerLength()) {
                    n = headerInfo.headerLength();
                    this.rewindStream(this.stream, n);
                }
                this.csd = new CharacterStreamDescriptor.Builder().stream(this.stream).bufferable(false).positionAware(false).curCharPos(n == 0 ? 0L : 1L).curBytePos(n).dataOffset(headerInfo.headerLength()).byteLength(headerInfo.byteLength()).charLength(headerInfo.charLength()).build();
            }
            catch (IOException iOException) {
                StandardException standardException;
                Throwable throwable = iOException;
                while (throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof StandardException && (standardException = (StandardException)throwable).getMessageId().equals("40XD0")) {
                    throw StandardException.newException("XJ073.S", iOException);
                }
                this.throwStreamingIOException(iOException);
            }
        }
        return this.csd;
    }

    public boolean hasStream() {
        return this.stream != null;
    }

    public Time getTime(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.hasStream()) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + "(" + this.getLength() + ")";
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLClob) {
            SQLClob sQLClob = (SQLClob)dataValueDescriptor;
            if (sQLClob.stream != null) {
                this.copyState(sQLClob);
                return;
            }
        }
        super.normalize(dataTypeDescriptor, dataValueDescriptor);
    }

    public void setValue(Time time, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    public void setBigDecimal(Number number2) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    public final void setStream(InputStream inputStream) {
        super.setStream(inputStream);
        this.csd = null;
    }

    public final void restoreToNull() {
        this.csd = null;
        super.restoreToNull();
    }

    public void setValue(int n) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    public void setValue(double d) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    public void setValue(float f2) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    public void setValue(short s) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    public void setValue(long l) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    public void setValue(byte by2) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    public void setValue(boolean bl) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    public void setValue(byte[] byArray) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    final void setObject(Object object) throws StandardException {
        Clob clob = (Clob)object;
        try {
            long l = clob.length();
            if (l < 0L || l > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            if (l < 32768L) {
                this.setValue(clob.getSubString(1L, (int)l));
            } else {
                ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream(clob.getCharacterStream(), (int)l, 0, "CLOB", this.getStreamHeaderGenerator());
                this.setValue(readerToUTF8Stream, (int)l);
            }
        }
        catch (SQLException sQLException) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeClobUTF(objectOutput);
    }

    public StreamHeaderGenerator getStreamHeaderGenerator() {
        if (this.inSoftUpgradeMode == null) {
            return new ClobStreamHeaderGenerator(this);
        }
        if (this.inSoftUpgradeMode == Boolean.TRUE) {
            return TEN_FOUR_CLOB_HEADER_GENERATOR;
        }
        return TEN_FIVE_CLOB_HEADER_GENERATOR;
    }

    public void setStreamHeaderFormat(Boolean bl) {
        this.inSoftUpgradeMode = bl;
    }

    private HeaderInfo investigateHeader(byte[] byArray, int n) throws IOException {
        int n2 = MAX_STREAM_HEADER_LENGTH;
        int n3 = -1;
        int n4 = -1;
        if (n < n2 || (byArray[2] & 0xF0) != 240) {
            n2 = 2;
        }
        if (n2 == 2) {
            n3 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            if (n < MAX_STREAM_HEADER_LENGTH && n2 + n3 != n) {
                throw new IOException("Corrupted stream; headerLength=" + n2 + ", utfLen=" + n3 + ", bytesRead=" + n);
            }
            if (n3 > 0) {
                n3 += n2;
            }
        } else if (n2 == 5) {
            int n5 = byArray[2] & 0xF;
            switch (n5) {
                case 0: {
                    n4 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | (byArray[4] & 0xFF) << 0;
                    break;
                }
                default: {
                    throw new IOException("Invalid header format identifier: " + n5 + "(magic byte is 0x" + Integer.toHexString(byArray[2] & 0xFF) + ")");
                }
            }
        }
        return new HeaderInfo(n2, n2 == 5 ? n4 : n3);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        HeaderInfo headerInfo;
        int n;
        if (this.csd != null) {
            n = (int)this.csd.getDataOffset();
            int n2 = n == 5 ? (int)this.csd.getCharLength() : (int)this.csd.getByteLength();
            headerInfo = new HeaderInfo(n, n2);
            this.rewindStream((InputStream)((Object)objectInput), n);
        } else {
            byte[] byArray;
            int n3;
            InputStream inputStream = (InputStream)((Object)objectInput);
            boolean bl = inputStream.markSupported();
            if (bl) {
                inputStream.mark(MAX_STREAM_HEADER_LENGTH);
            }
            if ((n3 = objectInput.read(byArray = new byte[MAX_STREAM_HEADER_LENGTH])) > (headerInfo = this.investigateHeader(byArray, n3)).headerLength()) {
                if (bl) {
                    inputStream.reset();
                    InputStreamUtil.skipFully(inputStream, headerInfo.headerLength());
                } else if (objectInput instanceof FormatIdInputStream) {
                    int n4 = n3 - headerInfo.headerLength();
                    FormatIdInputStream formatIdInputStream = (FormatIdInputStream)objectInput;
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(formatIdInputStream.getInputStream(), n4);
                    pushbackInputStream.unread(byArray, headerInfo.headerLength(), n4);
                    formatIdInputStream.setInput(pushbackInputStream);
                } else {
                    this.rewindStream(inputStream, headerInfo.headerLength());
                }
            }
        }
        n = 0;
        if (headerInfo.byteLength() != 0) {
            n = headerInfo.byteLength() - headerInfo.headerLength();
        }
        super.readExternal(objectInput, n, headerInfo.charLength());
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        HeaderInfo headerInfo;
        int n = arrayInputStream.getPosition();
        byte[] byArray = new byte[MAX_STREAM_HEADER_LENGTH];
        int n2 = arrayInputStream.read(byArray);
        if (n2 > (headerInfo = this.investigateHeader(byArray, n2)).headerLength()) {
            arrayInputStream.setPosition(n);
            super.readExternalFromArray(arrayInputStream);
        } else {
            super.readExternalClobFromArray(arrayInputStream, headerInfo.charLength());
        }
    }

    private void rewindStream(InputStream inputStream, long l) throws IOException {
        try {
            ((Resetable)((Object)inputStream)).resetStream();
            InputStreamUtil.skipFully(inputStream, l);
        }
        catch (StandardException standardException) {
            IOException iOException = new IOException(standardException.getMessage());
            iOException.initCause(standardException);
            throw iOException;
        }
    }

    private static class HeaderInfo {
        private final int valueLength;
        private final int headerLength;

        HeaderInfo(int n, int n2) {
            this.headerLength = n;
            this.valueLength = n2;
        }

        int headerLength() {
            return this.headerLength;
        }

        int charLength() {
            return this.isCharLength() ? this.valueLength : 0;
        }

        int byteLength() {
            return this.isCharLength() ? 0 : this.valueLength;
        }

        boolean isCharLength() {
            return this.headerLength == 5;
        }

        public String toString() {
            return "headerLength=" + this.headerLength + ", valueLength= " + this.valueLength + ", isCharLength=" + this.isCharLength();
        }
    }
}

