/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.text.RuleBasedCollator;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RowMultiSetImpl;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;

public final class DataTypeDescriptor
implements Formatable {
    public static final DataTypeDescriptor INTEGER = new DataTypeDescriptor(TypeId.INTEGER_ID, true);
    public static final DataTypeDescriptor INTEGER_NOT_NULL = INTEGER.getNullabilityType(false);
    public static final DataTypeDescriptor SMALLINT = new DataTypeDescriptor(TypeId.SMALLINT_ID, true);
    public static final DataTypeDescriptor SMALLINT_NOT_NULL = SMALLINT.getNullabilityType(false);
    private TypeDescriptorImpl typeDescriptor;
    private TypeId typeId;
    private int collationDerivation = 1;

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int n) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, true);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int n, int n2) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, true, n2);
    }

    public static DataTypeDescriptor getType(TypeDescriptor typeDescriptor) {
        TypeDescriptorImpl typeDescriptorImpl = (TypeDescriptorImpl)typeDescriptor;
        TypeId typeId = TypeId.getTypeId(typeDescriptor);
        DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeDescriptorImpl, typeId);
        dataTypeDescriptor.collationDerivation = 1;
        return dataTypeDescriptor;
    }

    public static TypeDescriptor getCatalogType(int n, int n2) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n, n2).getCatalogType();
    }

    public static TypeDescriptor getCatalogType(int n) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(n).getCatalogType();
    }

    public static TypeDescriptor getCatalogType(TypeDescriptor typeDescriptor, int n) {
        if (typeDescriptor.isRowMultiSet()) {
            return DataTypeDescriptor.getRowMultiSetCollation(typeDescriptor, n);
        }
        if (typeDescriptor.getCollationType() == n) {
            return typeDescriptor;
        }
        return DataTypeDescriptor.getType(typeDescriptor).getCollatedType(n, 1).getCatalogType();
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int n, boolean bl) {
        switch (n) {
            case 4: {
                return bl ? INTEGER : INTEGER_NOT_NULL;
            }
            case 5: {
                return bl ? SMALLINT : SMALLINT_NOT_NULL;
            }
        }
        TypeId typeId = TypeId.getBuiltInTypeId(n);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, bl);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int n, boolean bl, int n2) {
        TypeId typeId = TypeId.getBuiltInTypeId(n);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, bl, n2);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(String string2) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(string2), true);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(String string2, int n) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(string2), true, n);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String string2) throws StandardException {
        return DataTypeDescriptor.getSQLDataTypeDescriptor(string2, true);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String string2, boolean bl) throws StandardException {
        TypeId typeId = TypeId.getSQLTypeForJavaType(string2);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, bl);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String string2, int n, int n2, boolean bl, int n3) throws StandardException {
        TypeId typeId = TypeId.getSQLTypeForJavaType(string2);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, n, n2, bl, n3);
    }

    public static TypeDescriptor getRowMultiSet(String[] stringArray, TypeDescriptor[] typeDescriptorArray) {
        RowMultiSetImpl rowMultiSetImpl = new RowMultiSetImpl(stringArray, typeDescriptorArray);
        return new TypeDescriptorImpl(rowMultiSetImpl, true, -1);
    }

    public DataTypeDescriptor() {
    }

    public DataTypeDescriptor(TypeId typeId, int n, int n2, boolean bl, int n3) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), n, n2, bl, n3);
    }

    public DataTypeDescriptor(TypeId typeId, int n, int n2, boolean bl, int n3, int n4, int n5) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), n, n2, bl, n3, n4);
        this.collationDerivation = n5;
    }

    public DataTypeDescriptor(TypeId typeId, boolean bl, int n) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), bl, n);
    }

    public DataTypeDescriptor(TypeId typeId, boolean bl) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), typeId.getMaximumPrecision(), typeId.getMaximumScale(), bl, typeId.getMaximumMaximumWidth());
    }

    private DataTypeDescriptor(DataTypeDescriptor dataTypeDescriptor, boolean bl) {
        this.typeId = dataTypeDescriptor.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(dataTypeDescriptor.typeDescriptor, dataTypeDescriptor.getPrecision(), dataTypeDescriptor.getScale(), bl, dataTypeDescriptor.getMaximumWidth(), dataTypeDescriptor.getCollationType());
        this.collationDerivation = dataTypeDescriptor.getCollationDerivation();
    }

    private DataTypeDescriptor(DataTypeDescriptor dataTypeDescriptor, int n, int n2) {
        this.typeId = dataTypeDescriptor.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(dataTypeDescriptor.typeDescriptor, dataTypeDescriptor.getPrecision(), dataTypeDescriptor.getScale(), dataTypeDescriptor.isNullable(), dataTypeDescriptor.getMaximumWidth(), n);
        this.collationDerivation = n2;
    }

    public DataTypeDescriptor(DataTypeDescriptor dataTypeDescriptor, int n, int n2, boolean bl, int n3) {
        this.typeId = dataTypeDescriptor.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(dataTypeDescriptor.typeDescriptor, n, n2, bl, n3, dataTypeDescriptor.getCollationType());
        this.collationDerivation = dataTypeDescriptor.getCollationDerivation();
    }

    public DataTypeDescriptor(DataTypeDescriptor dataTypeDescriptor, boolean bl, int n) {
        this.typeId = dataTypeDescriptor.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(dataTypeDescriptor.typeDescriptor, dataTypeDescriptor.getPrecision(), dataTypeDescriptor.getScale(), bl, n, dataTypeDescriptor.getCollationType());
        this.collationDerivation = dataTypeDescriptor.getCollationDerivation();
    }

    private DataTypeDescriptor(TypeDescriptorImpl typeDescriptorImpl, TypeId typeId) {
        this.typeDescriptor = typeDescriptorImpl;
        this.typeId = typeId;
    }

    public DataValueDescriptor normalize(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        if (dataValueDescriptor.isNull()) {
            if (!this.isNullable()) {
                throw StandardException.newException("23502", "");
            }
            dataValueDescriptor2.setToNull();
        } else {
            int n = this.getJDBCTypeId();
            dataValueDescriptor2.normalize(this, dataValueDescriptor);
            if ((n == -1 || n == -4) && dataValueDescriptor.getClass() == dataValueDescriptor2.getClass()) {
                return dataValueDescriptor;
            }
        }
        return dataValueDescriptor2;
    }

    public DataTypeDescriptor getDominantType(DataTypeDescriptor dataTypeDescriptor, ClassFactory classFactory) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor2;
        int n;
        DataTypeDescriptor dataTypeDescriptor3 = null;
        int n2 = this.getPrecision();
        int n3 = this.getScale();
        TypeId typeId = this.getTypeId();
        TypeId typeId2 = dataTypeDescriptor.getTypeId();
        boolean bl = this.isNullable() || dataTypeDescriptor.isNullable();
        int n4 = n = this.getMaximumWidth() > dataTypeDescriptor.getMaximumWidth() ? this.getMaximumWidth() : dataTypeDescriptor.getMaximumWidth();
        if (!typeId.userType() && !typeId2.userType()) {
            TypeId typeId3;
            TypeId typeId4;
            if (typeId.typePrecedence() > typeId2.typePrecedence()) {
                dataTypeDescriptor2 = this;
                dataTypeDescriptor3 = dataTypeDescriptor;
                typeId4 = typeId;
                typeId3 = typeId2;
            } else {
                dataTypeDescriptor2 = dataTypeDescriptor;
                dataTypeDescriptor3 = this;
                typeId4 = typeId2;
                typeId3 = typeId;
            }
            if (typeId4.isRealTypeId() && !typeId3.isRealTypeId() && typeId3.isNumericTypeId()) {
                dataTypeDescriptor2 = DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
                typeId4 = TypeId.getBuiltInTypeId(8);
            }
            if (typeId4.isDecimalTypeId() && !typeId3.isStringTypeId()) {
                n2 = typeId4.getPrecision(this, dataTypeDescriptor);
                if (n2 > 31) {
                    n2 = 31;
                }
                n = (n3 = typeId4.getScale(this, dataTypeDescriptor)) > 0 ? n2 + 3 : n2 + 1;
            } else if (typeId.typePrecedence() != typeId2.typePrecedence()) {
                int n5;
                int n6;
                n2 = dataTypeDescriptor2.getPrecision();
                n3 = dataTypeDescriptor2.getScale();
                if (typeId3.isStringTypeId() && typeId4.isBitTypeId() && !typeId4.isLongConcatableTypeId()) {
                    if (typeId3.isLongConcatableTypeId()) {
                        n = n > 0x7FFFFFF ? Integer.MAX_VALUE : (n *= 16);
                    } else {
                        n6 = dataTypeDescriptor3.getMaximumWidth();
                        n5 = n6 > 0x7FFFFFF ? Integer.MAX_VALUE : 16 * n6;
                        int n7 = n = n >= n5 ? n : n5;
                    }
                }
                if (typeId3.isStringTypeId() && !typeId3.isLongConcatableTypeId() && typeId4.isDecimalTypeId()) {
                    n5 = dataTypeDescriptor3.getMaximumWidth();
                    n6 = n5 > 0x3FFFFFFE ? 0x7FFFFFFC : n5 * 2;
                    if (n2 < n6) {
                        n2 = n6;
                    }
                    if (n3 < n5) {
                        n3 = n5;
                    }
                    n = n2 + 3;
                }
            }
        } else {
            ClassInspector classInspector = classFactory.getClassInspector();
            TypeId typeId5 = typeId;
            TypeId typeId6 = typeId2;
            dataTypeDescriptor2 = classInspector.assignableTo(typeId5.getCorrespondingJavaTypeName(), typeId6.getCorrespondingJavaTypeName()) ? dataTypeDescriptor : this;
            n2 = dataTypeDescriptor2.getPrecision();
            n3 = dataTypeDescriptor2.getScale();
        }
        dataTypeDescriptor2 = new DataTypeDescriptor(dataTypeDescriptor2, n2, n3, bl, n);
        if (dataTypeDescriptor2.getTypeId().isStringTypeId()) {
            dataTypeDescriptor2 = this.getCollationDerivation() != dataTypeDescriptor.getCollationDerivation() ? (this.getCollationDerivation() == 0 ? dataTypeDescriptor2.getCollatedType(dataTypeDescriptor.getCollationType(), dataTypeDescriptor.getCollationDerivation()) : (dataTypeDescriptor.getCollationDerivation() == 0 ? dataTypeDescriptor2.getCollatedType(this.getCollationType(), this.getCollationDerivation()) : dataTypeDescriptor2.getCollatedType(0, 0))) : (this.getCollationType() != dataTypeDescriptor.getCollationType() ? dataTypeDescriptor2.getCollatedType(0, 0) : dataTypeDescriptor2.getCollatedType(this.getCollationType(), this.getCollationDerivation()));
        }
        return dataTypeDescriptor2;
    }

    public boolean isExactTypeAndLengthMatch(DataTypeDescriptor dataTypeDescriptor) {
        TypeId typeId;
        if (this.getMaximumWidth() != dataTypeDescriptor.getMaximumWidth()) {
            return false;
        }
        if (this.getScale() != dataTypeDescriptor.getScale()) {
            return false;
        }
        if (this.getPrecision() != dataTypeDescriptor.getPrecision()) {
            return false;
        }
        TypeId typeId2 = this.getTypeId();
        return typeId2.equals(typeId = dataTypeDescriptor.getTypeId());
    }

    public int getMaximumWidth() {
        return this.typeDescriptor.getMaximumWidth();
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    public DataValueDescriptor getNull() throws StandardException {
        DataValueDescriptor dataValueDescriptor = this.typeId.getNull();
        if (this.typeDescriptor.getCollationType() == 0) {
            return dataValueDescriptor;
        }
        if (dataValueDescriptor instanceof StringDataValue) {
            try {
                RuleBasedCollator ruleBasedCollator = ConnectionUtil.getCurrentLCC().getDataValueFactory().getCharacterCollator(this.typeDescriptor.getCollationType());
                return ((StringDataValue)dataValueDescriptor).getValue(ruleBasedCollator);
            }
            catch (SQLException sQLException) {
                throw StandardException.plainWrapException(sQLException);
            }
        }
        return dataValueDescriptor;
    }

    public String getTypeName() {
        return this.typeDescriptor.getTypeName();
    }

    public int getJDBCTypeId() {
        return this.typeDescriptor.getJDBCTypeId();
    }

    public int getPrecision() {
        return this.typeDescriptor.getPrecision();
    }

    public int getScale() {
        return this.typeDescriptor.getScale();
    }

    public int getCollationType() {
        return this.typeDescriptor.getCollationType();
    }

    public static int getCollationType(String string2) {
        if (string2.equalsIgnoreCase("UCS_BASIC")) {
            return 0;
        }
        if (string2.equalsIgnoreCase("TERRITORY_BASED")) {
            return 1;
        }
        if (string2.equalsIgnoreCase("TERRITORY_BASED:PRIMARY")) {
            return 2;
        }
        if (string2.equalsIgnoreCase("TERRITORY_BASED:SECONDARY")) {
            return 3;
        }
        if (string2.equalsIgnoreCase("TERRITORY_BASED:TERTIARY")) {
            return 4;
        }
        if (string2.equalsIgnoreCase("TERRITORY_BASED:IDENTICAL")) {
            return 5;
        }
        return -1;
    }

    public String getCollationName() {
        if (this.getCollationDerivation() == 0) {
            return "NONE";
        }
        return DataTypeDescriptor.getCollationName(this.getCollationType());
    }

    public static String getCollationName(int n) {
        switch (n) {
            case 1: {
                return "TERRITORY_BASED";
            }
            case 2: {
                return "TERRITORY_BASED:PRIMARY";
            }
            case 3: {
                return "TERRITORY_BASED:SECONDARY";
            }
            case 4: {
                return "TERRITORY_BASED:TERTIARY";
            }
            case 5: {
                return "TERRITORY_BASED:IDENTICAL";
            }
        }
        return "UCS_BASIC";
    }

    public int getCollationDerivation() {
        return this.collationDerivation;
    }

    public boolean isNullable() {
        return this.typeDescriptor.isNullable();
    }

    public DataTypeDescriptor getNullabilityType(boolean bl) {
        if (this.isNullable() == bl) {
            return this;
        }
        return new DataTypeDescriptor(this, bl);
    }

    public DataTypeDescriptor getCollatedType(int n, int n2) {
        if (!this.typeDescriptor.isStringType()) {
            return this;
        }
        if (this.getCollationType() == n && this.getCollationDerivation() == n2) {
            return this;
        }
        return new DataTypeDescriptor(this, n, n2);
    }

    private static TypeDescriptor getRowMultiSetCollation(TypeDescriptor typeDescriptor, int n) {
        TypeDescriptor[] typeDescriptorArray = typeDescriptor.getRowTypes();
        TypeDescriptor[] typeDescriptorArray2 = null;
        for (int i = 0; i < typeDescriptorArray.length; ++i) {
            TypeDescriptor typeDescriptor2 = DataTypeDescriptor.getCatalogType(typeDescriptorArray[i], n);
            if (typeDescriptor2 == typeDescriptorArray[i]) continue;
            if (typeDescriptorArray2 == null) {
                typeDescriptorArray2 = new TypeDescriptor[typeDescriptorArray.length];
                System.arraycopy(typeDescriptorArray, 0, typeDescriptorArray2, 0, typeDescriptorArray.length);
            }
            typeDescriptorArray2[i] = typeDescriptor2;
        }
        if (typeDescriptorArray2 == null) {
            return typeDescriptor;
        }
        return DataTypeDescriptor.getRowMultiSet(typeDescriptor.getRowColumnNames(), typeDescriptorArray2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataTypeDescriptor)) {
            return false;
        }
        DataTypeDescriptor dataTypeDescriptor = (DataTypeDescriptor)object;
        return this.typeDescriptor.equals(dataTypeDescriptor.typeDescriptor) && this.collationDerivation == dataTypeDescriptor.collationDerivation;
    }

    public boolean comparable(DataTypeDescriptor dataTypeDescriptor, boolean bl, ClassFactory classFactory) {
        TypeId typeId = dataTypeDescriptor.getTypeId();
        int n = typeId.getJDBCTypeId();
        if (typeId.isLongConcatableTypeId() || this.typeId.isLongConcatableTypeId()) {
            return false;
        }
        if (this.typeId.isRefTypeId() || typeId.isRefTypeId()) {
            return false;
        }
        if (!this.typeId.isUserDefinedTypeId() && typeId.isUserDefinedTypeId()) {
            return dataTypeDescriptor.comparable(this, bl, classFactory);
        }
        if (this.typeId.isNumericTypeId()) {
            return typeId.isNumericTypeId();
        }
        if (this.typeId.isStringTypeId()) {
            if (typeId.isDateTimeTimeStampTypeID() || typeId.isBooleanTypeId()) {
                return true;
            }
            if (typeId.isStringTypeId() && this.typeId.isStringTypeId()) {
                return this.compareCollationInfo(dataTypeDescriptor);
            }
            return false;
        }
        if (this.typeId.isBitTypeId()) {
            return typeId.isBitTypeId();
        }
        if (this.typeId.isBooleanTypeId()) {
            return typeId.getSQLTypeName().equals(this.typeId.getSQLTypeName()) || typeId.isStringTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 91) {
            return n == 91 || typeId.isStringTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 92) {
            return n == 92 || typeId.isStringTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 93) {
            return n == 93 || typeId.isStringTypeId();
        }
        if (this.typeId.isUserDefinedTypeId() || this.typeId.getJDBCTypeId() == 1111) {
            return false;
        }
        return false;
    }

    public boolean compareCollationInfo(DataTypeDescriptor dataTypeDescriptor) {
        if (this.getCollationDerivation() == dataTypeDescriptor.getCollationDerivation() && this.getCollationDerivation() == 0) {
            return false;
        }
        return this.getCollationDerivation() == dataTypeDescriptor.getCollationDerivation() && this.getCollationType() == dataTypeDescriptor.getCollationType();
    }

    public String getSQLstring() {
        return this.typeId.toParsableString(this);
    }

    public TypeDescriptor getCatalogType() {
        return this.typeDescriptor;
    }

    public double estimatedMemoryUsage() {
        switch (this.typeId.getTypeFormatId()) {
            case 232: {
                return 10000.0;
            }
            case 27: {
                return (double)this.getMaximumWidth() / 8.0 + 0.5;
            }
            case 4: {
                return 4.0;
            }
            case 5: 
            case 13: {
                return 2.0 * (double)this.getMaximumWidth();
            }
            case 230: {
                return 10000.0;
            }
            case 197: {
                return (double)this.getPrecision() * 0.415 + 1.5;
            }
            case 6: {
                return 8.0;
            }
            case 7: {
                return 4.0;
            }
            case 11: {
                return 8.0;
            }
            case 8: {
                return 4.0;
            }
            case 10: {
                return 2.0;
            }
            case 195: {
                return 1.0;
            }
            case 9: {
                return 12.0;
            }
            case 267: {
                if (this.typeId.userType()) {
                    return 256.0;
                }
            }
            case 35: 
            case 36: 
            case 40: {
                return 12.0;
            }
        }
        return 0.0;
    }

    public static boolean isJDBCTypeEquivalent(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (DataTypeDescriptor.isNumericType(n)) {
            if (DataTypeDescriptor.isNumericType(n2)) {
                return true;
            }
            return DataTypeDescriptor.isCharacterType(n2);
        }
        if (DataTypeDescriptor.isCharacterType(n)) {
            if (DataTypeDescriptor.isCharacterType(n2)) {
                return true;
            }
            if (DataTypeDescriptor.isNumericType(n2)) {
                return true;
            }
            switch (n2) {
                case 91: 
                case 92: 
                case 93: {
                    return true;
                }
            }
            return false;
        }
        if (DataTypeDescriptor.isBinaryType(n)) {
            return DataTypeDescriptor.isBinaryType(n2);
        }
        if (n == 91 || n == 92) {
            if (DataTypeDescriptor.isCharacterType(n2)) {
                return true;
            }
            return n2 == 93;
        }
        if (n == 93) {
            if (DataTypeDescriptor.isCharacterType(n2)) {
                return true;
            }
            return n2 == 91;
        }
        return n == 2005 && DataTypeDescriptor.isCharacterType(n2);
    }

    public static boolean isNumericType(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCharacterType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean isBinaryType(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAsciiStreamAssignable(int n) {
        return n == 2005 || DataTypeDescriptor.isCharacterType(n);
    }

    public static boolean isBinaryStreamAssignable(int n) {
        return n == 2004 || DataTypeDescriptor.isBinaryType(n);
    }

    public static boolean isCharacterStreamAssignable(int n) {
        return DataTypeDescriptor.isAsciiStreamAssignable(n);
    }

    public String toString() {
        return this.typeDescriptor.toString();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.typeDescriptor = (TypeDescriptorImpl)objectInput.readObject();
        this.typeId = TypeId.getBuiltInTypeId(this.getTypeName());
        this.collationDerivation = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.typeDescriptor);
        objectOutput.writeInt(this.getCollationDerivation());
    }

    public int getTypeFormatId() {
        return 240;
    }

    public boolean isUserCreatableType() throws StandardException {
        switch (this.typeId.getJDBCTypeId()) {
            case 16: {
                return false;
            }
            case 2000: {
                return this.getTypeId().getBaseTypeId().isAnsiUDT();
            }
            case 3: {
                return this.getPrecision() <= this.typeId.getMaximumPrecision() && this.getScale() <= this.typeId.getMaximumScale() && this.getMaximumWidth() <= this.typeId.getMaximumMaximumWidth();
            }
        }
        return true;
    }

    public String getFullSQLTypeName() {
        StringBuffer stringBuffer = new StringBuffer(this.typeId.getSQLTypeName());
        if (this.typeId.isDecimalTypeId() || this.typeId.isNumericTypeId()) {
            stringBuffer.append("(");
            stringBuffer.append(this.getPrecision());
            stringBuffer.append(", ");
            stringBuffer.append(this.getScale());
            stringBuffer.append(")");
        } else if (this.typeId.variableLength()) {
            stringBuffer.append("(");
            stringBuffer.append(this.getMaximumWidth());
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getSQLTypeNameWithCollation() {
        String string2 = this.typeId.getSQLTypeName();
        if (this.typeId.isStringTypeId()) {
            string2 = string2 + " (" + this.getCollationName() + ")";
        }
        return string2;
    }
}

