/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.BinaryDecimal;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;

public final class BigIntegerDecimal
extends BinaryDecimal {
    private static final BigInteger TEN = BigInteger.valueOf(10L);
    private static final BigInteger MAXLONG_PLUS_ONE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
    private static final BigInteger MINLONG_MINUS_ONE = BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE);

    public DataValueDescriptor getNewNull() {
        return new BigIntegerDecimal();
    }

    public long getLong() throws StandardException {
        if (this.isNull()) {
            return 0L;
        }
        BigInteger bigInteger = new BigInteger(this.data2c);
        boolean bl = false;
        if (bigInteger.compareTo(MAXLONG_PLUS_ONE) < 0 && bigInteger.compareTo(MINLONG_MINUS_ONE) > 0) {
            bl = true;
        }
        for (int i = 0; i < this.sqlScale; ++i) {
            bigInteger = bigInteger.divide(TEN);
            if (bl || bigInteger.compareTo(MAXLONG_PLUS_ONE) >= 0 || bigInteger.compareTo(MINLONG_MINUS_ONE) <= 0) continue;
            bl = true;
        }
        if (!bl) {
            throw StandardException.newException("22003", "BIGINT");
        }
        return bigInteger.longValue();
    }

    public float getFloat() throws StandardException {
        if (this.isNull()) {
            return 0.0f;
        }
        return NumberDataType.normalizeREAL(Float.parseFloat(this.getString()));
    }

    public double getDouble() throws StandardException {
        if (this.isNull()) {
            return 0.0;
        }
        return NumberDataType.normalizeDOUBLE(Double.parseDouble(this.getString()));
    }

    public boolean getBoolean() {
        if (this.isNull()) {
            return false;
        }
        BigInteger bigInteger = new BigInteger(this.data2c);
        return bigInteger.compareTo(BigInteger.ZERO) != 0;
    }

    public void setValue(String string2) throws StandardException {
        if (string2 == null) {
            this.restoreToNull();
            return;
        }
        string2 = string2.trim();
        int n = string2.indexOf(46);
        int n2 = string2.indexOf(101);
        if (n2 == -1) {
            n2 = string2.indexOf(69);
        }
        int n3 = 0;
        try {
            if (n2 != -1) {
                if (n > n2) {
                    throw this.invalidFormat();
                }
                int n4 = n2 + 1;
                if (n4 >= string2.length()) {
                    throw this.invalidFormat();
                }
                if (string2.charAt(n4) == '+') {
                    if (++n4 >= string2.length()) {
                        throw this.invalidFormat();
                    }
                    if (string2.charAt(n4) == '-') {
                        throw this.invalidFormat();
                    }
                }
                String string3 = string2.substring(n4);
                n3 = -1 * Integer.parseInt(string3);
                string2 = string2.substring(0, n2);
            }
            if (n != -1) {
                String string4 = string2.substring(0, n);
                n3 += string2.length() - (n + 1);
                string2 = string4.concat(string2.substring(n + 1, string2.length()));
            }
            if (n3 < 0) {
                for (int i = n3; i < 0; ++i) {
                    string2 = string2.concat("0");
                }
                n3 = 0;
            }
            BigInteger bigInteger = new BigInteger(string2);
            this.data2c = bigInteger.toByteArray();
            this.sqlScale = n3;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidFormat();
        }
    }

    public Object getObject() throws StandardException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.getString());
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        String string2 = new BigInteger(this.data2c).toString();
        if (this.sqlScale == 0) {
            return string2;
        }
        boolean bl = this.isNegative();
        if (this.sqlScale >= string2.length() - (bl ? 1 : 0)) {
            if (bl) {
                string2 = string2.substring(1);
            }
            String string3 = bl ? "-0." : "0.";
            for (int i = this.sqlScale - string2.length(); i > 0; --i) {
                string3 = string3.concat("0");
            }
            return string3.concat(string2);
        }
        String string4 = string2.substring(0, string2.length() - this.sqlScale);
        string4 = string4.concat(".");
        return string4.concat(string2.substring(string2.length() - this.sqlScale, string2.length()));
    }

    public int getDecimalValuePrecision() {
        if (this.isNull()) {
            return 0;
        }
        BigInteger bigInteger = new BigInteger(this.data2c);
        if (BigInteger.ZERO.equals(bigInteger)) {
            return 0;
        }
        int n = bigInteger.toString().length();
        if (this.isNegative()) {
            --n;
        }
        if (n < this.sqlScale) {
            return this.sqlScale;
        }
        return n;
    }

    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        BigIntegerDecimal bigIntegerDecimal = this.getBID(dataValueDescriptor);
        int n = this.getDecimalValueScale();
        int n2 = bigIntegerDecimal.getDecimalValueScale();
        BigInteger bigInteger = new BigInteger(this.data2c);
        BigInteger bigInteger2 = new BigInteger(bigIntegerDecimal.data2c);
        if (n < n2) {
            bigInteger = BigIntegerDecimal.rescale(bigInteger, n2 - n);
        } else if (n2 < n) {
            bigInteger2 = BigIntegerDecimal.rescale(bigInteger2, n - n2);
        }
        return bigInteger.compareTo(bigInteger2);
    }

    public NumberDataValue plusNN(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        BinaryDecimal binaryDecimal = (BinaryDecimal)numberDataValue3;
        if (binaryDecimal == null) {
            binaryDecimal = new BigIntegerDecimal();
        }
        BigIntegerDecimal bigIntegerDecimal = this.getBID(numberDataValue);
        BigIntegerDecimal bigIntegerDecimal2 = this.getBID(numberDataValue2);
        int n = bigIntegerDecimal.getDecimalValueScale();
        int n2 = bigIntegerDecimal2.getDecimalValueScale();
        BigInteger bigInteger = new BigInteger(bigIntegerDecimal.data2c);
        BigInteger bigInteger2 = new BigInteger(bigIntegerDecimal2.data2c);
        int n3 = n;
        if (n < n2) {
            bigInteger = BigIntegerDecimal.rescale(bigInteger, n2 - n);
            n3 = n2;
        } else if (n2 < n) {
            bigInteger2 = BigIntegerDecimal.rescale(bigInteger2, n - n2);
        }
        bigInteger = bigInteger.add(bigInteger2);
        binaryDecimal.data2c = bigInteger.toByteArray();
        binaryDecimal.sqlScale = n3;
        return binaryDecimal;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = (NumberDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
        } else {
            BinaryDecimal binaryDecimal = (BinaryDecimal)numberDataValue;
            BigInteger bigInteger = new BigInteger(this.data2c);
            binaryDecimal.data2c = bigInteger.negate().toByteArray();
            binaryDecimal.sqlScale = this.sqlScale;
        }
        return numberDataValue;
    }

    public NumberDataValue timesNN(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        BigIntegerDecimal bigIntegerDecimal = (BigIntegerDecimal)numberDataValue3;
        if (bigIntegerDecimal == null) {
            bigIntegerDecimal = new BigIntegerDecimal();
        }
        BigIntegerDecimal bigIntegerDecimal2 = this.getBID(numberDataValue);
        BigIntegerDecimal bigIntegerDecimal3 = this.getBID(numberDataValue2);
        BigInteger bigInteger = new BigInteger(bigIntegerDecimal2.data2c);
        BigInteger bigInteger2 = new BigInteger(bigIntegerDecimal3.data2c);
        bigInteger2 = bigInteger.multiply(bigInteger2);
        bigIntegerDecimal.data2c = bigInteger2.toByteArray();
        bigIntegerDecimal.sqlScale = bigIntegerDecimal2.getDecimalValueScale() + bigIntegerDecimal3.getDecimalValueScale();
        return bigIntegerDecimal;
    }

    public NumberDataValue divideNN(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n) throws StandardException {
        BinaryDecimal binaryDecimal = (BinaryDecimal)numberDataValue3;
        if (binaryDecimal == null) {
            binaryDecimal = new BigIntegerDecimal();
        }
        BigIntegerDecimal bigIntegerDecimal = this.getBID(numberDataValue);
        BigIntegerDecimal bigIntegerDecimal2 = this.getBID(numberDataValue2);
        BigInteger bigInteger = new BigInteger(bigIntegerDecimal.data2c);
        BigInteger bigInteger2 = new BigInteger(bigIntegerDecimal2.data2c);
        if (BigInteger.ZERO.equals(bigInteger2)) {
            throw StandardException.newException("22012");
        }
        int n2 = bigIntegerDecimal.getDecimalValueScale();
        int n3 = bigIntegerDecimal2.getDecimalValueScale();
        if (n >= 0 && n2 < n + n3) {
            bigInteger = BigIntegerDecimal.rescale(bigInteger, n + n3 - n2);
            n2 = n + n3;
        }
        bigInteger2 = bigInteger.divide(bigInteger2);
        binaryDecimal.sqlScale = n2 - n3;
        if (binaryDecimal.sqlScale < 0) {
            bigInteger2 = BigIntegerDecimal.rescale(bigInteger2, -binaryDecimal.sqlScale);
            binaryDecimal.sqlScale = 0;
        }
        binaryDecimal.data2c = bigInteger2.toByteArray();
        return binaryDecimal;
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getScale();
        int n2 = dataTypeDescriptor.getPrecision();
        this.setFrom(dataValueDescriptor);
        this.setWidth(n2, n, true);
    }

    public void setWidth(int n, int n2, boolean bl) throws StandardException {
        int n3;
        int n4;
        if (this.isNull()) {
            return;
        }
        int n5 = n2 - this.sqlScale;
        if (n != -1 && (n4 = (n3 = this.getDecimalValuePrecision()) + n5) > n) {
            throw StandardException.newException("22003", "DECIMAL/NUMERIC(" + n + "," + n2 + ")");
        }
        if (n5 == 0) {
            return;
        }
        BigInteger bigInteger = new BigInteger(this.data2c);
        bigInteger = BigIntegerDecimal.rescale(bigInteger, n5);
        this.data2c = bigInteger.toByteArray();
        this.sqlScale = n2;
    }

    private BigIntegerDecimal getBID(DataValueDescriptor dataValueDescriptor) throws StandardException {
        switch (dataValueDescriptor.typeToBigDecimal()) {
            case 3: {
                return (BigIntegerDecimal)dataValueDescriptor;
            }
            case 1: {
                BigIntegerDecimal bigIntegerDecimal = new BigIntegerDecimal();
                bigIntegerDecimal.setValue(dataValueDescriptor.getString());
                return bigIntegerDecimal;
            }
            case -5: {
                BigIntegerDecimal bigIntegerDecimal = new BigIntegerDecimal();
                bigIntegerDecimal.setValue(dataValueDescriptor.getLong());
                return bigIntegerDecimal;
            }
        }
        return null;
    }

    private static BigInteger rescale(BigInteger bigInteger, int n) {
        block4: {
            block3: {
                if (n == 0) {
                    return bigInteger;
                }
                if (n <= 0) break block3;
                for (int i = 0; i < n; ++i) {
                    bigInteger = bigInteger.multiply(TEN);
                }
                break block4;
            }
            if (n >= 0) break block4;
            for (int i = n; i < 0; ++i) {
                bigInteger = bigInteger.divide(TEN);
            }
        }
        return bigInteger;
    }

    public void setBigDecimal(Number number2) throws StandardException {
        if (number2 == null) {
            this.setToNull();
        } else {
            this.setValue(number2.toString());
        }
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getString();
    }
}

