/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access.xa;

import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.store.access.GlobalXact;
import org.apache.derby.iapi.util.StringUtil;

public class XAXactId
extends GlobalXact
implements Xid {
    private static final char COLON = ':';

    private void copy_init_xid(int n, byte[] byArray, byte[] byArray2) {
        this.format_id = n;
        this.global_id = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.global_id, 0, byArray.length);
        this.branch_id = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, this.branch_id, 0, byArray2.length);
    }

    public XAXactId(int n, byte[] byArray, byte[] byArray2) {
        this.copy_init_xid(n, byArray, byArray2);
    }

    public XAXactId(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-4);
        }
        this.copy_init_xid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public String toHexString() {
        int n = 20 + (this.global_id.length + this.branch_id.length) * 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(':').append(Integer.toString(this.global_id.length)).append(':').append(Integer.toString(this.branch_id.length)).append(':').append(Integer.toString(this.format_id, 16)).append(':').append(StringUtil.toHexString(this.global_id, 0, this.global_id.length)).append(':').append(StringUtil.toHexString(this.branch_id, 0, this.branch_id.length)).append(':');
        return stringBuffer.toString();
    }

    public XAXactId(String string2) {
        int n = 1;
        int n2 = string2.indexOf(58, n);
        String string3 = string2.substring(n, n2);
        int n3 = Integer.parseInt(string3);
        n = n2 + 1;
        n2 = string2.indexOf(58, n);
        String string4 = string2.substring(n, n2);
        int n4 = Integer.parseInt(string4);
        n = n2 + 1;
        n2 = string2.indexOf(58, n);
        String string5 = string2.substring(n, n2);
        this.format_id = Integer.parseInt(string5, 16);
        n = n2 + 1;
        n2 = string2.indexOf(58, n);
        this.global_id = StringUtil.fromHexString(string2, n, n2 - n);
        n = n2 + 1;
        n2 = string2.indexOf(58, n);
        this.branch_id = StringUtil.fromHexString(string2, n, n2 - n);
    }

    public int getFormatId() {
        return this.format_id;
    }

    public byte[] getGlobalTransactionId() {
        return this.global_id;
    }

    public byte[] getBranchQualifier() {
        return this.branch_id;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            if (object instanceof GlobalXact) {
                return super.equals(object);
            }
            Xid xid = (Xid)object;
            return Arrays.equals(xid.getGlobalTransactionId(), this.global_id) && Arrays.equals(xid.getBranchQualifier(), this.branch_id) && xid.getFormatId() == this.format_id;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

