/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.store.access.DiskHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.PropertyUtil;

public class BackingStoreHashtable {
    private TransactionController tc;
    private HashMap hash_table;
    private int[] key_column_numbers;
    private boolean remove_duplicates;
    private boolean skipNullKeyColumns;
    private Properties auxillary_runtimestats;
    private RowSource row_source;
    private long max_inmemory_rowcnt;
    private long inmemory_rowcnt;
    private long max_inmemory_size;
    private boolean keepAfterCommit;
    private static final int ARRAY_LIST_SIZE = ClassSize.estimateBaseFromCatalog(ArrayList.class);
    private DiskHashtable diskHashtable;

    private BackingStoreHashtable() {
    }

    public BackingStoreHashtable(TransactionController transactionController, RowSource rowSource, int[] nArray, boolean bl, long l, long l2, int n, float f2, boolean bl2, boolean bl3) throws StandardException {
        this.key_column_numbers = nArray;
        this.remove_duplicates = bl;
        this.row_source = rowSource;
        this.skipNullKeyColumns = bl2;
        this.max_inmemory_rowcnt = l2;
        this.max_inmemory_size = l2 > 0L ? Long.MAX_VALUE : Runtime.getRuntime().totalMemory() / 100L;
        this.tc = transactionController;
        this.keepAfterCommit = bl3;
        if (n != -1) {
            this.hash_table = f2 == -1.0f ? new HashMap(n) : new HashMap(n, f2);
        } else {
            HashMap hashMap = l <= 0L || rowSource == null ? new HashMap() : (this.hash_table = l < this.max_inmemory_size ? new HashMap((int)l) : null);
        }
        if (rowSource != null) {
            DataValueDescriptor[] dataValueDescriptorArray;
            boolean bl4 = rowSource.needsToClone();
            while ((dataValueDescriptorArray = this.getNextRowFromRowSource()) != null) {
                if (this.hash_table == null) {
                    double d = this.getEstimatedMemUsage(dataValueDescriptorArray);
                    this.hash_table = new HashMap((int)((double)this.max_inmemory_size / d));
                }
                this.add_row_to_hash_table(dataValueDescriptorArray, bl4);
            }
        }
        if (this.hash_table == null) {
            this.hash_table = new HashMap();
        }
    }

    private DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = this.row_source.getNextRowFromRowSource();
        if (this.skipNullKeyColumns) {
            while (dataValueDescriptorArray != null) {
                int n;
                for (n = 0; n < this.key_column_numbers.length && !dataValueDescriptorArray[this.key_column_numbers[n]].isNull(); ++n) {
                }
                if (n == this.key_column_numbers.length) {
                    return dataValueDescriptorArray;
                }
                dataValueDescriptorArray = this.row_source.getNextRowFromRowSource();
            }
        }
        return dataValueDescriptorArray;
    }

    private static DataValueDescriptor[] cloneRow(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
            if (dataValueDescriptorArray[i] == null) continue;
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[i].cloneValue(false);
        }
        return dataValueDescriptorArray2;
    }

    static DataValueDescriptor[] shallowCloneRow(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
            if (dataValueDescriptorArray[i] == null) continue;
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[i].cloneHolder();
        }
        return dataValueDescriptorArray2;
    }

    private void add_row_to_hash_table(DataValueDescriptor[] dataValueDescriptorArray, boolean bl) throws StandardException {
        if (this.spillToDisk(dataValueDescriptorArray)) {
            return;
        }
        if (bl) {
            dataValueDescriptorArray = BackingStoreHashtable.cloneRow(dataValueDescriptorArray);
        }
        Object object = KeyHasher.buildHashKey(dataValueDescriptorArray, this.key_column_numbers);
        DataValueDescriptor[] dataValueDescriptorArray2 = null;
        dataValueDescriptorArray2 = this.hash_table.put(object, dataValueDescriptorArray);
        if (dataValueDescriptorArray2 == null) {
            this.doSpaceAccounting(dataValueDescriptorArray, false);
        } else if (!this.remove_duplicates) {
            List<DataValueDescriptor[]> list2;
            if (dataValueDescriptorArray2 instanceof List) {
                this.doSpaceAccounting(dataValueDescriptorArray, false);
                list2 = (List)dataValueDescriptorArray2;
            } else {
                list2 = new ArrayList<DataValueDescriptor[]>(2);
                list2.add(dataValueDescriptorArray2);
                this.doSpaceAccounting(dataValueDescriptorArray, true);
            }
            list2.add(dataValueDescriptorArray);
            this.hash_table.put(object, list2);
        }
        dataValueDescriptorArray = null;
    }

    private void doSpaceAccounting(DataValueDescriptor[] dataValueDescriptorArray, boolean bl) {
        ++this.inmemory_rowcnt;
        if (this.max_inmemory_rowcnt <= 0L) {
            this.max_inmemory_size -= this.getEstimatedMemUsage(dataValueDescriptorArray);
            if (bl) {
                this.max_inmemory_size -= (long)ARRAY_LIST_SIZE;
            }
        }
    }

    private boolean spillToDisk(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        Object object;
        Object v;
        if (this.diskHashtable == null) {
            if (this.max_inmemory_rowcnt > 0L ? this.inmemory_rowcnt < this.max_inmemory_rowcnt : this.max_inmemory_size > this.getEstimatedMemUsage(dataValueDescriptorArray)) {
                return false;
            }
            this.diskHashtable = new DiskHashtable(this.tc, dataValueDescriptorArray, null, this.key_column_numbers, this.remove_duplicates, this.keepAfterCommit);
        }
        if ((v = this.hash_table.get(object = KeyHasher.buildHashKey(dataValueDescriptorArray, this.key_column_numbers))) != null) {
            if (this.remove_duplicates) {
                return true;
            }
            if (v instanceof List) {
                List list2 = (List)v;
                for (int i = list2.size() - 1; i >= 0; --i) {
                    Object[] objectArray = (DataValueDescriptor[])list2.get(i);
                    this.diskHashtable.put(object, objectArray);
                }
            } else {
                this.diskHashtable.put(object, (DataValueDescriptor[])v);
            }
            this.hash_table.remove(object);
        }
        this.diskHashtable.put(object, dataValueDescriptorArray);
        return true;
    }

    private long getEstimatedMemUsage(DataValueDescriptor[] dataValueDescriptorArray) {
        long l = 0L;
        for (int i = 0; i < dataValueDescriptorArray.length; ++i) {
            l += (long)dataValueDescriptorArray[i].estimateMemoryUsage();
            l += (long)ClassSize.refSize;
        }
        return l += (long)ClassSize.refSize;
    }

    public void close() throws StandardException {
        this.hash_table = null;
        if (this.diskHashtable != null) {
            this.diskHashtable.close();
            this.diskHashtable = null;
        }
    }

    public Enumeration elements() throws StandardException {
        if (this.diskHashtable == null) {
            return Collections.enumeration(this.hash_table.values());
        }
        return new BackingStoreHashtableEnumeration();
    }

    public Object get(Object object) throws StandardException {
        Object v = this.hash_table.get(object);
        if (this.diskHashtable == null || v != null) {
            return v;
        }
        return this.diskHashtable.get(object);
    }

    public void getAllRuntimeStats(Properties properties) throws StandardException {
        if (this.auxillary_runtimestats != null) {
            PropertyUtil.copyProperties(this.auxillary_runtimestats, properties);
        }
    }

    public Object remove(Object object) throws StandardException {
        Object v = this.hash_table.remove(object);
        if (v != null || this.diskHashtable == null) {
            return v;
        }
        return this.diskHashtable.remove(object);
    }

    public void setAuxillaryRuntimeStats(Properties properties) throws StandardException {
        this.auxillary_runtimestats = properties;
    }

    public boolean putRow(boolean bl, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.skipNullKeyColumns) {
            for (int i = 0; i < this.key_column_numbers.length; ++i) {
                if (!dataValueDescriptorArray[this.key_column_numbers[i]].isNull()) continue;
                return false;
            }
        }
        Object object = KeyHasher.buildHashKey(dataValueDescriptorArray, this.key_column_numbers);
        if (this.remove_duplicates && this.get(object) != null) {
            return false;
        }
        this.add_row_to_hash_table(dataValueDescriptorArray, bl);
        return true;
    }

    public int size() throws StandardException {
        if (this.diskHashtable == null) {
            return this.hash_table.size();
        }
        return this.hash_table.size() + this.diskHashtable.size();
    }

    private class BackingStoreHashtableEnumeration
    implements Enumeration {
        private Iterator memoryIterator;
        private Enumeration diskEnumeration;

        BackingStoreHashtableEnumeration() {
            this.memoryIterator = BackingStoreHashtable.this.hash_table.values().iterator();
            if (BackingStoreHashtable.this.diskHashtable != null) {
                try {
                    this.diskEnumeration = BackingStoreHashtable.this.diskHashtable.elements();
                }
                catch (StandardException standardException) {
                    this.diskEnumeration = null;
                }
            }
        }

        public boolean hasMoreElements() {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return true;
                }
                this.memoryIterator = null;
            }
            if (this.diskEnumeration == null) {
                return false;
            }
            return this.diskEnumeration.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return this.memoryIterator.next();
                }
                this.memoryIterator = null;
            }
            return this.diskEnumeration.nextElement();
        }
    }
}

