/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;

public final class UserDescriptor
extends TupleDescriptor {
    private String _userName;
    private String _hashingScheme;
    private char[] _password;
    private Timestamp _lastModified;

    public UserDescriptor(DataDictionary dataDictionary, String string2, String string3, char[] cArray, Timestamp timestamp) {
        super(dataDictionary);
        this._userName = string2;
        this._hashingScheme = string3;
        if (cArray == null) {
            this._password = null;
        } else {
            this._password = new char[cArray.length];
            System.arraycopy(cArray, 0, this._password, 0, cArray.length);
        }
        this._lastModified = timestamp;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getHashingScheme() {
        return this._hashingScheme;
    }

    public Timestamp getLastModified() {
        return this._lastModified;
    }

    public char[] getAndZeroPassword() {
        int n = this._password.length;
        char[] cArray = new char[n];
        System.arraycopy(this._password, 0, cArray, 0, n);
        Arrays.fill(this._password, '\u0000');
        return cArray;
    }

    public String getDescriptorType() {
        return "User";
    }

    public String getDescriptorName() {
        return this._userName;
    }
}

