/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class TablePermsDescriptor
extends PermissionsDescriptor {
    private UUID tableUUID;
    private String tableName;
    private String selectPriv;
    private String deletePriv;
    private String insertPriv;
    private String updatePriv;
    private String referencesPriv;
    private String triggerPriv;

    public TablePermsDescriptor(DataDictionary dataDictionary, String string2, String string3, UUID uUID, String string4, String string5, String string6, String string7, String string8, String string9) throws StandardException {
        super(dataDictionary, string2, string3);
        this.tableUUID = uUID;
        this.selectPriv = string4;
        this.deletePriv = string5;
        this.insertPriv = string6;
        this.updatePriv = string7;
        this.referencesPriv = string8;
        this.triggerPriv = string9;
        if (uUID != null) {
            this.tableName = dataDictionary.getTableDescriptor(uUID).getName();
        }
    }

    public TablePermsDescriptor(DataDictionary dataDictionary, String string2, String string3, UUID uUID) throws StandardException {
        this(dataDictionary, string2, string3, uUID, null, null, null, null, null, null);
    }

    public TablePermsDescriptor(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        this(dataDictionary, null, null, null, null, null, null, null, null, null);
        this.oid = uUID;
    }

    public int getCatalogNumber() {
        return 16;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public String getSelectPriv() {
        return this.selectPriv;
    }

    public String getDeletePriv() {
        return this.deletePriv;
    }

    public String getInsertPriv() {
        return this.insertPriv;
    }

    public String getUpdatePriv() {
        return this.updatePriv;
    }

    public String getReferencesPriv() {
        return this.referencesPriv;
    }

    public String getTriggerPriv() {
        return this.triggerPriv;
    }

    public String toString() {
        return "tablePerms: grantee=" + this.getGrantee() + ",tablePermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",tableUUID=" + this.getTableUUID() + ",selectPriv=" + this.getSelectPriv() + ",deletePriv=" + this.getDeletePriv() + ",insertPriv=" + this.getInsertPriv() + ",updatePriv=" + this.getUpdatePriv() + ",referencesPriv=" + this.getReferencesPriv() + ",triggerPriv=" + this.getTriggerPriv();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TablePermsDescriptor)) {
            return false;
        }
        TablePermsDescriptor tablePermsDescriptor = (TablePermsDescriptor)object;
        return super.keyEquals(tablePermsDescriptor) && this.tableUUID.equals(tablePermsDescriptor.tableUUID);
    }

    public int hashCode() {
        return super.keyHashCode() + this.tableUUID.hashCode();
    }

    public boolean checkOwner(String string2) throws StandardException {
        TableDescriptor tableDescriptor = this.getDataDictionary().getTableDescriptor(this.tableUUID);
        return tableDescriptor.getSchemaDescriptor().getAuthorizationId().equals(string2);
    }

    public String getObjectName() {
        return "Table Privilege on " + this.tableName;
    }

    public String getClassType() {
        return "TablePrivilege";
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(462);
    }
}

