/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;

public final class StatementGenericPermission
extends StatementPermission {
    private UUID _objectID;
    private String _objectType;
    private String _privilege;

    public StatementGenericPermission(UUID uUID, String string2, String string3) {
        this._objectID = uUID;
        this._objectType = string2;
        this._privilege = string3;
    }

    public UUID getObjectID() {
        return this._objectID;
    }

    public String getPrivilege() {
        return this._privilege;
    }

    public String getObjectType() {
        return this._objectType;
    }

    public void check(LanguageConnectionContext languageConnectionContext, boolean bl, Activation activation) throws StandardException {
        this.genericCheck(languageConnectionContext, bl, activation, this._privilege);
    }

    public boolean isCorrectPermission(PermissionsDescriptor permissionsDescriptor) {
        if (permissionsDescriptor == null || !(permissionsDescriptor instanceof PermDescriptor)) {
            return false;
        }
        PermDescriptor permDescriptor = (PermDescriptor)permissionsDescriptor;
        return permDescriptor.getPermObjectId().equals(this._objectID) && permDescriptor.getObjectType().equals(this._objectType) && permDescriptor.getPermission().equals(this._privilege);
    }

    public PrivilegedSQLObject getPrivilegedObject(DataDictionary dataDictionary) throws StandardException {
        if ("TYPE".equals(this._objectType)) {
            return dataDictionary.getAliasDescriptor(this._objectID);
        }
        if ("SEQUENCE".equals(this._objectType)) {
            return dataDictionary.getSequenceDescriptor(this._objectID);
        }
        throw StandardException.newException("XSCB3.S");
    }

    public PermissionsDescriptor getPermissionDescriptor(String string2, DataDictionary dataDictionary) throws StandardException {
        return dataDictionary.getGenericPermissions(this._objectID, this._objectType, this._privilege, string2);
    }

    public String toString() {
        return "StatementGenericPermission( " + this._objectID + ", " + this._objectType + ", " + this._privilege + " )";
    }
}

