/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class ColPermsDescriptor
extends PermissionsDescriptor {
    private UUID tableUUID;
    private String type;
    private FormatableBitSet columns;
    private String tableName;

    public ColPermsDescriptor(DataDictionary dataDictionary, String string2, String string3, UUID uUID, String string4, FormatableBitSet formatableBitSet) throws StandardException {
        super(dataDictionary, string2, string3);
        this.tableUUID = uUID;
        this.type = string4;
        this.columns = formatableBitSet;
        if (uUID != null) {
            this.tableName = dataDictionary.getTableDescriptor(uUID).getName();
        }
    }

    public ColPermsDescriptor(DataDictionary dataDictionary, String string2, String string3, UUID uUID, String string4) throws StandardException {
        this(dataDictionary, string2, string3, uUID, string4, null);
    }

    public ColPermsDescriptor(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        super(dataDictionary, null, null);
        this.oid = uUID;
    }

    public int getCatalogNumber() {
        return 17;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public String getType() {
        return this.type;
    }

    public FormatableBitSet getColumns() {
        return this.columns;
    }

    public String toString() {
        return "colPerms: grantee=" + this.getGrantee() + ",colPermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",tableUUID=" + this.getTableUUID() + ",type=" + this.getType() + ",columns=" + this.getColumns();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColPermsDescriptor)) {
            return false;
        }
        ColPermsDescriptor colPermsDescriptor = (ColPermsDescriptor)object;
        return super.keyEquals(colPermsDescriptor) && this.tableUUID.equals(colPermsDescriptor.tableUUID) && (this.type == null ? colPermsDescriptor.type == null : this.type.equals(colPermsDescriptor.type));
    }

    public int hashCode() {
        return super.keyHashCode() + this.tableUUID.hashCode() + (this.type == null ? 0 : this.type.hashCode());
    }

    public boolean checkOwner(String string2) throws StandardException {
        TableDescriptor tableDescriptor = this.getDataDictionary().getTableDescriptor(this.tableUUID);
        return tableDescriptor.getSchemaDescriptor().getAuthorizationId().equals(string2);
    }

    public String getObjectName() {
        return "Column Privilege on " + this.tableName;
    }

    public String getClassType() {
        return "ColumnsPrivilege";
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(463);
    }
}

