/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.property;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;

public class PropertyUtil {
    public static final String[] servicePropertyList = new String[]{"derby.engineType", "derby.database.noAutoBoot", "derby.storage.tempDirectory", "encryptionProvider", "encryptionAlgorithm", "restoreFrom", "logDevice", "derby.storage.logArchiveMode"};
    public static final int SET_IN_JVM = 0;
    public static final int SET_IN_DATABASE = 1;
    public static final int SET_IN_APPLICATION = 2;
    public static final int NOT_SET = -1;

    static int whereSet(String string2, Dictionary dictionary) {
        boolean bl = PropertyUtil.isDBOnly(dictionary);
        if (!bl && Monitor.getMonitor().getJVMProperty(string2) != null) {
            return 0;
        }
        if (dictionary != null && dictionary.get(string2) != null) {
            return 1;
        }
        if (!bl && PropertyUtil.getSystemProperty(string2) != null) {
            return 2;
        }
        return -1;
    }

    public static boolean isDBOnly(Dictionary dictionary) {
        if (dictionary == null) {
            return false;
        }
        String string2 = (String)dictionary.get("derby.database.propertiesOnly");
        boolean bl = Boolean.valueOf(string2 != null ? string2.trim() : string2);
        return bl;
    }

    public static boolean isDBOnly(Properties properties) {
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("derby.database.propertiesOnly");
        boolean bl = Boolean.valueOf(string2 != null ? string2.trim() : string2);
        return bl;
    }

    public static String getSystemProperty(String string2) {
        return PropertyUtil.getSystemProperty(string2, null);
    }

    public static String getSystemProperty(String string2, String string3) {
        Properties properties;
        ModuleFactory moduleFactory = Monitor.getMonitorLite();
        String string4 = moduleFactory.getJVMProperty(string2);
        if (string4 == null && (properties = moduleFactory.getApplicationProperties()) != null) {
            string4 = properties.getProperty(string2);
        }
        return string4 == null ? string3 : string4;
    }

    public static String getPropertyFromSet(Properties properties, String string2) {
        String string3;
        boolean bl;
        boolean bl2 = bl = properties != null ? PropertyUtil.isDBOnly(properties) : false;
        if ("derby.authentication.provider".equals(string2) && PropertyUtil.nativeAuthenticationEnabled(string3 = PropertyUtil.getPropertyFromSet(true, properties, string2))) {
            return string3;
        }
        return PropertyUtil.getPropertyFromSet(bl, properties, string2);
    }

    public static Serializable getPropertyFromSet(Dictionary dictionary, String string2) {
        boolean bl = dictionary != null ? PropertyUtil.isDBOnly(dictionary) : false;
        return PropertyUtil.getPropertyFromSet(bl, dictionary, string2);
    }

    public static Serializable getPropertyFromSet(boolean bl, Dictionary dictionary, String string2) {
        if (dictionary != null) {
            Object object;
            if (!bl && (object = Monitor.getMonitor().getJVMProperty(string2)) != null) {
                return object;
            }
            object = (Serializable)dictionary.get(string2);
            if (object != null) {
                return object;
            }
            if (bl) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(string2);
    }

    public static String getPropertyFromSet(boolean bl, Properties properties, String string2) {
        if (properties != null) {
            String string3;
            if (!bl && (string3 = Monitor.getMonitor().getJVMProperty(string2)) != null) {
                return string3;
            }
            string3 = properties.getProperty(string2);
            if (string3 != null) {
                return string3;
            }
            if (bl) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(string2);
    }

    public static String getDatabaseProperty(PersistentSet persistentSet, String string2) throws StandardException {
        if (persistentSet == null) {
            return null;
        }
        Serializable serializable2 = persistentSet.getProperty(string2);
        if (serializable2 == null) {
            return null;
        }
        return serializable2.toString();
    }

    public static String getServiceProperty(PersistentSet persistentSet, String string2, String string3) throws StandardException {
        String string4 = PropertyUtil.getDatabaseProperty(persistentSet, "derby.database.propertiesOnly");
        boolean bl = Boolean.valueOf(string4 != null ? string4.trim() : string4);
        if (!bl && (string4 = Monitor.getMonitor().getJVMProperty(string2)) != null) {
            return string4;
        }
        string4 = PropertyUtil.getDatabaseProperty(persistentSet, string2);
        if (string4 != null) {
            return string4;
        }
        if (bl) {
            return string3;
        }
        return PropertyUtil.getSystemProperty(string2, string3);
    }

    public static String getServiceProperty(PersistentSet persistentSet, String string2) throws StandardException {
        return PropertyUtil.getServiceProperty(persistentSet, string2, null);
    }

    public static boolean getSystemBoolean(String string2) {
        return PropertyUtil.getSystemBoolean(string2, false);
    }

    public static boolean getSystemBoolean(String string2, boolean bl) {
        String string3 = PropertyUtil.getSystemProperty(string2);
        if (string3 == null) {
            return bl;
        }
        return Boolean.valueOf(string3.trim());
    }

    public static boolean getServiceBoolean(PersistentSet persistentSet, String string2, boolean bl) throws StandardException {
        String string3 = PropertyUtil.getServiceProperty(persistentSet, string2);
        return PropertyUtil.booleanProperty(string2, (Serializable)((Object)string3), bl);
    }

    public static int getSystemInt(String string2, int n, int n2, int n3) {
        return PropertyUtil.handleInt(PropertyUtil.getSystemProperty(string2), n, n2, n3);
    }

    public static int getServiceInt(PersistentSet persistentSet, String string2, int n, int n2, int n3) throws StandardException {
        return PropertyUtil.handleInt(PropertyUtil.getServiceProperty(persistentSet, string2), n, n2, n3);
    }

    public static int getServiceInt(PersistentSet persistentSet, Properties properties, String string2, int n, int n2, int n3) throws StandardException {
        String string3 = null;
        if (properties != null) {
            string3 = properties.getProperty(string2);
        }
        if (string3 == null) {
            string3 = PropertyUtil.getServiceProperty(persistentSet, string2);
        }
        return PropertyUtil.handleInt(string3, n, n2, n3);
    }

    public static int getSystemInt(String string2, int n) {
        return PropertyUtil.getSystemInt(string2, 0, Integer.MAX_VALUE, n);
    }

    public static int handleInt(String string2, int n, int n2, int n3) {
        if (string2 == null) {
            return n3;
        }
        try {
            int n4 = Integer.parseInt(string2);
            if (n4 >= n && n4 <= n2) {
                return n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n3;
    }

    public static boolean booleanProperty(String string2, Serializable serializable2, boolean bl) throws StandardException {
        if (serializable2 == null) {
            return bl;
        }
        String string3 = ((String)((Object)serializable2)).trim();
        if ("TRUE".equals(StringUtil.SQLToUpperCase(string3))) {
            return true;
        }
        if ("FALSE".equals(StringUtil.SQLToUpperCase(string3))) {
            return false;
        }
        throw StandardException.newException("XCY00.S", (Object)string2, (Object)string3);
    }

    public static int intPropertyValue(String string2, Serializable serializable2, int n, int n2, int n3) throws StandardException {
        if (serializable2 == null) {
            return n3;
        }
        String string3 = ((String)((Object)serializable2)).trim();
        try {
            int n4 = Integer.parseInt(string3);
            if (n4 < n || n4 > n2) {
                throw StandardException.newException("XCY00.S", (Object)string2, (Object)string3);
            }
            return n4;
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("XCY00.S", (Object)string2, (Object)string3);
        }
    }

    public static boolean isServiceProperty(String string2) {
        for (int i = 0; i < servicePropertyList.length; ++i) {
            if (!string2.equals(servicePropertyList[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean existsBuiltinUser(PersistentSet persistentSet, String string2) throws StandardException {
        if (PropertyUtil.propertiesContainsBuiltinUser(persistentSet.getProperties(), string2)) {
            return true;
        }
        boolean bl = false;
        bl = Boolean.valueOf(PropertyUtil.getDatabaseProperty(persistentSet, "derby.database.propertiesOnly"));
        return !bl && PropertyUtil.systemPropertiesExistsBuiltinUser(string2);
    }

    public static boolean nativeAuthenticationEnabled(Properties properties) {
        String string2 = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return PropertyUtil.nativeAuthenticationEnabled(string2);
    }

    private static boolean nativeAuthenticationEnabled(String string2) {
        if (string2 == null) {
            return false;
        }
        return StringUtil.SQLToUpperCase(string2).startsWith("NATIVE:");
    }

    public static boolean localNativeAuthenticationEnabled(Properties properties) {
        if (!PropertyUtil.nativeAuthenticationEnabled(properties)) {
            return false;
        }
        String string2 = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return StringUtil.SQLToUpperCase(string2).endsWith(":LOCAL");
    }

    private static boolean systemPropertiesExistsBuiltinUser(String string2) {
        Properties properties;
        ModuleFactory moduleFactory;
        block3: {
            moduleFactory = Monitor.getMonitorLite();
            try {
                properties = System.getProperties();
                if (PropertyUtil.propertiesContainsBuiltinUser(properties, string2)) {
                    return true;
                }
            }
            catch (SecurityException securityException) {
                String string3 = "derby.user." + IdUtil.SQLIdentifier2CanonicalPropertyUsername(string2);
                if (moduleFactory.getJVMProperty(string3) == null) break block3;
                return true;
            }
        }
        properties = moduleFactory.getApplicationProperties();
        return PropertyUtil.propertiesContainsBuiltinUser(properties, string2);
    }

    private static boolean propertiesContainsBuiltinUser(Properties properties, String string2) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3;
                String string4 = (String)enumeration.nextElement();
                if (!string4.startsWith("derby.user.") || !string2.equals(string3 = StringUtil.normalizeSQLIdentifier(string4.substring("derby.user.".length())))) continue;
                return true;
            }
        }
        return false;
    }
}

