/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.util.ReuseFactory;

public final class ArrayInputStream
extends InputStream
implements LimitObjectInput {
    private byte[] pageData;
    private int start;
    private int end;
    private int position;
    private ErrorObjectInput oi;

    public ArrayInputStream() {
        this(ReuseFactory.getZeroLenByteArray());
    }

    public ArrayInputStream(byte[] byArray) {
        this.setData(byArray);
        this.oi = new FormatIdInputStream(this);
    }

    public void setData(byte[] byArray) {
        this.pageData = byArray;
        this.position = 0;
        this.start = 0;
        this.end = byArray.length;
    }

    public byte[] getData() {
        return this.pageData;
    }

    public int read() throws IOException {
        if (this.position == this.end) {
            return -1;
        }
        return this.pageData[this.position++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.available();
        if (n2 > n3) {
            if (n3 == 0) {
                return -1;
            }
            n2 = n3;
        }
        System.arraycopy(this.pageData, this.position, byArray, n, n2);
        this.position += n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        long l2 = Math.min(l, (long)this.available());
        this.position = (int)((long)this.position + l2);
        return l2;
    }

    public int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) throws IOException {
        if (n < this.start || n >= this.end) {
            throw new EOFException();
        }
        this.position = n;
    }

    public int available() throws IOException {
        return this.end - this.position;
    }

    public void setLimit(int n, int n2) throws IOException {
        this.start = n;
        this.end = n + n2;
        this.position = this.start;
        if (n < 0 || n2 < 0 || this.end > this.pageData.length) {
            this.position = 0;
            this.end = 0;
            this.start = 0;
            throw new EOFException();
        }
    }

    public final void setLimit(int n) throws IOException {
        this.start = this.position;
        this.end = this.position + n;
        if (this.end > this.pageData.length) {
            this.position = 0;
            this.end = 0;
            this.start = 0;
            throw new EOFException();
        }
    }

    public final int clearLimit() {
        this.start = 0;
        int n = this.end - this.position;
        this.end = this.pageData.length;
        return n;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > this.available()) {
            throw new EOFException();
        }
        System.arraycopy(this.pageData, this.position, byArray, n, n2);
        this.position += n2;
    }

    public final int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public final boolean readBoolean() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++] != 0;
    }

    public final byte readByte() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++];
    }

    public final int readUnsignedByte() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++] & 0xFF;
    }

    public final short readShort() throws IOException {
        int n = this.position;
        byte[] byArray = this.pageData;
        if (n >= this.end - 1) {
            throw new EOFException();
        }
        int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        this.position = n;
        return (short)n2;
    }

    public final int readUnsignedShort() throws IOException {
        int n = this.position;
        byte[] byArray = this.pageData;
        if (n >= this.end - 1) {
            throw new EOFException();
        }
        int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        this.position = n;
        return n2;
    }

    public final char readChar() throws IOException {
        int n = this.position;
        byte[] byArray = this.pageData;
        if (n >= this.end - 1) {
            throw new EOFException();
        }
        int n2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        this.position = n;
        return (char)n2;
    }

    public final int readInt() throws IOException {
        int n = this.position;
        byte[] byArray = this.pageData;
        if (n >= this.end - 3) {
            throw new EOFException();
        }
        int n2 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        this.position = n;
        return n2;
    }

    public final long readLong() throws IOException {
        int n = this.position;
        byte[] byArray = this.pageData;
        if (n >= this.end - 7) {
            throw new EOFException();
        }
        long l = (long)(byArray[n++] & 0xFF) << 56 | (long)(byArray[n++] & 0xFF) << 48 | (long)(byArray[n++] & 0xFF) << 40 | (long)(byArray[n++] & 0xFF) << 32 | (long)(byArray[n++] & 0xFF) << 24 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF);
        this.position = n;
        return l;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        return this.oi.readLine();
    }

    public final String readUTF() throws IOException {
        return this.oi.readUTF();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int readDerbyUTF(char[][] cArray, int n) throws IOException {
        int n2;
        byte[] byArray = this.pageData;
        int n3 = this.end;
        int n4 = this.position;
        if (n != 0) {
            if (n > n3 - n4) throw new EOFException();
            n2 = n;
        } else {
            n2 = n3 - n4;
        }
        char[] cArray2 = cArray[0];
        if (cArray2 == null || n2 > cArray2.length) {
            cArray2 = new char[n2];
            cArray[0] = cArray2;
        }
        n3 = n4 + n2;
        int n5 = 0;
        while (n4 < n3) {
            int n6;
            int n7;
            if (((n7 = byArray[n4++] & 0xFF) & 0x80) == 0) {
                cArray2[n5++] = (char)n7;
                continue;
            }
            if ((n7 & 0x60) == 64) {
                if (n4 >= n3) {
                    throw new UTFDataFormatException();
                }
                if (((n6 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray2[n5++] = (char)((n7 & 0x1F) << 6 | n6 & 0x3F);
                continue;
            }
            if ((n7 & 0x70) != 96) throw new UTFDataFormatException();
            if (n4 + 1 >= n3) {
                throw new UTFDataFormatException();
            }
            n6 = byArray[n4++] & 0xFF;
            int n8 = byArray[n4++] & 0xFF;
            if (n7 == 224 && n6 == 0 && n8 == 0 && n == 0) break;
            if ((n6 & 0xC0) != 128 || (n8 & 0xC0) != 128) {
                throw new UTFDataFormatException();
            }
            cArray2[n5++] = (char)((n7 & 0xF) << 12 | (n6 & 0x3F) << 6 | (n8 & 0x3F) << 0);
        }
        this.position = n4;
        return n5;
    }

    public final int readCompressedInt() throws IOException {
        int n = this.position;
        byte[] byArray = this.pageData;
        try {
            int n2 = byArray[n++];
            if ((n2 & 0xFFFFFFC0) != 0) {
                n2 = (n2 & 0x80) == 0 ? (n2 & 0x3F) << 8 | byArray[n++] & 0xFF : (n2 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
            }
            this.position = n;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException();
        }
    }

    public final long readCompressedLong() throws IOException {
        try {
            int n = this.position;
            byte[] byArray = this.pageData;
            byte by2 = byArray[n++];
            long l = (by2 & 0xFFFFFFC0) == 0 ? (long)(by2 << 8 | byArray[n++] & 0xFF) : ((by2 & 0x80) == 0 ? (long)((by2 & 0x3F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) : (long)(by2 & 0x7F) << 56 | (long)(byArray[n++] & 0xFF) << 48 | (long)(byArray[n++] & 0xFF) << 40 | (long)(byArray[n++] & 0xFF) << 32 | (long)(byArray[n++] & 0xFF) << 24 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n++] & 0xFF));
            this.position = n;
            return l;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException();
        }
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.oi.readObject();
    }

    public String getErrorInfo() {
        return this.oi.getErrorInfo();
    }

    public Exception getNestedException() {
        return this.oi.getNestedException();
    }
}

