/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.AttributeEntry;
import org.apache.derby.iapi.services.classfile.Attributes;
import org.apache.derby.iapi.services.classfile.CONSTANT_Double_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Float_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Integer_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Long_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Utf8_info;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.ConstantPoolEntry;
import org.apache.derby.iapi.services.classfile.MemberTable;
import org.apache.derby.iapi.util.ByteArray;

public class ClassHolder {
    protected int minor_version = 3;
    protected int major_version = 45;
    protected int access_flags;
    protected int this_class;
    protected int super_class;
    protected int[] interfaces;
    protected MemberTable field_info;
    protected MemberTable method_info;
    protected Attributes attribute_info;
    protected Hashtable cptHashTable;
    protected Vector cptEntries;
    private int cptEstimatedSize;
    private final CONSTANT_Index_info searchIndex = new CONSTANT_Index_info(0, 0, 0);

    protected ClassHolder(int n) {
        this.cptEntries = new Vector(n);
        this.cptHashTable = new Hashtable(n, 0.75f);
        this.cptEntries.setSize(1);
    }

    public ClassHolder(String string2, String string3, int n) {
        this(100);
        this.access_flags = n | 0x20;
        this.this_class = this.addClassReference(string2);
        this.super_class = this.addClassReference(string3);
        this.method_info = new MemberTable(0);
    }

    private void put(ClassFormatOutput classFormatOutput) throws IOException {
        classFormatOutput.putU4(-889275714);
        classFormatOutput.putU2(this.minor_version);
        classFormatOutput.putU2(this.major_version);
        classFormatOutput.putU2("constant_pool", this.cptEntries.size());
        this.cptPut(classFormatOutput);
        classFormatOutput.putU2(this.access_flags);
        classFormatOutput.putU2(this.this_class);
        classFormatOutput.putU2(this.super_class);
        if (this.interfaces != null) {
            int n = this.interfaces.length;
            classFormatOutput.putU2(n);
            for (int i = 0; i < n; ++i) {
                classFormatOutput.putU2(this.interfaces[i]);
            }
        } else {
            classFormatOutput.putU2(0);
        }
        if (this.field_info != null) {
            classFormatOutput.putU2(this.field_info.size());
            this.field_info.put(classFormatOutput);
        } else {
            classFormatOutput.putU2(0);
        }
        if (this.method_info != null) {
            classFormatOutput.putU2(this.method_info.size());
            this.method_info.put(classFormatOutput);
        } else {
            classFormatOutput.putU2(0);
        }
        if (this.attribute_info != null) {
            classFormatOutput.putU2(this.attribute_info.size());
            this.attribute_info.put(classFormatOutput);
        } else {
            classFormatOutput.putU2(0);
        }
    }

    public ByteArray getFileFormat() throws IOException {
        int n = 24;
        n += this.cptEstimatedSize;
        if (this.interfaces != null) {
            n += this.interfaces.length * 2;
        }
        if (this.field_info != null) {
            n += this.field_info.classFileSize();
        }
        if (this.method_info != null) {
            n += this.method_info.classFileSize();
        }
        if (this.attribute_info != null) {
            n += this.attribute_info.classFileSize();
        }
        ClassFormatOutput classFormatOutput = new ClassFormatOutput(n + 200);
        this.put(classFormatOutput);
        return new ByteArray(classFormatOutput.getData(), 0, classFormatOutput.size());
    }

    public int getModifier() {
        return this.access_flags;
    }

    public String getName() {
        return this.className(this.this_class).replace('/', '.');
    }

    public ClassMember addMember(String string2, String string3, int n) {
        MemberTable memberTable;
        CONSTANT_Utf8_info cONSTANT_Utf8_info = this.addUtf8Entry(string2);
        int n2 = cONSTANT_Utf8_info.getIndex();
        int n3 = this.addUtf8Entry(string3).getIndex();
        ClassMember classMember = new ClassMember(this, n, n2, n3);
        if (string3.startsWith("(")) {
            memberTable = this.method_info;
            if (memberTable == null) {
                memberTable = this.method_info = new MemberTable(0);
            }
        } else {
            memberTable = this.field_info;
            if (memberTable == null) {
                memberTable = this.field_info = new MemberTable(0);
            }
        }
        memberTable.addEntry(classMember);
        return classMember;
    }

    public int addFieldReference(String string2, String string3, String string4) {
        return this.addReference(9, string2, string3, string4);
    }

    public int addFieldReference(ClassMember classMember) {
        return this.addReference(9, classMember);
    }

    public int addMethodReference(String string2, String string3, String string4, boolean bl) {
        int n = bl ? 11 : 10;
        return this.addReference(n, string2, string3, string4);
    }

    private int addReference(int n, String string2, String string3, String string4) {
        int n2 = this.addClassReference(string2);
        int n3 = this.addNameAndType(string3, string4);
        return this.addIndexReference(n, n2, n3);
    }

    private int addReference(int n, ClassMember classMember) {
        int n2 = this.addIndexReference(12, classMember.name_index, classMember.descriptor_index);
        return this.addIndexReference(n, this.this_class, n2);
    }

    public int addConstant(String string2) {
        return this.addString(string2);
    }

    public int addUtf8(String string2) {
        return this.addUtf8Entry(string2).getIndex();
    }

    public int addConstant(int n) {
        return this.addDirectEntry(new CONSTANT_Integer_info(n));
    }

    public int addConstant(float f2) {
        return this.addDirectEntry(new CONSTANT_Float_info(f2));
    }

    public int addConstant(long l) {
        return this.addDirectEntry(new CONSTANT_Long_info(l));
    }

    public int addConstant(double d) {
        return this.addDirectEntry(new CONSTANT_Double_info(d));
    }

    public int getConstantPoolIndex() {
        return this.this_class;
    }

    public void addAttribute(String string2, ClassFormatOutput classFormatOutput) {
        if (this.attribute_info == null) {
            this.attribute_info = new Attributes(1);
        }
        CONSTANT_Utf8_info cONSTANT_Utf8_info = this.addUtf8Entry(string2);
        int n = cONSTANT_Utf8_info.getIndex();
        this.attribute_info.addEntry(new AttributeEntry(n, classFormatOutput));
    }

    public String getSuperClassName() {
        if (this.super_class == 0) {
            return null;
        }
        return this.className(this.super_class).replace('/', '.');
    }

    protected int addEntry(Object object, ConstantPoolEntry constantPoolEntry) {
        constantPoolEntry.setIndex(this.cptEntries.size());
        if (object != null) {
            this.cptHashTable.put(object, constantPoolEntry);
        }
        this.cptEntries.add(constantPoolEntry);
        this.cptEstimatedSize += constantPoolEntry.classFileSize();
        if (constantPoolEntry.doubleSlot()) {
            this.cptEntries.add(null);
            return 2;
        }
        return 1;
    }

    private int addDirectEntry(ConstantPoolEntry constantPoolEntry) {
        ConstantPoolEntry constantPoolEntry2 = this.findMatchingEntry(constantPoolEntry);
        if (constantPoolEntry2 != null) {
            constantPoolEntry = constantPoolEntry2;
        } else {
            this.addEntry(constantPoolEntry.getKey(), constantPoolEntry);
        }
        return constantPoolEntry.getIndex();
    }

    private int addIndexReference(int n, int n2, int n3) {
        this.searchIndex.set(n, n2, n3);
        ConstantPoolEntry constantPoolEntry = this.findMatchingEntry(this.searchIndex);
        if (constantPoolEntry == null) {
            constantPoolEntry = new CONSTANT_Index_info(n, n2, n3);
            this.addEntry(constantPoolEntry.getKey(), constantPoolEntry);
        }
        return constantPoolEntry.getIndex();
    }

    public int addClassReference(String string2) {
        if (ClassHolder.isExternalClassName(string2)) {
            string2 = ClassHolder.convertToInternalClassName(string2);
        }
        int n = this.addUtf8Entry(string2).getIndex();
        return this.addIndexReference(7, n, 0);
    }

    private int addNameAndType(String string2, String string3) {
        int n = this.addUtf8Entry(string2).getIndex();
        int n2 = this.addUtf8Entry(string3).getIndex();
        return this.addIndexReference(12, n, n2);
    }

    private CONSTANT_Utf8_info addUtf8Entry(String string2) {
        CONSTANT_Utf8_info cONSTANT_Utf8_info = (CONSTANT_Utf8_info)this.findMatchingEntry(string2);
        if (cONSTANT_Utf8_info == null) {
            cONSTANT_Utf8_info = new CONSTANT_Utf8_info(string2);
            this.addEntry(string2, cONSTANT_Utf8_info);
        }
        return cONSTANT_Utf8_info;
    }

    private CONSTANT_Utf8_info addExtraUtf8(String string2) {
        CONSTANT_Utf8_info cONSTANT_Utf8_info = new CONSTANT_Utf8_info(string2);
        this.addEntry(null, cONSTANT_Utf8_info);
        return cONSTANT_Utf8_info;
    }

    private int addString(String string2) {
        CONSTANT_Utf8_info cONSTANT_Utf8_info = this.addUtf8Entry(string2);
        int n = cONSTANT_Utf8_info.setAsString();
        if (n == 0) {
            n = this.addExtraUtf8(string2).getIndex();
            cONSTANT_Utf8_info.setAlternative(n);
        }
        return this.addIndexReference(8, n, 0);
    }

    protected void cptPut(ClassFormatOutput classFormatOutput) throws IOException {
        Enumeration enumeration = this.cptEntries.elements();
        while (enumeration.hasMoreElements()) {
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)enumeration.nextElement();
            if (constantPoolEntry == null) continue;
            constantPoolEntry.put(classFormatOutput);
        }
    }

    public ConstantPoolEntry getEntry(int n) {
        return (ConstantPoolEntry)this.cptEntries.get(n);
    }

    protected String className(int n) {
        CONSTANT_Index_info cONSTANT_Index_info = (CONSTANT_Index_info)this.getEntry(n);
        return this.nameIndexToString(cONSTANT_Index_info.getI1()).replace('/', '.');
    }

    int findUtf8(String string2) {
        ConstantPoolEntry constantPoolEntry = this.findMatchingEntry(string2);
        if (constantPoolEntry == null) {
            return -1;
        }
        return constantPoolEntry.getIndex();
    }

    public int findClass(String string2) {
        String string3 = ClassHolder.convertToInternalClassName(string2);
        int n = this.findUtf8(string3);
        if (n < 0) {
            return -1;
        }
        return this.findIndexIndex(7, n, 0);
    }

    public int findNameAndType(String string2, String string3) {
        int n = this.findUtf8(string2);
        if (n < 0) {
            return -1;
        }
        int n2 = this.findUtf8(string3);
        if (n2 < 0) {
            return -1;
        }
        return this.findIndexIndex(12, n, n2);
    }

    protected CONSTANT_Index_info findIndexEntry(int n, int n2, int n3) {
        this.searchIndex.set(n, n2, n3);
        return (CONSTANT_Index_info)this.findMatchingEntry(this.searchIndex);
    }

    protected int findIndexIndex(int n, int n2, int n3) {
        CONSTANT_Index_info cONSTANT_Index_info = this.findIndexEntry(n, n2, n3);
        if (cONSTANT_Index_info == null) {
            return -1;
        }
        return cONSTANT_Index_info.getIndex();
    }

    protected ConstantPoolEntry findMatchingEntry(Object object) {
        return (ConstantPoolEntry)this.cptHashTable.get(object);
    }

    String nameIndexToString(int n) {
        return this.getEntry(n).toString();
    }

    protected String getClassName(int n) {
        if (n == 0) {
            return "";
        }
        return this.nameIndexToString(this.getEntry(n).getI1());
    }

    public static boolean isExternalClassName(String string2) {
        if (string2.indexOf(46) != -1) {
            return true;
        }
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        return string2.charAt(n - 1) == ']';
    }

    public static String convertToInternalClassName(String string2) {
        return ClassHolder.convertToInternal(string2, false);
    }

    public static String convertToInternalDescriptor(String string2) {
        return ClassHolder.convertToInternal(string2, true);
    }

    private static String convertToInternal(String string2, boolean bl) {
        int n = string2.length();
        String string3 = null;
        int n2 = n;
        int n3 = 0;
        if (string2.charAt(n - 1) == ']') {
            while (n > 0 && string2.charAt(n - 1) == ']' && string2.charAt(n - 2) == '[') {
                n -= 2;
                ++n3;
            }
        }
        String string4 = n2 == n ? string2 : string2.substring(0, n);
        switch (n) {
            case 7: {
                if (!"boolean".equals(string4)) break;
                string3 = ClassHolder.makeDesc('Z', n3);
                break;
            }
            case 4: {
                if ("void".equals(string4)) {
                    string3 = ClassHolder.makeDesc('V', n3);
                    break;
                }
                if ("long".equals(string4)) {
                    string3 = ClassHolder.makeDesc('J', n3);
                    break;
                }
                if ("byte".equals(string4)) {
                    string3 = ClassHolder.makeDesc('B', n3);
                    break;
                }
                if (!"char".equals(string4)) break;
                string3 = ClassHolder.makeDesc('C', n3);
                break;
            }
            case 3: {
                if (!"int".equals(string4)) break;
                string3 = ClassHolder.makeDesc('I', n3);
                break;
            }
            case 6: {
                if (!"double".equals(string4)) break;
                string3 = ClassHolder.makeDesc('D', n3);
                break;
            }
            case 5: {
                if ("short".equals(string4)) {
                    string3 = ClassHolder.makeDesc('S', n3);
                    break;
                }
                if (!"float".equals(string4)) break;
                string3 = ClassHolder.makeDesc('F', n3);
            }
        }
        if (string3 == null) {
            string3 = ClassHolder.makeDesc(string4, n3, bl);
        }
        return string3;
    }

    private static String makeDesc(char c, int n) {
        if (n == 0) {
            switch (c) {
                case 'B': {
                    return "B";
                }
                case 'C': {
                    return "C";
                }
                case 'D': {
                    return "D";
                }
                case 'F': {
                    return "F";
                }
                case 'I': {
                    return "I";
                }
                case 'J': {
                    return "J";
                }
                case 'S': {
                    return "S";
                }
                case 'Z': {
                    return "Z";
                }
                case 'V': {
                    return "V";
                }
            }
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(n + 3);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[');
        }
        stringBuffer.append(ClassHolder.makeDesc(c, 0));
        return stringBuffer.toString();
    }

    private static String makeDesc(String string2, int n, boolean bl) {
        if (!bl && n == 0) {
            return string2.replace('.', '/');
        }
        StringBuffer stringBuffer = new StringBuffer(n + 2 + string2.length());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[');
        }
        stringBuffer.append('L');
        stringBuffer.append(string2.replace('.', '/'));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }
}

