/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;

public class ClassSize {
    public static final int refSize;
    private static final int objectOverhead = 2;
    private static final int booleanSize = 4;
    private static final int charSize = 4;
    private static final int shortSize = 4;
    private static final int intSize = 4;
    private static final int longSize = 8;
    private static final int floatSize = 4;
    private static final int doubleSize = 8;
    private static final int minObjectSize;
    private static boolean dummyCatalog;
    static boolean noGuess;
    static boolean unitTest;
    private static final int[] wildGuess;
    private static Hashtable catalog;

    public static void setDummyCatalog() {
        dummyCatalog = true;
    }

    public static int getRefSize() {
        return refSize;
    }

    public static int getIntSize() {
        return 4;
    }

    public static int[] getSizeCoefficients(Class clazz) {
        int[] nArray = new int[]{0, 2};
        while (null != clazz) {
            Field[] fieldArray = clazz.getDeclaredFields();
            if (null != fieldArray) {
                for (int i = 0; i < fieldArray.length; ++i) {
                    if (Modifier.isStatic(fieldArray[i].getModifiers())) continue;
                    Class<?> clazz2 = fieldArray[i].getType();
                    if (clazz2.isArray() || !clazz2.isPrimitive()) {
                        nArray[1] = nArray[1] + 1;
                        continue;
                    }
                    String string2 = clazz2.getName();
                    if (string2.equals("int") || string2.equals("I")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string2.equals("long") || string2.equals("J")) {
                        nArray[0] = nArray[0] + 8;
                        continue;
                    }
                    if (string2.equals("boolean") || string2.equals("Z")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string2.equals("short") || string2.equals("S")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string2.equals("byte") || string2.equals("B")) {
                        nArray[0] = nArray[0] + 1;
                        continue;
                    }
                    if (string2.equals("char") || string2.equals("C")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string2.equals("float") || string2.equals("F")) {
                        nArray[0] = nArray[0] + 4;
                        continue;
                    }
                    if (string2.equals("double") || string2.equals("D")) {
                        nArray[0] = nArray[0] + 8;
                        continue;
                    }
                    nArray[1] = nArray[1] + 1;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return nArray;
    }

    public static int estimateBaseFromCoefficients(int[] nArray) {
        int n = nArray[0] + nArray[1] * refSize;
        n = (n + 7) / 8;
        return (n *= 8) < minObjectSize ? minObjectSize : n;
    }

    public static int estimateBaseFromCatalog(Class clazz) {
        return ClassSize.estimateBaseFromCatalog(clazz, false);
    }

    private static int estimateBaseFromCatalog(Class clazz, boolean bl) {
        if (dummyCatalog) {
            return 0;
        }
        int[] nArray = (int[])catalog.get(clazz.getName());
        if (nArray == null) {
            try {
                nArray = ClassSize.getSizeCoefficients(clazz);
            }
            catch (Throwable throwable) {
                if (noGuess) {
                    return -2;
                }
                nArray = wildGuess;
            }
            if (bl) {
                catalog.put(clazz.getName(), nArray);
            }
        }
        return ClassSize.estimateBaseFromCoefficients(nArray);
    }

    public static int estimateAndCatalogBase(Class clazz) {
        return ClassSize.estimateBaseFromCatalog(clazz, true);
    }

    public static int estimateBase(Class clazz) {
        return ClassSize.estimateBaseFromCoefficients(ClassSize.getSizeCoefficients(clazz));
    }

    public static int estimateArrayOverhead() {
        return minObjectSize;
    }

    public static int estimateHashEntrySize() {
        return 2 + 3 * refSize;
    }

    public static int estimateMemoryUsage(String string2) {
        if (null == string2) {
            return 0;
        }
        return 2 * string2.length();
    }

    private static final int fetchRefSizeFromSystemProperties() {
        String string2 = ClassSize.getSystemProperty("sun.arch.data.model");
        try {
            return new Integer(string2) / 8;
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = ClassSize.getSystemProperty("os.arch");
            if (string3 != null) {
                String[] stringArray = new String[]{"i386", "x86", "sparc"};
                if (Arrays.asList(stringArray).contains(string3)) {
                    return 4;
                }
                String[] stringArray2 = new String[]{"amd64", "x86_64", "sparcv9"};
                if (Arrays.asList(stringArray2).contains(string3)) {
                    return 8;
                }
            }
            return -1;
        }
    }

    private static final String getSystemProperty(final String string2) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string2, null);
                }
            });
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static {
        dummyCatalog = false;
        noGuess = false;
        unitTest = false;
        wildGuess = new int[]{0, 16};
        try {
            catalog = (Hashtable)Class.forName("org.apache.derby.iapi.services.cache.ClassSizeCatalog").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = ClassSize.fetchRefSizeFromSystemProperties();
        if (n < 4) {
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            runtime.runFinalization();
            long l = runtime.totalMemory() - runtime.freeMemory();
            Object[] objectArray = new Object[10000];
            runtime.gc();
            runtime.runFinalization();
            long l2 = runtime.totalMemory() - runtime.freeMemory() - l;
            int n2 = (int)((l2 + (long)(objectArray.length / 2)) / (long)objectArray.length);
            n = 4 > n2 ? 4 : n2;
        }
        refSize = n;
        minObjectSize = 4 * refSize;
    }
}

