/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.error;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.iapi.error.DerbySQLException;
import org.apache.derby.iapi.services.i18n.MessageService;

public class StandardException
extends Exception {
    public static final int REPORT_DEFAULT = 0;
    public static final int REPORT_NEVER = 1;
    public static final int REPORT_ALWAYS = 2;
    private transient Object[] arguments;
    private int severity;
    private String textMessage;
    private String sqlState;
    private transient int report;

    protected StandardException(String string2) {
        this(string2, null, null);
    }

    protected StandardException(String string2, Object[] objectArray) {
        this(string2, null, objectArray);
    }

    protected StandardException(String string2, Throwable throwable, Object[] objectArray) {
        super(string2);
        this.severity = StandardException.getSeverityFromIdentifier(string2);
        this.sqlState = StandardException.getSQLStateFromIdentifier(string2);
        this.arguments = objectArray;
        if (throwable != null) {
            this.initCause(throwable);
        }
    }

    private StandardException(String string2, String string3) {
        this(string2);
        this.textMessage = string3;
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public final int report() {
        return this.report;
    }

    public final void setReport(int n) {
        this.report = n;
    }

    public final void setSeverity(int n) {
        this.severity = n;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final int getErrorCode() {
        return this.severity;
    }

    public final String getSQLState() {
        return this.sqlState;
    }

    public static String getSQLStateFromIdentifier(String string2) {
        if (string2.length() == 5) {
            return string2;
        }
        return string2.substring(0, 5);
    }

    public static int getSeverityFromIdentifier(String string2) {
        int n = 0;
        block0 : switch (string2.length()) {
            case 5: {
                block3 : switch (string2.charAt(0)) {
                    case '0': {
                        switch (string2.charAt(1)) {
                            case '1': {
                                n = 10000;
                                break;
                            }
                            case '7': 
                            case 'A': {
                                n = 20000;
                                break;
                            }
                            case '8': {
                                n = 40000;
                            }
                        }
                        break;
                    }
                    case '2': 
                    case '3': {
                        n = 20000;
                        break;
                    }
                    case '4': {
                        switch (string2.charAt(1)) {
                            case '0': {
                                n = 30000;
                                break block3;
                            }
                            case '2': {
                                n = 20000;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                switch (string2.charAt(6)) {
                    case 'M': {
                        n = 50000;
                        break block0;
                    }
                    case 'D': {
                        n = 45000;
                        break block0;
                    }
                    case 'C': {
                        n = 40000;
                        break block0;
                    }
                    case 'T': {
                        n = 30000;
                        break block0;
                    }
                    case 'S': {
                        n = 20000;
                        break block0;
                    }
                    case 'U': {
                        n = 0;
                    }
                }
            }
        }
        return n;
    }

    public static StandardException normalClose() {
        StandardException standardException = StandardException.newException("XXXXX.C.6");
        standardException.report = 1;
        return standardException;
    }

    public static StandardException newException(String string2) {
        return new StandardException(string2);
    }

    public static StandardException newException(String string2, Throwable throwable) {
        return new StandardException(string2, throwable, null);
    }

    public static StandardException newException(String string2, Object object) {
        Object[] objectArray = new Object[]{object};
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Object[] objectArray) {
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Throwable throwable, Object object) {
        Object[] objectArray = new Object[]{object};
        return new StandardException(string2, throwable, objectArray);
    }

    public static StandardException newException(String string2, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Object object, Throwable throwable) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newException(String string2, Throwable throwable, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return new StandardException(string2, throwable, objectArray);
    }

    public static StandardException newException(String string2, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Object object, Object object2, Throwable throwable) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newException(String string2, Throwable throwable, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return new StandardException(string2, throwable, objectArray);
    }

    public static StandardException newException(String string2, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Throwable throwable, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return new StandardException(string2, throwable, objectArray);
    }

    public static StandardException newException(String string2, Object object, Object object2, Object object3, Object object4, Object object5) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5};
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Throwable throwable, Object object, Object object2, Object object3, Object object4, Object object5) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5};
        return new StandardException(string2, throwable, objectArray);
    }

    public static StandardException newException(String string2, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Throwable throwable, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
        return new StandardException(string2, throwable, objectArray);
    }

    public static StandardException newException(String string2, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7};
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Throwable throwable, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7};
        return new StandardException(string2, throwable, objectArray);
    }

    public static StandardException newException(String string2, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
        return new StandardException(string2, objectArray);
    }

    public static StandardException newException(String string2, Throwable throwable, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
        return new StandardException(string2, throwable, objectArray);
    }

    public static StandardException newPreLocalizedException(String string2, Throwable throwable, String string3) {
        StandardException standardException = new StandardException(string2, string3);
        if (throwable != null) {
            standardException.initCause(throwable);
        }
        return standardException;
    }

    public static SQLException getArgumentFerry(SQLException sQLException) {
        if (sQLException instanceof DerbySQLException) {
            return sQLException;
        }
        Throwable throwable = sQLException.getCause();
        if (throwable == null || !(throwable instanceof DerbySQLException)) {
            return sQLException;
        }
        return (SQLException)throwable;
    }

    public static StandardException unexpectedUserException(Throwable throwable) {
        String string2;
        Object object;
        DerbySQLException derbySQLException = null;
        if (throwable instanceof SQLException && (object = StandardException.getArgumentFerry((SQLException)throwable)) instanceof DerbySQLException) {
            derbySQLException = (DerbySQLException)object;
        }
        if (throwable instanceof SQLException && derbySQLException == null && (string2 = ((SQLException)(object = (SQLException)throwable)).getSQLState()) != null && string2.length() == 5 && string2.startsWith("38") && !string2.equals("38000")) {
            StandardException standardException = new StandardException(string2, ((Throwable)object).getMessage());
            if (((SQLException)object).getNextException() != null) {
                standardException.initCause(((SQLException)object).getNextException());
            }
            return standardException;
        }
        if (derbySQLException != null && derbySQLException.isSimpleWrapper() && (object = ((SQLException)((Object)derbySQLException)).getCause()) instanceof StandardException) {
            return (StandardException)object;
        }
        if (throwable instanceof StandardException) {
            return (StandardException)throwable;
        }
        boolean bl = false;
        if (derbySQLException != null) {
            object = derbySQLException.toString();
            bl = true;
        } else {
            object = throwable.getMessage();
        }
        object = object == null ? "" : ((String)object).trim();
        if (((String)object).length() == 0) {
            object = throwable.getClass().getName();
        } else if (!bl) {
            object = throwable.getClass().getName() + ": " + (String)object;
        }
        StandardException standardException = StandardException.newException("38000", throwable, object);
        return standardException;
    }

    public static StandardException plainWrapException(Throwable throwable) {
        Object object;
        Object object2;
        if (throwable instanceof StandardException) {
            return (StandardException)throwable;
        }
        if (throwable instanceof SQLException && (object2 = ((SQLException)(object = (SQLException)throwable)).getSQLState()) != null) {
            StandardException standardException = new StandardException((String)object2, "(" + ((SQLException)object).getErrorCode() + ") " + ((Throwable)object).getMessage());
            if ((object = ((SQLException)object).getNextException()) != null) {
                standardException.initCause(StandardException.plainWrapException((Throwable)object));
            }
            return standardException;
        }
        object = throwable.getMessage();
        object = object == null ? "" : ((String)object).trim();
        object2 = StandardException.newException("XJ001.U", throwable, object, (Object)throwable.getClass().getName());
        return object2;
    }

    public static StandardException closeException() {
        StandardException standardException = StandardException.newException("close.C.1");
        standardException.setReport(1);
        return standardException;
    }

    public String getMessage() {
        if (this.textMessage == null) {
            this.textMessage = MessageService.getCompleteMessage(this.getMessageId(), this.getArguments());
        }
        return this.textMessage;
    }

    public final String getMessageId() {
        return super.getMessage();
    }

    public String getErrorProperty(String string2) {
        return StandardException.getErrorProperty(this.getMessageId(), string2);
    }

    public String toString() {
        String string2 = this.getMessage();
        return "ERROR " + this.getSQLState() + ": " + string2;
    }

    private static String getErrorProperty(String string2, String string3) {
        return MessageService.getProperty(string2, string3);
    }

    public static StandardException interrupt(InterruptedException interruptedException) {
        StandardException standardException = StandardException.newException("08000", interruptedException);
        return standardException;
    }

    public static SQLWarning newWarning(String string2) {
        return StandardException.newWarningCommon(string2, null);
    }

    public static SQLWarning newWarning(String string2, Object object) {
        Object[] objectArray = new Object[]{object};
        return StandardException.newWarningCommon(string2, objectArray);
    }

    public static SQLWarning newWarning(String string2, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return StandardException.newWarningCommon(string2, objectArray);
    }

    private static SQLWarning newWarningCommon(String string2, Object[] objectArray) {
        String string3 = MessageService.getCompleteMessage(string2, objectArray);
        String string4 = StandardException.getSQLStateFromIdentifier(string2);
        SQLWarning sQLWarning = new SQLWarning(string3, string4, 10000);
        return sQLWarning;
    }

    public final boolean isLockTimeout() {
        return "40XL1".equals(this.getSQLState());
    }

    public final boolean isLockTimeoutOrDeadlock() {
        return "40XL1".equals(this.getSQLState()) || "40001".equals(this.getSQLState());
    }

    public static class BadMessageArgumentException
    extends Throwable {
    }
}

