/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.io.Serializable;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.derby.iapi.db.ConsistencyChecker;
import org.apache.derby.iapi.db.Factory;
import org.apache.derby.iapi.db.PropertyInfo;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedDatabaseMetaData;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.load.Export;
import org.apache.derby.impl.load.Import;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINSortPropsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINStatementTimingsDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINTableDescriptor;
import org.apache.derby.impl.sql.execute.JarUtil;
import org.apache.derby.jdbc.InternalDriver;

public class SystemProcedures {
    private static final int SQL_BEST_ROWID = 1;
    private static final int SQL_ROWVER = 2;
    private static final String DRIVER_TYPE_OPTION = "DATATYPE";
    private static final String ODBC_DRIVER_OPTION = "'ODBC'";
    public static final String SQLERRMC_MESSAGE_DELIMITER = new String(new char[]{'\u0014', '\u0014', '\u0014'});
    private static final double LOG10 = StrictMath.log(10.0);

    public static void SQLCAMESSAGE(int n, short s, String string2, String string3, int n2, int n3, int n4, int n5, int n6, int n7, String string4, String string5, String string6, String string7, String[] stringArray, int[] nArray) {
        int n8 = 1;
        int n9 = 0;
        while (string2.indexOf(SQLERRMC_MESSAGE_DELIMITER, n9) != -1) {
            n9 = string2.indexOf(SQLERRMC_MESSAGE_DELIMITER, n9) + SQLERRMC_MESSAGE_DELIMITER.length();
            ++n8;
        }
        if (n8 == 1) {
            MessageService.getLocalizedMessage(n, s, string2, string3, n2, n3, n4, n5, n6, n7, string4, string5, string6, string7, stringArray, nArray);
        } else {
            n9 = 0;
            String[] stringArray2 = new String[2];
            for (int i = 0; i < n8; ++i) {
                int n10 = string2.indexOf(SQLERRMC_MESSAGE_DELIMITER, n9);
                String string8 = i == n8 - 1 ? string2.substring(n9) : string2.substring(n9, n10);
                if (i > 0) {
                    string5 = string8.substring(0, 5);
                    string8 = string8.substring(6);
                    stringArray[0] = stringArray[0] + " SQLSTATE: " + string5 + ": ";
                }
                MessageService.getLocalizedMessage(n, (short)string8.length(), string8, string3, n2, n3, n4, n5, n6, n7, string4, string5, string6, string7, stringArray2, nArray);
                if (nArray[0] == 0) {
                    stringArray[0] = i == 0 ? stringArray2[0] : stringArray[0] + stringArray2[0];
                }
                n9 = n10 + SQLERRMC_MESSAGE_DELIMITER.length();
            }
        }
    }

    private static Connection getDefaultConn() throws SQLException {
        Connection connection;
        InternalDriver internalDriver = InternalDriver.activeDriver();
        if (internalDriver != null && (connection = internalDriver.connect("jdbc:default:connection", null)) != null) {
            return connection;
        }
        throw Util.noCurrentConnection();
    }

    private static DatabaseMetaData getDMD() throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        return connection.getMetaData();
    }

    public static void SQLPROCEDURES(String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.isForODBC(string5) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProceduresForODBC(string2, string3, string4) : SystemProcedures.getDMD().getProcedures(string2, string3, string4);
    }

    public static void SQLFUNCTIONS(String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctions(string2, string3, string4);
    }

    public static void SQLTABLES(String string2, String string3, String string4, String string5, String string6, ResultSet[] resultSetArray) throws SQLException {
        String string7 = SystemProcedures.getOption("GETCATALOGS", string6);
        if (string7 != null && string7.trim().equals("1")) {
            resultSetArray[0] = SystemProcedures.getDMD().getCatalogs();
            return;
        }
        string7 = SystemProcedures.getOption("GETTABLETYPES", string6);
        if (string7 != null && string7.trim().equals("1")) {
            resultSetArray[0] = SystemProcedures.getDMD().getTableTypes();
            return;
        }
        string7 = SystemProcedures.getOption("GETSCHEMAS", string6);
        if (string7 != null) {
            if ((string7 = string7.trim()).equals("1")) {
                resultSetArray[0] = SystemProcedures.getDMD().getSchemas();
                return;
            }
            if (string7.equals("2")) {
                EmbedDatabaseMetaData embedDatabaseMetaData = (EmbedDatabaseMetaData)SystemProcedures.getDMD();
                resultSetArray[0] = embedDatabaseMetaData.getSchemas(string2, string3);
                return;
            }
        }
        String[] stringArray = null;
        if (string5 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string5, "',");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        resultSetArray[0] = SystemProcedures.getDMD().getTables(string2, string3, string4, stringArray);
    }

    public static void SQLFOREIGNKEYS(String string2, String string3, String string4, String string5, String string6, String string7, String string8, ResultSet[] resultSetArray) throws SQLException {
        String string9 = SystemProcedures.getOption("EXPORTEDKEY", string8);
        String string10 = SystemProcedures.getOption("IMPORTEDKEY", string8);
        resultSetArray[0] = string10 != null && string10.trim().equals("1") ? SystemProcedures.getDMD().getImportedKeys(string5, string6, string7) : (string9 != null && string9.trim().equals("1") ? SystemProcedures.getDMD().getExportedKeys(string2, string3, string4) : (SystemProcedures.isForODBC(string8) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getCrossReferenceForODBC(string2, string3, string4, string5, string6, string7) : SystemProcedures.getDMD().getCrossReference(string2, string3, string4, string5, string6, string7)));
    }

    private static String getOption(String string2, String string3) {
        if (string3 == null) {
            return null;
        }
        int n = string3.lastIndexOf(string2);
        if (n < 0) {
            return null;
        }
        int n2 = string3.indexOf(61, n);
        if (n2 < 0) {
            return null;
        }
        int n3 = string3.indexOf(59, n2);
        if (n3 < 0) {
            return string3.substring(n2 + 1);
        }
        return string3.substring(n2 + 1, n3);
    }

    public static void SQLPROCEDURECOLS(String string2, String string3, String string4, String string5, String string6, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.isForODBC(string6) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProcedureColumnsForODBC(string2, string3, string4, string5) : SystemProcedures.getDMD().getProcedureColumns(string2, string3, string4, string5);
    }

    public static void SQLFUNCTIONPARAMS(String string2, String string3, String string4, String string5, String string6, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctionColumns(string2, string3, string4, string5);
    }

    public static void SQLCOLUMNS(String string2, String string3, String string4, String string5, String string6, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.isForODBC(string6) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getColumnsForODBC(string2, string3, string4, string5) : SystemProcedures.getDMD().getColumns(string2, string3, string4, string5);
    }

    public static void SQLCOLPRIVILEGES(String string2, String string3, String string4, String string5, String string6, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getColumnPrivileges(string2, string3, string4, string5);
    }

    public static void SQLTABLEPRIVILEGES(String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getTablePrivileges(string2, string3, string4);
    }

    public static void SQLPRIMARYKEYS(String string2, String string3, String string4, String string5, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.getDMD().getPrimaryKeys(string2, string3, string4);
    }

    public static void SQLGETTYPEINFO(short s, String string2, ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = SystemProcedures.isForODBC(string2) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getTypeInfoForODBC() : SystemProcedures.getDMD().getTypeInfo();
    }

    public static void SQLSTATISTICS(String string2, String string3, String string4, short s, short s2, String string5, ResultSet[] resultSetArray) throws SQLException {
        boolean bl = s == 0;
        boolean bl2 = s2 == 1;
        resultSetArray[0] = SystemProcedures.isForODBC(string5) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getIndexInfoForODBC(string2, string3, string4, bl, bl2) : SystemProcedures.getDMD().getIndexInfo(string2, string3, string4, bl, bl2);
    }

    public static void SQLSPECIALCOLUMNS(short s, String string2, String string3, String string4, short s2, short s3, String string5, ResultSet[] resultSetArray) throws SQLException {
        boolean bl;
        boolean bl2 = bl = s3 == 1;
        resultSetArray[0] = s == 1 ? (SystemProcedures.isForODBC(string5) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getBestRowIdentifierForODBC(string2, string3, string4, s2, bl) : SystemProcedures.getDMD().getBestRowIdentifier(string2, string3, string4, s2, bl)) : (SystemProcedures.isForODBC(string5) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getVersionColumnsForODBC(string2, string3, string4) : SystemProcedures.getDMD().getVersionColumns(string2, string3, string4));
    }

    public static void SQLUDTS(String string2, String string3, String string4, String string5, String string6, ResultSet[] resultSetArray) throws SQLException {
        int[] nArray = null;
        if (string5 != null && string5.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string5, " \t\n\t,");
            int n = stringTokenizer.countTokens();
            nArray = new int[n];
            String string7 = "";
            try {
                for (int i = 0; i < n; ++i) {
                    string7 = stringTokenizer.nextToken();
                    nArray[i] = Integer.parseInt(string7);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Invalid type, " + string7 + ", passed to getUDTs.");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new SQLException("Internal failure: NoSuchElementException in getUDTs.");
            }
        }
        resultSetArray[0] = SystemProcedures.getDMD().getUDTs(string2, string3, string4, nArray);
    }

    public static void METADATA(ResultSet[] resultSetArray) throws SQLException {
        resultSetArray[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getClientCachedMetaData();
    }

    private static boolean isForODBC(String string2) {
        String string3 = SystemProcedures.getOption(DRIVER_TYPE_OPTION, string2);
        return string3 != null && string3.toUpperCase().equals(ODBC_DRIVER_OPTION);
    }

    public static void SYSCS_SET_DATABASE_PROPERTY(String string2, String string3) throws SQLException {
        PropertyInfo.setDatabaseProperty(string2, string3);
    }

    public static String SYSCS_GET_DATABASE_PROPERTY(String string2) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        try {
            return PropertyUtil.getDatabaseProperty(languageConnectionContext.getTransactionExecute(), string2);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void SYSCS_UPDATE_STATISTICS(String string2, String string3, String string4) throws SQLException {
        String string5 = IdUtil.normalToDelimited(string2);
        String string6 = IdUtil.normalToDelimited(string3);
        String string7 = "alter table " + string5 + "." + string6;
        string7 = string4 == null ? string7 + " all update statistics " : string7 + " update statistics " + IdUtil.normalToDelimited(string4);
        Connection connection = SystemProcedures.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement(string7);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void SYSCS_DROP_STATISTICS(String string2, String string3, String string4) throws SQLException {
        String string5 = IdUtil.normalToDelimited(string2);
        String string6 = IdUtil.normalToDelimited(string3);
        String string7 = "alter table " + string5 + "." + string6;
        string7 = string4 == null ? string7 + " all drop statistics " : string7 + " statistics drop " + IdUtil.normalToDelimited(string4);
        Connection connection = SystemProcedures.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement(string7);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void SYSCS_COMPRESS_TABLE(String string2, String string3, short s) throws SQLException {
        String string4 = IdUtil.normalToDelimited(string2);
        String string5 = IdUtil.normalToDelimited(string3);
        String string6 = "alter table " + string4 + "." + string5 + " compress" + (s != 0 ? " sequential" : "");
        Connection connection = SystemProcedures.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement(string6);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void SYSCS_FREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().freeze();
    }

    public static void SYSCS_UNFREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().unfreeze();
    }

    public static void SYSCS_CHECKPOINT_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().checkpoint();
    }

    public static void SYSCS_BACKUP_DATABASE(String string2) throws SQLException {
        Factory.getDatabaseOfConnection().backup(string2, true);
    }

    public static void SYSCS_BACKUP_DATABASE_NOWAIT(String string2) throws SQLException {
        Factory.getDatabaseOfConnection().backup(string2, false);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(String string2, short s) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(string2, s != 0, true);
    }

    public static void SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(String string2, short s) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(string2, s != 0, false);
    }

    public static void SYSCS_DISABLE_LOG_ARCHIVE_MODE(short s) throws SQLException {
        Factory.getDatabaseOfConnection().disableLogArchiveMode(s != 0);
    }

    public static void SYSCS_SET_RUNTIMESTATISTICS(short s) throws SQLException {
        ConnectionUtil.getCurrentLCC().setRunTimeStatisticsMode(s != 0);
    }

    public static void SYSCS_SET_STATISTICS_TIMING(short s) throws SQLException {
        ConnectionUtil.getCurrentLCC().setStatisticsTiming(s != 0);
    }

    public static int SYSCS_CHECK_TABLE(String string2, String string3) throws SQLException {
        boolean bl = ConsistencyChecker.checkTable(string2, string3);
        return bl ? 1 : 0;
    }

    public static void SYSCS_INPLACE_COMPRESS_TABLE(String string2, String string3, short s, short s2, short s3) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            object3 = languageConnectionContext.getDataDictionary();
            object2 = object3.getSchemaDescriptor(string2, transactionController, true);
            object = object3.getTableDescriptor(string3, (SchemaDescriptor)object2, transactionController);
            if (object != null && ((TableDescriptor)object).getTableType() == 5) {
                return;
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        object3 = IdUtil.normalToDelimited(string2);
        object2 = IdUtil.normalToDelimited(string3);
        object = "alter table " + (String)object3 + "." + (String)object2 + " compress inplace" + (s != 0 ? " purge" : "") + (s2 != 0 ? " defragment" : "") + (s3 != 0 ? " truncate_end" : "");
        Connection connection = SystemProcedures.getDefaultConn();
        PreparedStatement preparedStatement = connection.prepareStatement((String)object);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static String SYSCS_GET_RUNTIMESTATISTICS() throws SQLException {
        RunTimeStatistics runTimeStatistics = ConnectionUtil.getCurrentLCC().getRunTimeStatisticsObject();
        if (runTimeStatistics == null) {
            return null;
        }
        return runTimeStatistics.toString();
    }

    public static void INSTALL_JAR(String string2, String string3, int n) throws SQLException {
        try {
            String string4;
            String string5;
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string3.trim());
            if (stringArray.length == 1) {
                string5 = languageConnectionContext.getCurrentSchemaName();
                string4 = stringArray[0];
            } else {
                string5 = stringArray[0];
                string4 = stringArray[1];
            }
            SystemProcedures.checkJarSQLName(string4);
            JarUtil.install(languageConnectionContext, string5, string4, string2);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void REPLACE_JAR(String string2, String string3) throws SQLException {
        try {
            String string4;
            String string5;
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string3.trim());
            if (stringArray.length == 1) {
                string5 = languageConnectionContext.getCurrentSchemaName();
                string4 = stringArray[0];
            } else {
                string5 = stringArray[0];
                string4 = stringArray[1];
            }
            SystemProcedures.checkJarSQLName(string4);
            JarUtil.replace(languageConnectionContext, string5, string4, string2);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void REMOVE_JAR(String string2, int n) throws SQLException {
        try {
            String string3;
            String string4;
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string2.trim());
            if (stringArray.length == 1) {
                string4 = languageConnectionContext.getCurrentSchemaName();
                string3 = stringArray[0];
            } else {
                string4 = stringArray[0];
                string3 = stringArray[1];
            }
            SystemProcedures.checkJarSQLName(string3);
            JarUtil.drop(languageConnectionContext, string4, string3);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static void checkJarSQLName(String string2) throws StandardException {
        if (string2.length() == 0 || string2.indexOf(58) != -1) {
            throw StandardException.newException("XCXA0.S");
        }
    }

    public static void SYSCS_EXPORT_TABLE(String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        Export.exportTable(connection, string2, string3, string4, string5, string6, string7);
        connection.commit();
    }

    public static void SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        Export.exportTable(connection, string2, string3, string4, string5, string6, string7, string8);
        connection.commit();
    }

    public static void SYSCS_EXPORT_QUERY(String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        Export.exportQuery(connection, string2, string3, string4, string5, string6);
        connection.commit();
    }

    public static void SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE(String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        Export.exportQuery(connection, string2, string3, string4, string5, string6, string7);
        connection.commit();
    }

    public static void SYSCS_IMPORT_TABLE(String string2, String string3, String string4, String string5, String string6, String string7, short s) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        try {
            Import.importTable(connection, string2, string3, string4, string5, string6, string7, s, false);
        }
        catch (SQLException sQLException) {
            SystemProcedures.rollBackAndThrowSQLException(connection, sQLException);
        }
        connection.commit();
    }

    private static void rollBackAndThrowSQLException(Connection connection, SQLException sQLException) throws SQLException {
        try {
            connection.rollback();
        }
        catch (SQLException sQLException2) {
            sQLException.setNextException(sQLException2);
        }
        throw sQLException;
    }

    public static void SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(String string2, String string3, String string4, String string5, String string6, String string7, short s) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        try {
            Import.importTable(connection, string2, string3, string4, string5, string6, string7, s, true);
        }
        catch (SQLException sQLException) {
            SystemProcedures.rollBackAndThrowSQLException(connection, sQLException);
        }
        connection.commit();
    }

    public static void SYSCS_IMPORT_DATA(String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, short s) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        try {
            Import.importData(connection, string2, string3, string4, string5, string6, string7, string8, string9, s, false);
        }
        catch (SQLException sQLException) {
            SystemProcedures.rollBackAndThrowSQLException(connection, sQLException);
        }
        connection.commit();
    }

    public static void SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, short s) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        try {
            Import.importData(connection, string2, string3, string4, string5, string6, string7, string8, string9, s, true);
        }
        catch (SQLException sQLException) {
            SystemProcedures.rollBackAndThrowSQLException(connection, sQLException);
        }
        connection.commit();
    }

    public static void SYSCS_BULK_INSERT(String string2, String string3, String string4, String string5) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        String string6 = IdUtil.mkQualifiedName(string2, string3);
        String string7 = "insert into " + string6 + " --DERBY-PROPERTIES insertMode=bulkInsert \n" + "select * from new " + IdUtil.normalToDelimited(string4) + "(" + StringUtil.quoteStringLiteral(string2) + ", " + StringUtil.quoteStringLiteral(string3) + ", " + StringUtil.quoteStringLiteral(string5) + ")" + " as t";
        PreparedStatement preparedStatement = connection.prepareStatement(string7);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public static void SYSCS_RELOAD_SECURITY_POLICY() throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            throw Util.policyNotReloaded(securityException);
        }
    }

    public static double PI() {
        return Math.PI;
    }

    public static double LOG10(double d) {
        return StrictMath.log(d) / LOG10;
    }

    public static double COT(double d) {
        return 1.0 / StrictMath.tan(d);
    }

    public static double COSH(double d) {
        return (StrictMath.exp(d) + StrictMath.exp(-d)) / 2.0;
    }

    public static double SINH(double d) {
        return (StrictMath.exp(d) - StrictMath.exp(-d)) / 2.0;
    }

    public static double TANH(double d) {
        return (StrictMath.exp(d) - StrictMath.exp(-d)) / (StrictMath.exp(d) + StrictMath.exp(-d));
    }

    public static int SIGN(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static double RAND(int n) {
        return new Random(n).nextDouble();
    }

    public static void SYSCS_SET_USER_ACCESS(String string2, String string3) throws SQLException {
        try {
            String string4;
            if (string2 == null) {
                throw StandardException.newException("28502", string2);
            }
            if ("FULLACCESS".equals(string3)) {
                string4 = "derby.database.fullAccessUsers";
            } else if ("READONLYACCESS".equals(string3)) {
                string4 = "derby.database.readOnlyAccessUsers";
            } else if (string3 == null) {
                string4 = null;
            } else {
                throw StandardException.newException("XCZ00.S", string3);
            }
            SystemProcedures.removeFromAccessList("derby.database.fullAccessUsers", string2);
            SystemProcedures.removeFromAccessList("derby.database.readOnlyAccessUsers", string2);
            if (string4 != null) {
                String string5 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY(string4);
                SystemProcedures.SYSCS_SET_DATABASE_PROPERTY(string4, IdUtil.appendNormalToList(string2, string5));
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static void removeFromAccessList(String string2, String string3) throws SQLException, StandardException {
        String string4 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY(string2);
        if (string4 != null) {
            SystemProcedures.SYSCS_SET_DATABASE_PROPERTY(string2, IdUtil.deleteId(string3, string4));
        }
    }

    public static String SYSCS_GET_USER_ACCESS(String string2) throws SQLException {
        try {
            if (string2 == null) {
                throw StandardException.newException("28502", string2);
            }
            String string3 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.fullAccessUsers");
            if (IdUtil.idOnList(string2, string3)) {
                return "FULLACCESS";
            }
            String string4 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.readOnlyAccessUsers");
            if (IdUtil.idOnList(string2, string4)) {
                return "READONLYACCESS";
            }
            String string5 = SystemProcedures.SYSCS_GET_DATABASE_PROPERTY("derby.database.defaultConnectionMode");
            string5 = string5 != null ? StringUtil.SQLToUpperCase(string5) : "FULLACCESS";
            return string5;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void SYSCS_EMPTY_STATEMENT_CACHE() throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        CacheManager cacheManager = languageConnectionContext.getLanguageConnectionFactory().getStatementCache();
        if (cacheManager != null) {
            cacheManager.ageOut();
        }
    }

    public static void SYSCS_SET_XPLAIN_MODE(int n) throws SQLException, StandardException {
        ConnectionUtil.getCurrentLCC().setXplainOnlyMode(n != 0);
    }

    public static int SYSCS_GET_XPLAIN_MODE() throws SQLException, StandardException {
        return ConnectionUtil.getCurrentLCC().getXplainOnlyMode() ? 1 : 0;
    }

    public static void SYSCS_SET_XPLAIN_SCHEMA(String string2) throws SQLException, StandardException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        if (string2 == null || string2.trim().length() == 0) {
            languageConnectionContext.setXplainSchema(null);
            return;
        }
        boolean bl = languageConnectionContext.getRunTimeStatisticsMode();
        languageConnectionContext.setRunTimeStatisticsMode(false);
        SystemProcedures.createXplainSchema(string2);
        SystemProcedures.createXplainTable(languageConnectionContext, string2, new XPLAINStatementDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string2, new XPLAINStatementTimingsDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string2, new XPLAINResultSetDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string2, new XPLAINResultSetTimingsDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string2, new XPLAINScanPropsDescriptor());
        SystemProcedures.createXplainTable(languageConnectionContext, string2, new XPLAINSortPropsDescriptor());
        languageConnectionContext.setRunTimeStatisticsMode(bl);
        languageConnectionContext.setXplainSchema(string2);
    }

    private static boolean hasSchema(Connection connection, String string2) throws SQLException {
        ResultSet resultSet = connection.getMetaData().getSchemas();
        boolean bl = false;
        while (resultSet.next() && !bl) {
            bl = string2.equals(resultSet.getString("TABLE_SCHEM"));
        }
        resultSet.close();
        return bl;
    }

    private static boolean hasTable(Connection connection, String string2, String string3) throws SQLException {
        ResultSet resultSet = connection.getMetaData().getTables(null, string2, string3, new String[]{"TABLE"});
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    private static void createXplainSchema(String string2) throws SQLException {
        Connection connection = SystemProcedures.getDefaultConn();
        if (!SystemProcedures.hasSchema(connection, string2)) {
            String string3 = IdUtil.normalToDelimited(string2);
            Statement statement = connection.createStatement();
            statement.executeUpdate("CREATE SCHEMA " + string3);
            statement.close();
        }
        connection.close();
    }

    private static void createXplainTable(LanguageConnectionContext languageConnectionContext, String string2, XPLAINTableDescriptor xPLAINTableDescriptor) throws SQLException {
        Object object;
        String[] stringArray = xPLAINTableDescriptor.getTableDDL(string2);
        Connection connection = SystemProcedures.getDefaultConn();
        if (!SystemProcedures.hasTable(connection, string2, xPLAINTableDescriptor.getCatalogName())) {
            object = connection.createStatement();
            for (int i = 0; i < stringArray.length; ++i) {
                object.executeUpdate(stringArray[i]);
            }
            object.close();
        }
        object = xPLAINTableDescriptor.getTableInsert();
        connection.prepareStatement((String)object).close();
        connection.close();
        languageConnectionContext.setXplainStatement(xPLAINTableDescriptor.getCatalogName(), object);
    }

    public static String SYSCS_GET_XPLAIN_SCHEMA() throws SQLException, StandardException {
        String string2 = ConnectionUtil.getCurrentLCC().getXplainSchema();
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static void SYSCS_CREATE_USER(String string2, String string3) throws SQLException {
        string2 = SystemProcedures.normalizeUserName(string2);
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            String string4 = dataDictionary.getAuthorizationDatabaseOwner();
            if (!string4.equals(string2)) {
                if (dataDictionary.getUser(string4) == null) {
                    throw StandardException.newException("4251K");
                }
            } else {
                String string5 = languageConnectionContext.getStatementContext().getSQLSessionContext().getCurrentUser();
                if (!string4.equals(string5)) {
                    throw StandardException.newException("4251D");
                }
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        SystemProcedures.addUser(string2, string3, transactionController);
    }

    public static void addUser(String string2, String string3, TransactionController transactionController) throws SQLException {
        try {
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            dataDictionary.startWriting(languageConnectionContext);
            UserDescriptor userDescriptor = SystemProcedures.makeUserDescriptor(dataDictionary, transactionController, string2, string3);
            dataDictionary.addDescriptor(userDescriptor, null, 22, false, transactionController);
            if (dataDictionary.getAuthorizationDatabaseOwner().equals(string2)) {
                transactionController.setProperty("derby.authentication.provider", (Serializable)((Object)"NATIVE::LOCAL"), true);
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static UserDescriptor makeUserDescriptor(DataDictionary dataDictionary, TransactionController transactionController, String string2, String string3) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        PasswordHasher passwordHasher = dataDictionary.makePasswordHasher(transactionController.getProperties());
        if (passwordHasher == null) {
            throw StandardException.newException("4251G");
        }
        String string4 = passwordHasher.encodeHashingScheme();
        String string5 = passwordHasher.hashPasswordIntoString(string2, string3);
        Timestamp timestamp = new Timestamp(new Date().getTime());
        UserDescriptor userDescriptor = dataDescriptorGenerator.newUserDescriptor(string2, string4, string5.toCharArray(), timestamp);
        return userDescriptor;
    }

    public static void SYSCS_RESET_PASSWORD(String string2, String string3) throws SQLException {
        SystemProcedures.resetAuthorizationIDPassword(SystemProcedures.normalizeUserName(string2), string3);
    }

    private static void resetAuthorizationIDPassword(String string2, String string3) throws SQLException {
        try {
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            SystemProcedures.checkLegalUser(dataDictionary, string2);
            dataDictionary.startWriting(languageConnectionContext);
            UserDescriptor userDescriptor = SystemProcedures.makeUserDescriptor(dataDictionary, transactionController, string2, string3);
            dataDictionary.updateUser(userDescriptor, transactionController);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void SYSCS_MODIFY_PASSWORD(String string2) throws SQLException {
        String string3 = ConnectionUtil.getCurrentLCC().getStatementContext().getSQLSessionContext().getCurrentUser();
        SystemProcedures.resetAuthorizationIDPassword(string3, string2);
    }

    public static void SYSCS_DROP_USER(String string2) throws SQLException {
        string2 = SystemProcedures.normalizeUserName(string2);
        try {
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            String string3 = dataDictionary.getAuthorizationDatabaseOwner();
            if (string3.equals(string2)) {
                throw StandardException.newException("4251F");
            }
            SystemProcedures.checkLegalUser(dataDictionary, string2);
            dataDictionary.startWriting(languageConnectionContext);
            dataDictionary.dropUser(string2, languageConnectionContext.getTransactionExecute());
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static void checkLegalUser(DataDictionary dataDictionary, String string2) throws StandardException {
        if (dataDictionary.getUser(string2) == null) {
            throw StandardException.newException("XK001.S");
        }
    }

    private static String normalizeUserName(String string2) throws SQLException {
        try {
            return IdUtil.getUserAuthorizationId(string2);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static Long SYSCS_PEEK_AT_SEQUENCE(String string2, String string3) throws SQLException {
        try {
            return ConnectionUtil.getCurrentLCC().getDataDictionary().peekAtSequence(string2, string3);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }
}

