/*
 * Decompiled with CFR 0.152.
 */
package edu.uchsc.ccp.nlp.ei.mutation;

import edu.uchsc.ccp.nlp.ei.mutation.Mutation;
import edu.uchsc.ccp.nlp.ei.mutation.MutationException;
import edu.uchsc.ccp.nlp.ei.mutation.MutationExtractor;
import edu.uchsc.ccp.nlp.ei.mutation.MyPattern;
import edu.uchsc.ccp.nlp.ei.mutation.PointMutation;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class MutationFinder
extends MutationExtractor {
    private final String CASE_SENSITIVE = "[CASE_SENSITIVE]";
    protected static final String MUT_RES = "?P<mut_res>";
    protected static final String WT_RES = "?P<wt_res>";
    protected static final String POS = "?P<pos>";
    protected static final Set<String> ambiguous = new HashSet<String>();
    private Map<MyPattern, Map<String, Integer>> regular_expressions;

    public MutationFinder(String fileName) {
        File file = new File(fileName);
        this.loadRegularExpressionsFromFile(file);
        this.initializeAmbiguousMentions();
    }

    public MutationFinder(File file) {
        this.loadRegularExpressionsFromFile(file);
    }

    public MutationFinder(Set<String> unprocessed_python_regexes) {
        this.regular_expressions = new HashMap<MyPattern, Map<String, Integer>>();
        int elementNumber = 0;
        for (String python_regex : unprocessed_python_regexes) {
            this.processPythonRegex(python_regex, elementNumber++);
        }
    }

    private void processPythonRegex(String regexStr, int line) {
        Map<String, Integer> groupMappings = MutationFinder.extractMappingsFromPythonRegex(regexStr);
        regexStr = MutationFinder.removeTagsFromPythonRegex(regexStr);
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            if (regexStr.endsWith("[CASE_SENSITIVE]")) {
                this.regular_expressions.put(new MyPattern(compiler.compile(regexStr.substring(0, regexStr.lastIndexOf(91))), regexStr, line), groupMappings);
            } else {
                this.regular_expressions.put(new MyPattern(compiler.compile(regexStr, 1), regexStr, line), groupMappings);
            }
        }
        catch (MalformedPatternException mpe) {
            mpe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRegularExpressionsFromFile(File file) {
        this.regular_expressions = new HashMap<MyPattern, Map<String, Integer>>();
        BufferedReader br = null;
        int count2 = 0;
        try {
            String line;
            FileReader fr = new FileReader(file);
            br = new BufferedReader(fr);
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                if (line.startsWith("#")) continue;
                this.processPythonRegex(line, lineNumber);
                if (++count2 % 100 != 0) continue;
                System.err.println("Loading regex's: " + count2);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.error("The file containing regular expressions could not be found: " + file.getAbsolutePath() + File.separator + file.getName());
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            this.error("IO Exception while processing regular expression file.");
            ioe.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        System.err.println("Completed loading of regular expressions: " + this.regular_expressions.size() + " loaded.");
    }

    private void initializeAmbiguousMentions() {
        ambiguous.add("T47D");
        ambiguous.add("T98G");
        ambiguous.add("L5178Y");
        ambiguous.add("J774A");
        ambiguous.add("H295R");
        ambiguous.add("F442A");
        ambiguous.add("C33A");
        ambiguous.add("C57L");
        ambiguous.add("J558L");
        ambiguous.add("A375P");
        ambiguous.add("A375M");
        ambiguous.add("C-33A");
        ambiguous.add("V38A");
        ambiguous.add("R201C");
        ambiguous.add("B10R");
        ambiguous.add("K562R");
        ambiguous.add("B10S");
        ambiguous.add("R3327H");
        ambiguous.add("H322M");
        ambiguous.add("N1003A");
        ambiguous.add("H295A");
        ambiguous.add("A5H");
        ambiguous.add("T42A");
        ambiguous.add("V15B");
        ambiguous.add("H510A");
        ambiguous.add("T2C");
        ambiguous.add("S100B");
    }

    public static Map<String, Integer> extractMappingsFromPythonRegex(String pythonRegex) {
        HashMap<String, Integer> groupMappings = new HashMap<String, Integer>();
        groupMappings.put(MUT_RES, MutationFinder.countRegExParenthesesBeforeIndex(pythonRegex, pythonRegex.indexOf(MUT_RES)));
        groupMappings.put(WT_RES, MutationFinder.countRegExParenthesesBeforeIndex(pythonRegex, pythonRegex.indexOf(WT_RES)));
        groupMappings.put(POS, MutationFinder.countRegExParenthesesBeforeIndex(pythonRegex, pythonRegex.indexOf(POS)));
        return groupMappings;
    }

    public static String removeTagsFromPythonRegex(String regexStr) {
        return regexStr.replaceAll("\\?P<mut_res>", "").replaceAll("\\?P<wt_res>", "").replaceAll("\\?P<pos>", "");
    }

    private static int countRegExParenthesesBeforeIndex(String regexStr, int index) {
        Pattern p = Pattern.compile("[^\\\\]\\((?!\\?:)");
        Matcher m = p.matcher(regexStr);
        int count2 = 0;
        int currentIndex = -1;
        while (m.find() && currentIndex < index) {
            ++count2;
            currentIndex = m.start();
        }
        return count2 - 1;
    }

    private void postProcess(Map<Mutation, Set<int[]>> mutations) {
        ArrayList<PointMutation> mutationsToDelete = new ArrayList<PointMutation>();
        for (Mutation mutation2 : mutations.keySet()) {
            PointMutation pm;
            if (!(mutation2 instanceof PointMutation) || (pm = (PointMutation)mutation2).getWtResidue() != pm.getMutResidue()) continue;
            mutationsToDelete.add(pm);
        }
        for (Mutation mutation3 : mutationsToDelete) {
            mutations.remove(mutation3);
        }
    }

    @Override
    public Map<Mutation, Set<int[]>> extractMutations(String rawText) throws MutationException {
        HashMap<Mutation, Set<int[]>> extractedMutations = new HashMap<Mutation, Set<int[]>>();
        for (MyPattern pattern : this.regular_expressions.keySet()) {
            Perl5Matcher m = new Perl5Matcher();
            PatternMatcherInput input2 = new PatternMatcherInput(rawText);
            Map<String, Integer> groupMappings = this.regular_expressions.get(pattern);
            int pos_group = groupMappings.get(POS);
            int wtres_group = groupMappings.get(WT_RES);
            int mutres_group = groupMappings.get(MUT_RES);
            while (m.contains(input2, pattern.getPattern())) {
                int id = pattern.getId();
                MatchResult result2 = m.getMatch();
                try {
                    PointMutation pm = new PointMutation(result2.group(pos_group).replaceAll("\\s", ""), result2.group(wtres_group), result2.group(mutres_group));
                    if (!pm.isValid() || ambiguous.contains(pm.toString()) && result2.group(wtres_group).trim().length() == 1 && result2.group(mutres_group).trim().length() == 1) continue;
                    pm.setId(id);
                    int[] span2 = new int[]{Math.min(result2.beginOffset(pos_group), Math.min(result2.beginOffset(wtres_group), result2.beginOffset(mutres_group))), Math.max(result2.endOffset(pos_group), Math.max(result2.endOffset(wtres_group), result2.endOffset(mutres_group)))};
                    if (extractedMutations.containsKey(pm)) {
                        ((Set)extractedMutations.get(pm)).add(span2);
                        continue;
                    }
                    HashSet<int[]> spans = new HashSet<int[]>();
                    spans.add(span2);
                    extractedMutations.put(pm, spans);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Problem parsing: " + result2.group(pos_group) + " " + result2.group(wtres_group) + " " + result2.group(mutres_group));
                }
            }
        }
        this.postProcess(extractedMutations);
        return extractedMutations;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 3) {
                String line;
                String regularExpressionFile = args[0];
                String inputFileLocation = args[1];
                String outputFileLocation = args[2];
                System.out.print("Initializing MutationFinder...");
                MutationFinder mf = new MutationFinder(regularExpressionFile);
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(inputFileLocation)));
                PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFileLocation)));
                while ((line = br.readLine()) != null) {
                    int firstTabIndex = line.indexOf("\t");
                    String id = line.substring(0, firstTabIndex);
                    String text2 = line.substring(firstTabIndex + 1);
                    String outputLine = id;
                    Map<Mutation, Set<int[]>> mutations = mf.extractMutations(text2);
                    for (Mutation mutation2 : mutations.keySet()) {
                        for (int i = 0; i < mutations.get(mutation2).size(); ++i) {
                            outputLine = outputLine + "\t" + ((PointMutation)mutation2).toString();
                        }
                    }
                    ps.println(outputLine);
                }
                br.close();
                ps.close();
            } else {
                System.err.println("ERROR: Invalid number of input parameters. Execution of MutationFinder requires three input parameters.");
                System.err.println("USAGE: MutationFinder regularExpressionFile inputFile outputFile");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

