/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.stuff.xml;

import de.hu.berlin.wbi.stuff.xml.PSM;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SNP {
    private final int rsId;
    private final Set<PSM> psms;
    private final List<String> hgvs;

    public SNP(int rsId) {
        this.rsId = rsId;
        this.psms = new HashSet<PSM>();
        this.hgvs = new ArrayList<String>();
    }

    public void addPSM(PSM psm) {
        boolean add = false;
        for (PSM tmpSNP : this.psms) {
            if (tmpSNP.getAaLoc() != psm.getAaLoc() || tmpSNP.getEntrez() != psm.getEntrez()) continue;
            if (psm.getWildtype() != null) {
                tmpSNP.setWildtype(psm.getWildtype());
            } else {
                tmpSNP.addMutations(psm.mutations);
            }
            add = true;
            break;
        }
        if (!add) {
            this.psms.add(psm);
        }
    }

    public void addHgvs(String hgvs) {
        this.hgvs.add(hgvs);
    }

    public int getRsId() {
        return this.rsId;
    }

    public Set<PSM> getPsms() {
        return this.psms;
    }

    public List<String> getHgvs() {
        return this.hgvs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rs");
        sb.append(this.rsId);
        sb.append(" ");
        for (PSM psm : this.psms) {
            sb.append(psm.toString());
            sb.append(";");
        }
        sb.append(" ");
        for (String string2 : this.hgvs) {
            sb.append(string2);
            sb.append(";");
        }
        return sb.toString();
    }
}

