/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.stuff.xml;

import de.hu.berlin.wbi.objects.DatabaseConnection;
import de.hu.berlin.wbi.stuff.xml.PSM;
import de.hu.berlin.wbi.stuff.xml.SNP;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseXML
extends DefaultHandler {
    private StringBuilder hgvs = null;
    private SNP snp;
    private static PreparedStatement psHGVS;
    private static PreparedStatement psmHGVS;

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, SQLException {
        Properties property = new Properties();
        try {
            property.loadFromXML(new FileInputStream(new File(args[0])));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        DatabaseConnection dbconn = new DatabaseConnection(property);
        dbconn.connect();
        psHGVS = dbconn.getConn().prepareStatement("INSERT INTO " + property.getProperty("database.hgvs_view") + " (locus_id, snp_id, hgvs, refseq) VALUES (?, ?, ?, ?)");
        psmHGVS = dbconn.getConn().prepareStatement("INSERT INTO " + property.getProperty("database.PSM") + " (snp_id, locus_id, aa_Position, residue, wildtype) VALUES (?, ?, ?, ?, ?)");
        String xmlFolder = "/home/philippe/workspace/snp-normalizer/data/dat/";
        if (args.length != 1) {
            xmlFolder = args[1];
        }
        for (File file : new File(xmlFolder).listFiles()) {
            if (!file.getAbsolutePath().endsWith(".gz")) continue;
            System.out.println("Parsing " + file.getAbsolutePath());
            GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(file));
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ParseXML handler = new ParseXML();
            saxParser.parse((InputStream)gzipStream, (DefaultHandler)handler);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (qName.equals("Rs")) {
            this.snp = new SNP(Integer.parseInt(atts.getValue("rsId")));
        }
        if (qName.equals("FxnSet")) {
            String geneId = atts.getValue("geneId");
            String aaPos = atts.getValue("aaPosition");
            String type = atts.getValue("fxnClass");
            String residue = atts.getValue("residue");
            if (aaPos != null && geneId != null && !geneId.equals("null") && residue != null) {
                if (type.equals("reference")) {
                    this.snp.addPSM(new PSM(Integer.parseInt(geneId), Integer.parseInt(aaPos), residue, null));
                } else if (type.equals("missense") || type.equals("frameshift-variant") || type.equals("stop-gained") || type.equals("stop-lost") || type.equals("intron-variant")) {
                    this.snp.addPSM(new PSM(Integer.parseInt(geneId), Integer.parseInt(aaPos), null, residue));
                } else if (!(type.equals("cds-indel") || type.equals("utr-variant-5-prime") || type.equals("nc-transcript-variant") || type.equals("splice-acceptor-variant") || type.equals("utr-variant-3-prime"))) {
                    if (!type.equals("synonymous-codon")) throw new RuntimeException("Can't handle type " + type + " '" + residue + "' for rs" + this.snp.getRsId());
                    this.snp.addPSM(new PSM(Integer.parseInt(geneId), Integer.parseInt(aaPos), residue, residue));
                }
            } else if (geneId != null && !geneId.equals("null")) {
                this.snp.addPSM(new PSM(Integer.parseInt(geneId), 0, null, null));
            }
        }
        if (!qName.equals("hgvs")) return;
        this.hgvs = new StringBuilder();
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("hgvs")) {
            this.snp.addHgvs(this.hgvs.toString());
            this.hgvs = null;
        }
        if (qName.equals("Rs")) {
            HashSet<Integer> genes = new HashSet<Integer>();
            for (PSM psm : this.snp.getPsms()) {
                genes.add(psm.getEntrez());
                if (!psm.isValid()) continue;
                try {
                    if (psm.getMutations().length() > 128 || psm.getWildtype().length() > 128) continue;
                    psmHGVS.setInt(1, this.snp.getRsId());
                    psmHGVS.setInt(2, psm.getEntrez());
                    psmHGVS.setInt(3, psm.getAaLoc());
                    psmHGVS.setString(4, psm.getMutations());
                    psmHGVS.setString(5, psm.getWildtype());
                    int returnValue = psmHGVS.executeUpdate();
                    if (returnValue == 1) continue;
                    throw new RuntimeException("Returnvalue=" + returnValue + " for query" + psmHGVS.toString());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    System.err.println(psmHGVS.toString());
                    System.exit(1);
                }
            }
            for (String hgvs : this.snp.getHgvs()) {
                String[] split2 = hgvs.split(":");
                if (split2.length != 2) {
                    System.out.println("Split size " + split2.length + " instead of 2 for '" + hgvs + "'");
                    System.out.println("rs" + this.snp.getRsId());
                    continue;
                }
                if (split2[1].length() >= 256) continue;
                try {
                    for (Integer gene : genes) {
                        psHGVS.setInt(1, gene);
                        psHGVS.setInt(2, this.snp.getRsId());
                        psHGVS.setString(3, split2[1]);
                        psHGVS.setString(4, split2[0]);
                        int returnValue = psHGVS.executeUpdate();
                        if (returnValue == 1) continue;
                        throw new RuntimeException("Returnvalue=" + returnValue + " for query " + psHGVS.toString());
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    System.err.println(psHGVS.toString());
                    System.exit(1);
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.hgvs != null) {
            this.hgvs.append(new String(ch, start, length));
        }
    }
}

