/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.stuff.xml;

import java.util.HashSet;
import java.util.Set;

public class PSM {
    private int entrez;
    private int aaLoc;
    private String wildtype;
    Set<String> mutations;

    public PSM(int entrez, int aaLoc, String reference, String mutations) {
        this.entrez = entrez;
        this.aaLoc = aaLoc;
        this.wildtype = reference;
        this.mutations = new HashSet<String>(1);
        if (mutations != null) {
            this.mutations.add(mutations);
        }
    }

    public boolean isValid() {
        if (this.entrez < 0) {
            return false;
        }
        if (this.aaLoc < 0) {
            return false;
        }
        if (this.wildtype == null) {
            return false;
        }
        return this.mutations != null && this.mutations.size() != 0;
    }

    public int getEntrez() {
        return this.entrez;
    }

    public void setEntrez(int entrez) {
        this.entrez = entrez;
    }

    public int getAaLoc() {
        return this.aaLoc;
    }

    public void setAaLoc(int aaLoc) {
        this.aaLoc = aaLoc;
    }

    public String getWildtype() {
        return this.wildtype;
    }

    public void setWildtype(String wildtype) {
        this.wildtype = wildtype;
    }

    public String getMutations() {
        StringBuilder sb = new StringBuilder();
        for (String mutation2 : this.mutations) {
            sb.append(mutation2);
            sb.append("|");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void addMutation(String mutation2) {
        if (mutation2 != null) {
            this.mutations.add(mutation2);
        }
    }

    public void addMutations(Set<String> mutations) {
        for (String mutation2 : mutations) {
            this.mutations.add(mutation2);
        }
    }

    public String toString() {
        return "PSM [aaLoc=" + this.aaLoc + ", entrez=" + this.entrez + ", reference=" + this.wildtype + ", mutations=" + this.mutations + "]";
    }
}

