/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.process;

import de.hu.berlin.wbi.objects.DatabaseConnection;
import de.hu.berlin.wbi.objects.EntityOffset;
import de.hu.berlin.wbi.objects.Gene;
import de.hu.berlin.wbi.objects.MutationMention;
import de.hu.berlin.wbi.objects.UniprotFeature;
import de.hu.berlin.wbi.objects.dbSNP;
import de.hu.berlin.wbi.objects.dbSNPNormalized;
import java.io.File;
import java.io.FileInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class NormalizeDB {
    public static void main(String[] args) throws SQLException {
        String propertyFile = args[0];
        Properties property = new Properties();
        try {
            property.loadFromXML(new FileInputStream(new File(propertyFile)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        DatabaseConnection mysql = new DatabaseConnection(property);
        mysql.connect();
        HashMap mutations = new HashMap();
        String snpTable = property.getProperty("database.SNPTable");
        try {
            mysql.query("SELECT * FROM " + snpTable + " WHERE begin != -1");
            ResultSet rs = mysql.getRs();
            while (rs.next()) {
                int pmid = rs.getInt("pmid");
                MutationMention mutation2 = new MutationMention(new EntityOffset(rs.getInt("begin"), rs.getInt("end")), rs.getString("normalized"));
                if (mutation2 == null) continue;
                if (mutations.containsKey(pmid)) {
                    ((List)mutations.get(pmid)).add(mutation2);
                    continue;
                }
                ArrayList<MutationMention> mutList = new ArrayList<MutationMention>();
                mutList.add(mutation2);
                mutations.put(pmid, mutList);
            }
            mysql.closeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        int nMutations = 0;
        for (List mmList : mutations.values()) {
            nMutations += mmList.size();
        }
        System.err.println(mutations.size() + " articles with " + nMutations + " entries for normalisation loaded");
        dbSNP.init(mysql, property.getProperty("database.PSM"), property.getProperty("database.hgvs_view"));
        Gene.init(mysql, property.getProperty("database.geneTable"), property.getProperty("database.gene2pubmed"));
        UniprotFeature.init(mysql, property.getProperty("database.uniprot"));
        PreparedStatement ps = mysql.getConn().prepareStatement("UPDATE " + snpTable + " SET rs = ? WHERE pmid = ?  AND begin = ? AND end = ? ;");
        long start = System.currentTimeMillis();
        int possible = 0;
        int ambig = 0;
        int ambigLevel = 0;
        int i = 0;
        Iterator i$ = mutations.keySet().iterator();
        while (i$.hasNext()) {
            int pmid = (Integer)i$.next();
            Set<Gene> genes = Gene.queryGenesForArticle(pmid);
            HashMap<Gene, List<dbSNP>> geneToDbSNP = new HashMap<Gene, List<dbSNP>>();
            HashMap<Gene, List<UniprotFeature>> geneToUniProtFeature = new HashMap<Gene, List<UniprotFeature>>();
            for (Gene gene : genes) {
                List<dbSNP> potentialSNPs = dbSNP.getSNP(gene.getGeneID());
                List<UniprotFeature> features = UniprotFeature.getFeatures(gene.getGeneID());
                geneToDbSNP.put(gene, potentialSNPs);
                geneToUniProtFeature.put(gene, features);
            }
            for (MutationMention mutation3 : (List)mutations.get(pmid)) {
                ++i;
                ArrayList<dbSNPNormalized> normalized = new ArrayList<dbSNPNormalized>();
                for (Gene gene : genes) {
                    List potentialSNPs = (List)geneToDbSNP.get(gene);
                    List features = (List)geneToUniProtFeature.get(gene);
                    mutation3.normalizeSNP(potentialSNPs, features, false);
                    normalized.addAll(mutation3.getNormalized());
                }
                HashSet<Integer> rsIDs = new HashSet<Integer>();
                boolean nsm = false;
                boolean psm = false;
                for (dbSNPNormalized norm : normalized) {
                    if (norm.isPsm()) {
                        psm = true;
                    } else {
                        nsm = true;
                    }
                    rsIDs.add(norm.getRsID());
                }
                if (nsm && psm) {
                    ++ambigLevel;
                }
                if (normalized.size() > 0) {
                    ++possible;
                    StringBuilder sb = new StringBuilder(rsIDs.size() * 10);
                    for (Integer rsID : rsIDs) {
                        if (sb.length() > 0) {
                            sb.append("|");
                        }
                        sb.append(rsID);
                    }
                    ps.setString(1, sb.toString());
                    ps.setInt(2, pmid);
                    ps.setInt(3, mutation3.getLocation().getStart());
                    ps.setInt(4, mutation3.getLocation().getStop());
                    ps.executeUpdate();
                }
                if (normalized.size() > 1) {
                    ++ambig;
                }
                if (i % 1000 != 0) continue;
                System.gc();
                System.out.println(i + "/" + nMutations + " " + "( normalization: " + possible + "=" + 100 * possible / (i == 0 ? 1 : i) + "%" + "; memory: " + Runtime.getRuntime().totalMemory() / 1024L / 1024L + " MB" + "; speed: " + (long)(1000 * i) / (System.currentTimeMillis() - start) + " mention/sec" + "; time left: " + NormalizeDB.formatAsHHMMSS((long)(nMutations - i) * (System.currentTimeMillis() - start) / 1000L / (long)(i == 0 ? 1 : i)) + " )");
            }
        }
        System.err.println("Normalization possible for " + possible + "/" + nMutations + " mentions");
        System.err.println("Normalization ambigous for " + ambig + "/" + possible);
        System.err.println("Normalization PSM/NSM ambig for " + ambigLevel + "/" + ambig);
        mysql.disconnect();
    }

    private static String formatAsHHMMSS(long secs) {
        long hours = secs / 3600L;
        long remainder = secs % 3600L;
        long minutes = remainder / 60L;
        long seconds = remainder % 60L;
        return (hours < 10L ? "0" : "") + hours + ":" + (minutes < 10L ? "0" : "") + minutes + ":" + (seconds < 10L ? "0" : "") + seconds;
    }
}

