/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.process;

import de.hu.berlin.wbi.objects.DatabaseConnection;
import de.hu.berlin.wbi.objects.Gene;
import de.hu.berlin.wbi.objects.MutationMention;
import de.hu.berlin.wbi.objects.UniprotFeature;
import de.hu.berlin.wbi.objects.dbSNP;
import de.hu.berlin.wbi.objects.dbSNPNormalized;
import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Normalize {
    public static void main(String[] args) {
        if (args.length != 2) {
            Normalize.printUsage();
            System.exit(1);
        }
        String propertyFile = args[0];
        String mutationsFile = args[1];
        System.err.println("Normalising mutations from '" + mutationsFile + "' and properties from '" + propertyFile + "'");
        Properties property = new Properties();
        try {
            property.loadFromXML(new FileInputStream(new File(propertyFile)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        DatabaseConnection mysql = new DatabaseConnection(property);
        mysql.connect();
        Map<Integer, List<MutationMention>> mutations = null;
        try {
            mutations = MutationMention.readMutations(mutationsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.err.println(mutations.size() + " mutations for normalisation loaded");
        try {
            dbSNP.init(mysql, property.getProperty("database.PSM"), property.getProperty("database.hgvs_view"));
            UniprotFeature.init(mysql, property.getProperty("database.uniprot"));
            Gene.init(mysql, property.getProperty("database.geneTable"), property.getProperty("database.gene2pubmed"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        int possible = 0;
        int nMutatons = 0;
        for (int pmid : mutations.keySet()) {
            Set<Gene> genes = Gene.queryGenesForArticle(pmid);
            for (MutationMention mutation2 : mutations.get(pmid)) {
                ++nMutatons;
                HashSet<dbSNPNormalized> normalized = new HashSet<dbSNPNormalized>();
                for (Gene gene : genes) {
                    List<dbSNP> potentialSNPs = dbSNP.getSNP(gene.getGeneID());
                    List<UniprotFeature> features = UniprotFeature.getFeatures(gene.getGeneID());
                    mutation2.normalizeSNP(potentialSNPs, features, false);
                    normalized.addAll(mutation2.getNormalized());
                }
                StringBuilder sb = new StringBuilder(pmid + "\t" + mutation2.toNormalized() + "\t" + mutation2.getLocation().getStart() + "\t" + mutation2.getLocation().getStop());
                for (dbSNPNormalized norm : normalized) {
                    sb.append("\trs");
                    sb.append(norm.getRsID());
                }
                System.out.println(sb);
                if (normalized.size() < 1) continue;
                ++possible;
            }
        }
        System.err.println("Normalization possible for " + possible + "/" + nMutatons + " mentions");
        mysql.disconnect();
    }

    private static void printUsage() {
        System.err.println("Normalises previously identified mutations");
        System.err.println("Usage: java de.hu.berlin.wbi.process.Normalize property-file corpus-file\n");
        System.err.println("Arguments:");
        System.err.println("\t property-file\t-> File containing the property settings to access the database");
        System.err.println("\t corpus-file\t-> File containing the mutations to normalize");
    }
}

