/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.process;

import de.hu.berlin.wbi.objects.DatabaseConnection;
import de.hu.berlin.wbi.objects.Gene;
import de.hu.berlin.wbi.objects.MutationValidation;
import de.hu.berlin.wbi.objects.UniprotFeature;
import de.hu.berlin.wbi.objects.dbSNP;
import de.hu.berlin.wbi.objects.dbSNPNormalized;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Evaluate {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            Evaluate.printUsage();
            System.exit(1);
        }
        String propertyFile = args[0];
        String mutationsFile = args[1];
        Map<Integer, List<MutationValidation>> mutations = null;
        Properties property = new Properties();
        try {
            property.loadFromXML(new FileInputStream(new File(propertyFile)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        DatabaseConnection mysql = new DatabaseConnection(property);
        mysql.connect();
        try {
            mutations = MutationValidation.readMutationsValidation(mutationsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            dbSNP.init(mysql, property.getProperty("database.PSM"), property.getProperty("database.hgvs_view"));
            Gene.init(mysql, property.getProperty("database.geneTable"), property.getProperty("database.gene2pubmed"));
            UniprotFeature.init(mysql, property.getProperty("database.uniprot"));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        int tp = 0;
        int fp = 0;
        int fn = 0;
        for (int pmid : mutations.keySet()) {
            Set<Gene> genes = Gene.queryGenesForArticle(pmid);
            for (MutationValidation mutation2 : mutations.get(pmid)) {
                ArrayList<dbSNPNormalized> normalized = new ArrayList<dbSNPNormalized>();
                for (Gene gene : genes) {
                    if (gene.getSpecies() != 9606) continue;
                    List<dbSNP> potentialSNPs = dbSNP.getSNP(gene.getGeneID());
                    List<UniprotFeature> features = UniprotFeature.getFeatures(gene.getGeneID());
                    mutation2.normalizeSNP(potentialSNPs, features, true);
                }
                if (mutation2.getNormalized() != null) {
                    normalized.addAll(mutation2.getNormalized());
                }
                HashSet<Integer> ids = new HashSet<Integer>();
                for (dbSNPNormalized dbSNPNorm : normalized) {
                    ids.add(dbSNPNorm.getRsID());
                }
                if (ids.contains(mutation2.getDbSNP())) {
                    ++tp;
                    ids.remove(mutation2.getDbSNP());
                } else {
                    ++fn;
                }
                fp += ids.size();
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    int id = (Integer)i$.next();
                    System.err.println("FP\t" + pmid + "\t" + id + " for " + mutation2.getDbSNP() + " " + mutation2.toString());
                }
            }
        }
        double recall2 = (double)tp / (double)(tp + fn);
        double precision = (double)tp / (double)(tp + fp);
        double f1 = 2.0 * (precision * recall2) / (precision + recall2);
        DecimalFormat df = new DecimalFormat("0.00");
        System.err.println("TP " + tp);
        System.err.println("FP " + fp);
        System.err.println("FN " + fn);
        System.err.println("Precision " + df.format(precision));
        System.err.println("Recall " + df.format(recall2));
        System.err.println("F1 " + df.format(f1));
    }

    private static void printUsage() {
        System.err.println("Evaluates normalisation results using the manually annotated corpus");
        System.err.println("Usage: java de.hu.berlin.wbi.process.Evaluate property-file corpus-file\n");
        System.err.println("Arguments:");
        System.err.println("\t property-file\t-> File containing the property settings to access the database");
        System.err.println("\t corpus-file\t-> File containing the annotated corpus to evaluate the normalisation process");
    }
}

