/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.objects;

import de.hu.berlin.wbi.objects.UniprotFeature;
import de.hu.berlin.wbi.objects.dbSNP;

public class dbSNPNormalized
extends dbSNP
implements Comparable<dbSNPNormalized> {
    private boolean psm = false;
    private boolean exactMatch = false;
    private boolean methioneMatch = false;
    private UniprotFeature feature = null;
    private boolean alleleOrder = false;
    private int confidence = -1;

    public dbSNPNormalized(dbSNP dbsnp, boolean exactMatch, boolean methioneMatch, boolean psm, UniprotFeature feature, boolean alleleOrder) {
        this.rsID = dbsnp.getRsID();
        this.geneID = dbsnp.getGeneID();
        this.residues = dbsnp.getResidues();
        this.aaPosition = dbsnp.getAaPosition();
        this.hgvs = dbsnp.getHgvs();
        this.exactMatch = exactMatch;
        this.methioneMatch = methioneMatch;
        this.psm = psm;
        this.feature = feature;
        this.alleleOrder = alleleOrder;
        this.confidence = (psm ? 5 : 4) + (exactMatch ? 4 : 0);
    }

    @Override
    public String toString() {
        return "dbSNPNormalized [rsID=" + this.rsID + ", Contig=" + " ,GeneID " + this.geneID + ", residues=" + this.residues + " ,aaPosition=" + this.aaPosition + "]";
    }

    public boolean isAlleleOrder() {
        return this.alleleOrder;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    public boolean isMethioneMatch() {
        return this.methioneMatch;
    }

    public boolean isFeatureMatch() {
        return this.feature != null;
    }

    public boolean isPsm() {
        return this.psm;
    }

    public int getConfidence() {
        return this.confidence;
    }

    @Override
    public int compareTo(dbSNPNormalized that) {
        return that.confidence - this.confidence;
    }
}

