/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.objects;

import de.hu.berlin.wbi.objects.DatabaseConnection;
import de.hu.berlin.wbi.objects.HGVS;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class dbSNP {
    protected int rsID;
    protected int geneID;
    protected Set<String> residues;
    protected String wildtype;
    protected int aaPosition;
    protected Set<HGVS> hgvs;
    private static final Pattern pattern = Pattern.compile("\\|");
    private static DatabaseConnection conn = null;
    private static PreparedStatement hgvsQuery;
    private static PreparedStatement snpQuery;

    public static void init(DatabaseConnection mysql, String psmTable, String hgvs_view) throws SQLException {
        if (conn != null) {
            throw new IllegalStateException("ALREADY INITIALIZED");
        }
        conn = mysql;
        snpQuery = conn.getConn().prepareStatement("SELECT snp_id, locus_id, aa_Position, residue, wildtype FROM " + psmTable + " WHERE locus_id = ? ");
        hgvsQuery = conn.getConn().prepareStatement("SELECT snp_id, hgvs AS hgvs_name FROM " + hgvs_view + " WHERE locus_id = ?");
    }

    public static List<dbSNP> getSNP(int geneID) {
        if (conn == null) {
            throw new IllegalStateException("NOT YET INITIALIZED");
        }
        ArrayList<dbSNP> result2 = new ArrayList<dbSNP>(1000);
        try {
            snpQuery.setInt(1, geneID);
            if (snpQuery.execute()) {
                ResultSet rs = snpQuery.getResultSet();
                while (rs.next()) {
                    dbSNP dbSNP2 = new dbSNP(rs.getInt("snp_id"), rs.getInt("locus_id"), new HashSet<String>(Arrays.asList(pattern.split(rs.getString("residue")))), rs.getInt("aa_Position") + 1, rs.getString("wildtype"));
                    result2.add(dbSNP2);
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            hgvsQuery.setInt(1, geneID);
            if (hgvsQuery.execute()) {
                ResultSet resultSet = hgvsQuery.getResultSet();
                HashMap tmp = new HashMap();
                while (resultSet.next()) {
                    int rsId = resultSet.getInt("snp_id");
                    HashSet<HGVS> hgvss = new HashSet<HGVS>();
                    if (tmp.containsKey(rsId)) {
                        hgvss.addAll((Collection)tmp.get(rsId));
                    }
                    hgvss.add(new HGVS(resultSet.getString("hgvs_name")));
                    tmp.put(rsId, hgvss);
                }
                resultSet.close();
                for (dbSNP snp : result2) {
                    snp.setHgvs((Set)tmp.get(snp.getRsID()));
                }
                for (Integer rs : tmp.keySet()) {
                    boolean contained = false;
                    for (dbSNP snp : result2) {
                        if (rs != snp.rsID) continue;
                        contained = true;
                        break;
                    }
                    if (contained) continue;
                    dbSNP tmpSNP = new dbSNP();
                    tmpSNP.setRsID(rs);
                    tmpSNP.setHgvs((Set)tmp.get(rs));
                    result2.add(tmpSNP);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result2;
    }

    public dbSNP() {
    }

    public dbSNP(int rsID, int geneID, Set<String> residues, int aaPosition, String wildtype) {
        this.rsID = rsID;
        this.geneID = geneID;
        this.residues = residues;
        this.aaPosition = aaPosition;
        this.wildtype = wildtype;
    }

    public int getRsID() {
        return this.rsID;
    }

    public void setRsID(int rsID) {
        this.rsID = rsID;
    }

    public int getGeneID() {
        return this.geneID;
    }

    public void setGeneID(int geneID) {
        this.geneID = geneID;
    }

    public Set<String> getResidues() {
        return this.residues;
    }

    public String getWildtype() {
        return this.wildtype;
    }

    public void setResidues(Set<String> residues) {
        this.residues = residues;
    }

    public int getAaPosition() {
        return this.aaPosition;
    }

    public void setAaPosition(int aaPosition) {
        this.aaPosition = aaPosition;
    }

    public Set<HGVS> getHgvs() {
        return this.hgvs;
    }

    public void setHgvs(Set<HGVS> hgvs) {
        this.hgvs = hgvs;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.aaPosition;
        result2 = 31 * result2 + this.geneID;
        result2 = 31 * result2 + (this.hgvs == null ? 0 : this.hgvs.hashCode());
        result2 = 31 * result2 + (this.residues == null ? 0 : this.residues.hashCode());
        result2 = 31 * result2 + this.rsID;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        dbSNP other = (dbSNP)obj;
        if (this.aaPosition != other.aaPosition) {
            return false;
        }
        if (this.geneID != other.geneID) {
            return false;
        }
        if (this.hgvs == null ? other.hgvs != null : !this.hgvs.equals(other.hgvs)) {
            return false;
        }
        if (this.residues == null ? other.residues != null : !this.residues.equals(other.residues)) {
            return false;
        }
        return this.rsID == other.rsID;
    }

    public String toString() {
        return "dbSNP [aaPosition=" + this.aaPosition + ", wildtype=" + this.wildtype + ", residues=" + this.residues + ", rsID=" + ", geneID=" + this.geneID + this.rsID + ", hgvs=" + this.hgvs + "]";
    }
}

