/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.objects;

import de.hu.berlin.wbi.objects.DatabaseConnection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UniprotFeature {
    private final int geneId;
    private final String modificationType;
    private final int startLoc;
    private final int endLoc;
    private static DatabaseConnection conn = null;
    private static PreparedStatement uniprotQuery;

    public UniprotFeature(int geneId, String modificationType, int startLoc, int endLoc) {
        this.geneId = geneId;
        this.modificationType = modificationType;
        this.startLoc = startLoc;
        this.endLoc = endLoc;
    }

    public static void init(DatabaseConnection mysql, String uniProt_Table) throws SQLException {
        if (conn != null) {
            throw new IllegalStateException("ALREADY INITIALIZED");
        }
        conn = mysql;
        uniprotQuery = conn.getConn().prepareStatement("SELECT entrez, modification, location FROM  " + uniProt_Table + " WHERE entrez = ? ");
    }

    public static List<UniprotFeature> getFeatures(int geneID) {
        if (conn == null) {
            throw new IllegalStateException("NOT YET INITIALIZED");
        }
        ArrayList<UniprotFeature> result2 = new ArrayList<UniprotFeature>(128);
        try {
            uniprotQuery.setInt(1, geneID);
            if (uniprotQuery.execute()) {
                ResultSet rs = uniprotQuery.getResultSet();
                while (rs.next()) {
                    String mod;
                    String[] tmp = rs.getString("location").split("-");
                    if (tmp.length > 2 || !(mod = rs.getString("modification")).equals("signal peptide") && !mod.equals("splice variant") && !mod.equals("transit peptide") && !mod.equals("peptide") && !mod.equals("propeptide")) continue;
                    UniprotFeature feature = tmp.length == 2 ? new UniprotFeature(rs.getInt("entrez"), rs.getString("modification"), Integer.parseInt(tmp[0]), Integer.parseInt(tmp[1])) : new UniprotFeature(rs.getInt("entrez"), rs.getString("modification"), Integer.parseInt(tmp[0]), Integer.parseInt(tmp[0]));
                    result2.add(feature);
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result2;
    }

    public String toString() {
        return this.modificationType + " " + this.startLoc + "-" + this.endLoc;
    }

    public int getGeneId() {
        return this.geneId;
    }

    public String getModificationType() {
        return this.modificationType;
    }

    public int getStartLoc() {
        return this.startLoc;
    }

    public int getEndLoc() {
        return this.endLoc;
    }
}

