/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.objects;

import de.hu.berlin.wbi.objects.EntityOffset;
import de.hu.berlin.wbi.objects.MutationMention;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class MutationValidation
extends MutationMention {
    private final int dbSNP;
    private final String mutationType;
    private final String entity;

    public MutationValidation(int dbSNP2, EntityOffset location, String wtResidue, String mutResidue, String position, String mutationType, String entity) {
        this.dbSNP = dbSNP2;
        this.mutationType = mutationType;
        this.location = location;
        this.wtResidue = wtResidue;
        this.mutResidue = mutResidue;
        this.position = position;
        this.entity = entity;
    }

    public int getDbSNP() {
        return this.dbSNP;
    }

    public String getMutationType() {
        return this.mutationType;
    }

    public String getEntity() {
        return this.entity;
    }

    public static Map<Integer, List<MutationValidation>> readMutationsValidation(String file) throws IOException {
        String line;
        HashMap<Integer, List<MutationValidation>> result2 = new HashMap<Integer, List<MutationValidation>>();
        BufferedReader br = file.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file)))) : new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) {
                System.err.println("Skipping line " + line);
                continue;
            }
            String[] array = line.split("\t");
            if (array.length == 7) {
                if (array[2].startsWith("p.")) {
                    array[2] = array[2].substring(2);
                } else if (array[2].startsWith("c.") || array[2].startsWith("g.")) {
                    Pattern p = Pattern.compile("([\\-\\*]?[1-9][0-9]*[+\\-]?[1-9]*[0-9]*)([ATGC])[\\>\\<]([ATGC])");
                    Matcher m = p.matcher(array[2]);
                    m.find();
                    String compareString = m.group(1) + m.group(2) + ">" + m.group(3);
                    if (!compareString.equals(array[2].substring(2))) {
                        throw new RuntimeException("Error parsing '" + array[2] + "' result '" + compareString + "' is not correct");
                    }
                    array[2] = m.group(2) + m.group(1) + m.group(3);
                }
                int pmid = Integer.parseInt(array[0]);
                MutationMention tmp = new MutationMention(array[2]);
                MutationValidation mv = new MutationValidation(Integer.parseInt(array[5].substring(2)), new EntityOffset(Integer.parseInt(array[3]), Integer.parseInt(array[4])), tmp.wtResidue, tmp.mutResidue, tmp.position, array[6], array[1].substring(1, array[1].length() - 1));
                if (result2.containsKey(pmid)) {
                    ((List)result2.get(pmid)).add(mv);
                    continue;
                }
                ArrayList<MutationValidation> tmpList = new ArrayList<MutationValidation>();
                tmpList.add(mv);
                result2.put(pmid, tmpList);
                continue;
            }
            throw new RuntimeException("Quit parsing " + file + "\nLine " + line + " has not 7 fields " + array.length);
        }
        return result2;
    }

    @Override
    public String toString() {
        return "MutationValidation [dbSNP=" + this.dbSNP + " ," + this.wtResidue + this.position + this.mutResidue + "]";
    }
}

