/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.objects;

import de.hu.berlin.wbi.objects.EntityOffset;
import de.hu.berlin.wbi.objects.HGVS;
import de.hu.berlin.wbi.objects.UniprotFeature;
import de.hu.berlin.wbi.objects.dbSNP;
import de.hu.berlin.wbi.objects.dbSNPNormalized;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import seth.ner.wrapper.Type;

public class MutationMention {
    protected Type type;
    protected Tool tool;
    protected EntityOffset location;
    protected String text;
    protected String ref;
    protected String wtResidue;
    protected String mutResidue;
    protected String position;
    protected boolean nsm;
    protected List<dbSNPNormalized> normalized;
    protected int patternId;
    private static final Pattern pattern = Pattern.compile("^([A-Z])([\\-\\+\\*]?[1-9][0-9]*[\\-\\+]?[0-9]*)([A-Z])$");

    public void normalizeSNP(int id) {
        dbSNP snp = new dbSNP();
        snp.setRsID(id);
        this.normalized.add(new dbSNPNormalized(snp, true, false, false, null, true));
    }

    public void normalizeSNP(List<dbSNP> candidates, List<UniprotFeature> features, boolean append2) {
        if (!append2 || this.normalized == null) {
            this.normalized = new ArrayList<dbSNPNormalized>(1);
        }
        if (this.wtResidue == null || this.mutResidue == null || this.position == null) {
            return;
        }
        for (dbSNP candidate : candidates) {
            UniprotFeature feature;
            boolean reverse2;
            if (candidate.getHgvs() != null) {
                if (this.normalizePSMSimpleHGVS(candidate)) {
                    this.normalized.add(new dbSNPNormalized(candidate, true, false, true, null, true));
                }
                if (this.normalizePSMSimpleHGVSSwap(candidate)) {
                    this.normalized.add(new dbSNPNormalized(candidate, true, false, true, null, false));
                }
                if (this.normalizePSMMethionineHGVS(candidate)) {
                    this.normalized.add(new dbSNPNormalized(candidate, false, true, true, null, true));
                }
                if (this.normalizePSMMethionineSwapHGVS(candidate)) {
                    this.normalized.add(new dbSNPNormalized(candidate, false, true, true, null, false));
                }
                if (this.forwardNSMSimple(candidate) || this.reverseNSMSimple(candidate)) {
                    this.normalized.add(new dbSNPNormalized(candidate, true, false, false, null, true));
                }
            }
            if (candidate.getResidues() == null) continue;
            boolean forward = this.checkPSM_WildType(candidate, true) && this.checkPSM_Mutated(candidate, true);
            boolean bl = reverse2 = this.checkPSM_WildType(candidate, false) && this.checkPSM_Mutated(candidate, false);
            if (!forward && !reverse2) continue;
            if (this.normalizePSMSimple(candidate)) {
                this.normalized.add(new dbSNPNormalized(candidate, true, false, true, null, forward));
            }
            if (this.normalizePSMMethionine(candidate)) {
                this.normalized.add(new dbSNPNormalized(candidate, false, true, true, null, forward));
            }
            if ((feature = this.normalizePSMVariableOffset(candidate, features)) == null) continue;
            this.normalized.add(new dbSNPNormalized(candidate, false, false, true, feature, forward));
        }
        this.normalized = MutationMention.cleanResults(this.normalized);
    }

    private static List<dbSNPNormalized> cleanResults(List<dbSNPNormalized> snpList) {
        Collections.sort(snpList);
        int value2 = snpList.size() > 0 ? snpList.get(0).getConfidence() : Integer.MIN_VALUE;
        ArrayList<dbSNPNormalized> topResult = new ArrayList<dbSNPNormalized>();
        HashSet<Integer> seen = new HashSet<Integer>();
        for (dbSNPNormalized snp : snpList) {
            if (value2 != snp.getConfidence() || seen.contains(snp.getRsID())) continue;
            topResult.add(snp);
            seen.add(snp.getRsID());
        }
        return topResult;
    }

    private boolean checkPSM_WildType(dbSNP candidate, boolean forward) {
        if (forward) {
            return candidate.getWildtype().equals(this.wtResidue);
        }
        return candidate.getWildtype().equals(this.mutResidue);
    }

    private boolean checkPSM_Mutated(dbSNP candidate, boolean forward) {
        if (forward) {
            return candidate.getResidues().contains(this.mutResidue);
        }
        return candidate.getResidues().contains(this.wtResidue);
    }

    private boolean normalizePSMSimple(dbSNP candidate) {
        return Integer.toString(candidate.getAaPosition()).equals(this.position);
    }

    private boolean normalizePSMMethionine(dbSNP candidate) {
        return Integer.toString(candidate.getAaPosition() - 1).equals(this.position) || Integer.toString(candidate.getAaPosition() + 1).equals(this.position);
    }

    private UniprotFeature normalizePSMVariableOffset(dbSNP candidate, List<UniprotFeature> features) {
        for (UniprotFeature feature : features) {
            if (feature.getGeneId() != candidate.getGeneID() || !Integer.toString(candidate.getAaPosition() - feature.getEndLoc() + feature.getStartLoc() - 1).equals(this.position)) continue;
            return feature;
        }
        return null;
    }

    private boolean normalizePSMSimpleHGVS(dbSNP candidate) {
        for (HGVS hgvs : candidate.getHgvs()) {
            if (hgvs.getMutation() == null || hgvs.getWildtype() == null || hgvs.getLocation() == null || hgvs.getType() != 'p' || !hgvs.getLocation().equals(this.position) || !this.wtResidue.equals(hgvs.getWildtype()) || !this.mutResidue.equals(hgvs.getMutation())) continue;
            return true;
        }
        return false;
    }

    private boolean normalizePSMSimpleHGVSSwap(dbSNP candidate) {
        for (HGVS hgvs : candidate.getHgvs()) {
            if (hgvs.getMutation() == null || hgvs.getWildtype() == null || hgvs.getLocation() == null || hgvs.getType() != 'p' || !hgvs.getLocation().equals(this.position) || !this.wtResidue.equals(hgvs.getMutation()) || !this.mutResidue.equals(hgvs.getWildtype())) continue;
            return true;
        }
        return false;
    }

    private boolean normalizePSMMethionineHGVS(dbSNP candidate) {
        int loc = -1;
        try {
            loc = Integer.parseInt(this.position);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        for (HGVS hgvs : candidate.getHgvs()) {
            if (hgvs.getMutation() == null || hgvs.getWildtype() == null || hgvs.getLocation() == null || hgvs.getType() != 'p' || !this.wtResidue.equals(hgvs.getMutation()) || !this.mutResidue.equals(hgvs.getWildtype()) || !Integer.toString(loc - 1).equals(hgvs.getLocation()) && !Integer.toString(loc + 1).equals(hgvs.getLocation())) continue;
            return true;
        }
        return false;
    }

    private boolean normalizePSMMethionineSwapHGVS(dbSNP candidate) {
        int loc = -1;
        try {
            loc = Integer.parseInt(this.position);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        for (HGVS hgvs : candidate.getHgvs()) {
            if (hgvs.getMutation() == null || hgvs.getWildtype() == null || hgvs.getLocation() == null || hgvs.getType() != 'p' || !this.wtResidue.equals(hgvs.getWildtype()) || !this.mutResidue.equals(hgvs.getMutation()) || !Integer.toString(loc - 1).equals(hgvs.getLocation()) && !Integer.toString(loc + 1).equals(hgvs.getLocation())) continue;
            return true;
        }
        return false;
    }

    private boolean forwardNSMSimple(dbSNP candidate) {
        for (HGVS hgvs : candidate.getHgvs()) {
            if (hgvs.getMutation() == null || hgvs.getWildtype() == null || hgvs.getLocation() == null || hgvs.getType() != 'g' && hgvs.getType() != 'c' || !hgvs.getWildtype().equals(this.wtResidue)) continue;
            boolean contained = false;
            if (hgvs.getMutation().contains(this.mutResidue)) {
                contained = true;
            } else if (this.mutResidue.equals(this.wtResidue) && hgvs.getWildtype().contains(this.wtResidue)) {
                contained = true;
            }
            if (!contained || !hgvs.getLocation().equals(this.position)) continue;
            return true;
        }
        return false;
    }

    private boolean reverseNSMSimple(dbSNP candidate) {
        for (HGVS hgvs : candidate.getHgvs()) {
            if (hgvs.getMutation() == null || hgvs.getWildtype() == null || hgvs.getLocation() == null || hgvs.getType() != 'g' && hgvs.getType() != 'c' || !hgvs.getMutation().equals(this.wtResidue)) continue;
            boolean contained = false;
            if (hgvs.getWildtype().contains(this.mutResidue)) {
                contained = true;
            } else if (this.mutResidue.equals(this.wtResidue) && hgvs.getWildtype().contains(this.wtResidue)) {
                contained = true;
            }
            if (!contained || !hgvs.getLocation().equals(this.position)) continue;
            return true;
        }
        return false;
    }

    public static Map<Integer, List<MutationMention>> readMutations(String file) throws IOException {
        String line;
        HashMap<Integer, List<MutationMention>> result2 = new HashMap<Integer, List<MutationMention>>();
        BufferedReader br = file.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file)))) : new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) {
                System.err.println("Skipping line " + line);
                continue;
            }
            String[] array = line.split("\t");
            if (array.length == 4) {
                int pmid = Integer.parseInt(array[0]);
                MutationMention tmp = new MutationMention(array[1]);
                tmp.setLocation(new EntityOffset(Integer.parseInt(array[2]), Integer.parseInt(array[3])));
                tmp.tool = Tool.MUTATIONFINDER;
                if (result2.containsKey(pmid)) {
                    ((List)result2.get(pmid)).add(tmp);
                    continue;
                }
                ArrayList<MutationMention> tmpList = new ArrayList<MutationMention>();
                tmpList.add(tmp);
                result2.put(pmid, tmpList);
                continue;
            }
            System.err.println(array.length);
            System.err.println("Error parsing line " + line);
        }
        return result2;
    }

    public MutationMention() {
    }

    public MutationMention(String mutation2) {
        Matcher matcher = pattern.matcher(mutation2);
        if (!matcher.find()) {
            System.err.println("Mutation '" + mutation2 + "' currently not supported for normalization");
        } else {
            this.position = matcher.group(2).startsWith("+") ? matcher.group(2).substring(1) : matcher.group(2);
            this.wtResidue = matcher.group(1);
            this.mutResidue = matcher.group(3);
        }
    }

    public MutationMention(EntityOffset location, String mutation2) {
        Matcher matcher = pattern.matcher(mutation2);
        if (!matcher.find()) {
            System.err.println("Skipping '" + mutation2 + "'");
        } else {
            this.location = location;
            this.position = matcher.group(2).startsWith("+") ? matcher.group(2).substring(1) : matcher.group(2);
            this.wtResidue = matcher.group(1);
            this.mutResidue = matcher.group(3);
        }
    }

    public MutationMention(int start, int end, String text2, String ref, String location, String wild, String mutated, Type type, Tool tool) {
        this.location = new EntityOffset(start, end);
        this.text = text2;
        this.ref = ref;
        this.position = location;
        this.wtResidue = wild;
        this.mutResidue = mutated;
        this.type = type;
        this.tool = tool;
    }

    public EntityOffset getLocation() {
        return this.location;
    }

    public int getStart() {
        return this.location.getStart();
    }

    public int getEnd() {
        return this.location.getStop();
    }

    private void setLocation(EntityOffset location) {
        this.location = location;
    }

    public String getWtResidue() {
        return this.wtResidue;
    }

    public void setWtResidue(String wtResidue) {
        this.wtResidue = wtResidue;
    }

    public String getMutResidue() {
        return this.mutResidue;
    }

    public void setMutResidue(String mutResidue) {
        this.mutResidue = mutResidue;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String toString() {
        return "MutationMention [span=" + this.location.getStart() + "-" + this.location.getStop() + ", mutResidue=" + this.mutResidue + ", location=" + this.position + ", wtResidue=" + this.wtResidue + ", text=" + this.text + ", type=" + (Object)((Object)this.getType()) + ", tool=" + (Object)((Object)this.getTool()) + "]";
    }

    public String toNormalized() {
        if (this.getTool().equals((Object)Tool.MUTATIONFINDER)) {
            return this.wtResidue + this.position + this.mutResidue;
        }
        if (this.getTool().equals((Object)Tool.REGEX)) {
            if (this.getType().equals((Object)Type.DELETION)) {
                return this.wtResidue + this.position + "del";
            }
            return this.text;
        }
        return this.text;
    }

    public boolean isNsm() {
        return this.nsm;
    }

    public Type getType() {
        return this.type;
    }

    public Tool getTool() {
        return this.tool;
    }

    public String getText() {
        return this.text;
    }

    public String getRef() {
        return this.ref;
    }

    public List<dbSNPNormalized> getNormalized() {
        return this.normalized;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public void setPatternId(int patternId) {
        this.patternId = patternId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationMention that = (MutationMention)o;
        if (this.nsm != that.nsm) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.mutResidue != null ? !this.mutResidue.equals(that.mutResidue) : that.mutResidue != null) {
            return false;
        }
        if (this.normalized != null ? !this.normalized.equals(that.normalized) : that.normalized != null) {
            return false;
        }
        if (this.position != null ? !this.position.equals(that.position) : that.position != null) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(that.ref) : that.ref != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.tool != that.tool) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.wtResidue != null ? !this.wtResidue.equals(that.wtResidue) : that.wtResidue != null);
    }

    public int hashCode() {
        int result2 = this.type != null ? this.type.hashCode() : 0;
        result2 = 31 * result2 + (this.tool != null ? this.tool.hashCode() : 0);
        result2 = 31 * result2 + (this.location != null ? this.location.hashCode() : 0);
        result2 = 31 * result2 + (this.text != null ? this.text.hashCode() : 0);
        result2 = 31 * result2 + (this.ref != null ? this.ref.hashCode() : 0);
        result2 = 31 * result2 + (this.wtResidue != null ? this.wtResidue.hashCode() : 0);
        result2 = 31 * result2 + (this.mutResidue != null ? this.mutResidue.hashCode() : 0);
        result2 = 31 * result2 + (this.position != null ? this.position.hashCode() : 0);
        result2 = 31 * result2 + (this.nsm ? 1 : 0);
        result2 = 31 * result2 + (this.normalized != null ? this.normalized.hashCode() : 0);
        return result2;
    }

    public static enum Tool {
        MUTATIONFINDER,
        SETH,
        REGEX,
        DBSNP,
        CNVETH;

    }
}

