/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.objects;

import edu.uchsc.ccp.nlp.ei.mutation.MutationFinder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HGVS {
    private char type;
    private String location;
    private String wildtype;
    private String mutation;
    private static final Pattern locationPattern = Pattern.compile("[A-Za-z]");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HGVS(String string2) {
        try {
            this.type = string2.charAt(0);
            if (this.type == 'c' || this.type == 'g') {
                String s = string2.substring(2);
                Matcher locationMatcher = locationPattern.matcher(s);
                locationMatcher.find();
                this.location = s.substring(0, locationMatcher.start());
                s = s.substring(locationMatcher.start());
                if (s.contains(">")) {
                    this.wildtype = s.substring(0, s.indexOf(">"));
                    this.mutation = s.substring(s.indexOf(">") + 1);
                    return;
                } else {
                    if (!s.startsWith("ins") && !s.startsWith("del") && !s.startsWith("dup")) throw new Exception("Unknown HGVS string '" + string2 + "'");
                    this.wildtype = s.substring(0, 3);
                    this.mutation = s.substring(3);
                }
                return;
            } else if (this.type == 'p') {
                Map<String, String> map2 = MutationFinder.populateAminoAcidThreeToOneLookupMap();
                String s = string2.substring(2);
                this.type = (char)112;
                Pattern mutationMattern = Pattern.compile("([A-Za-z]+)([1-9][0-9]*)([A-Za-z]+|=)");
                Matcher m = mutationMattern.matcher(s);
                if (!m.find()) return;
                this.location = m.group(2);
                this.wildtype = map2.get(m.group(1).toUpperCase());
                this.mutation = m.group(3).equals("=") ? this.wildtype : map2.get(m.group(3).toUpperCase());
                return;
            } else {
                if (this.type == 'n' || this.type == 'm') return;
                System.err.println("Type " + this.type + " not covered");
            }
            return;
        }
        catch (Exception exception) {
            this.type = (char)45;
            this.location = null;
            this.wildtype = null;
            this.mutation = null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.location == null ? 0 : this.location.hashCode());
        result2 = 31 * result2 + (this.mutation == null ? 0 : this.mutation.hashCode());
        result2 = 31 * result2 + this.type;
        result2 = 31 * result2 + (this.wildtype == null ? 0 : this.wildtype.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HGVS other = (HGVS)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.mutation == null ? other.mutation != null : !this.mutation.equals(other.mutation)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.wildtype == null ? other.wildtype != null : !this.wildtype.equals(other.wildtype));
    }

    public String toString() {
        if (this.type == 'c' || this.type == 'g') {
            return this.type + "." + this.location + this.wildtype + ">" + this.mutation;
        }
        return this.type + "." + this.wildtype + this.location + this.mutation;
    }

    public char getType() {
        return this.type;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWildtype() {
        return this.wildtype;
    }

    public String getMutation() {
        return this.mutation;
    }
}

