/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.objects;

import de.hu.berlin.wbi.objects.DatabaseConnection;
import de.hu.berlin.wbi.objects.EntityOffset;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class Gene {
    private static PreparedStatement geneQuery;
    private static PreparedStatement gene2pubmedQuery;
    private int pmid;
    private int geneID;
    private int confidence;
    private int species;
    private EntityOffset location;
    private String entity;
    private static String beginColumnName;
    private static String endColumnName;

    public Gene() {
    }

    public Gene(int pmid, int geneID, int confidence, int species, EntityOffset location, String entity) {
        this.pmid = pmid;
        this.geneID = geneID;
        this.confidence = confidence;
        this.species = species;
        this.location = location;
        this.entity = entity;
    }

    public int getPmid() {
        return this.pmid;
    }

    public int getGeneID() {
        return this.geneID;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public int getSpecies() {
        return this.species;
    }

    public EntityOffset getLocation() {
        return this.location;
    }

    public String getEntity() {
        return this.entity;
    }

    public String toString() {
        return "Gene [pmid=" + this.pmid + ", geneID=" + this.geneID + ", location=" + this.location.getStart() + "-" + this.location.getStop() + ", species=" + this.species + ", entity=" + this.entity + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.confidence;
        result2 = 31 * result2 + (this.entity == null ? 0 : this.entity.hashCode());
        result2 = 31 * result2 + this.geneID;
        result2 = 31 * result2 + (this.location == null ? 0 : this.location.hashCode());
        result2 = 31 * result2 + this.pmid;
        result2 = 31 * result2 + this.species;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Gene other = (Gene)obj;
        if (this.confidence != other.confidence) {
            return false;
        }
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        if (this.geneID != other.geneID) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.pmid != other.pmid) {
            return false;
        }
        return this.species == other.species;
    }

    public static void init(DatabaseConnection connection, String geneTable, String gene2Pubmed) throws SQLException {
        if (geneTable != null && !geneTable.equals("")) {
            geneQuery = connection.getConn().prepareStatement("SELECT * FROM " + geneTable + " WHERE pmid = ? AND species = 9606");
            Gene.checkDatabase();
        } else {
            geneQuery = null;
        }
        gene2pubmedQuery = gene2Pubmed != null && !gene2Pubmed.equals("") ? connection.getConn().prepareStatement("SELECT geneId, pmid FROM " + gene2Pubmed + " WHERE pmid = ?") : null;
        if (geneQuery == null && gene2pubmedQuery == null) {
            throw new IllegalStateException("At least one gene Source has to be specified");
        }
    }

    public static Set<Gene> queryGenesForArticle(int pmid) {
        HashSet<Integer> entrezs = new HashSet<Integer>();
        HashSet<Gene> genes = new HashSet<Gene>();
        try {
            Gene tmp;
            if (geneQuery != null) {
                geneQuery.setInt(1, pmid);
                geneQuery.execute();
                ResultSet rs = geneQuery.getResultSet();
                while (rs.next()) {
                    tmp = new Gene(pmid, rs.getInt("id"), rs.getInt("confidence"), rs.getInt("species"), new EntityOffset(rs.getInt(beginColumnName), rs.getInt(endColumnName)), rs.getString("entity"));
                    if (!entrezs.add(tmp.getGeneID())) continue;
                    genes.add(tmp);
                }
                rs.close();
            }
            if (gene2pubmedQuery != null) {
                gene2pubmedQuery.setInt(1, pmid);
                gene2pubmedQuery.execute();
                ResultSet rs2 = gene2pubmedQuery.getResultSet();
                while (rs2.next()) {
                    tmp = new Gene(pmid, rs2.getInt("geneId"), 1, 9606, null, null);
                    if (!entrezs.add(tmp.getGeneID())) continue;
                    genes.add(tmp);
                }
                rs2.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return genes;
    }

    private static void checkDatabase() throws SQLException {
        geneQuery.setInt(1, 25000000);
        geneQuery.execute();
        ResultSet rs = geneQuery.getResultSet();
        ResultSetMetaData meta = rs.getMetaData();
        int numCol = meta.getColumnCount();
        for (int i = 1; i < numCol + 1; ++i) {
            if (!meta.getColumnName(i).equals("beginGene")) continue;
            rs.close();
            beginColumnName = "beginGene";
            endColumnName = "endGene";
            return;
        }
        beginColumnName = "begin";
        endColumnName = "end";
        rs.close();
    }

    static {
        beginColumnName = null;
        endColumnName = null;
    }
}

