/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi.objects;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class DatabaseConnection {
    private final String user;
    private final String password;
    private final String database;
    private final String host;
    private final String driver;
    private ResultSet rs;
    private Connection conn;
    private Statement stmt;

    public DatabaseConnection(Properties property) {
        this.user = property.getProperty("database.user");
        this.password = property.getProperty("database.password");
        this.database = property.getProperty("database.name");
        this.host = property.getProperty("database.host");
        this.driver = property.getProperty("database.driver");
    }

    public void query(String query) {
        this.stmt = null;
        this.rs = null;
        try {
            this.stmt = this.conn.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            this.rs = this.stmt.executeQuery(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void closeQuery() {
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            this.stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void connect() {
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (InstantiationException e) {
            System.err.println("Problem during Instantiation of mySQL");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            System.err.println("Illegal Access");
            e.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            String connectionString = this.host + this.database;
            if (this.driver.contains("mysql")) {
                connectionString = connectionString + "?connectTimeout=30000&amp;useUnicode=true&amp;characterEncoding=UTF-8&amp;autoReconnect=true&amp;failOverReadOnly=false&amp;maxReconnects=10";
            }
            this.conn = DriverManager.getConnection(connectionString, this.user, this.password);
        }
        catch (SQLException e) {
            System.err.println("SQL-Exception");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void disconnect() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public ResultSet getRs() {
        return this.rs;
    }

    public Connection getConn() {
        return this.conn;
    }
}

