/*
 * Decompiled with CFR 0.152.
 */
package de.hu.berlin.wbi;

import de.hu.berlin.wbi.objects.MutationMention;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import seth.SETH;

public class OldNomenclatureTest {
    private SETH seth;

    @Before
    public void setUp() {
        this.seth = new SETH("resources/mutations.txt", false, true);
    }

    private void assertSingleMutation(String text2, String mutation2) {
        List<MutationMention> mutationMentions = this.seth.findMutations(text2);
        Assert.assertEquals(1, mutationMentions.size());
        Assert.assertEquals(mutation2, mutationMentions.get(0).getText());
    }

    private void assertSingleMutation(String text2) {
        List<MutationMention> mutationMentions = this.seth.findMutations(text2);
        Assert.assertEquals(1, mutationMentions.size());
        System.out.println(text2 + " '" + mutationMentions.get(0).getText() + "'");
        Assert.assertEquals(text2, mutationMentions.get(0).getText());
    }

    @Test
    public void testBeaudet1993() throws Exception {
        this.assertSingleMutation("435insA");
        this.assertSingleMutation("1154insTC");
        this.assertSingleMutation("1154ins12");
        this.assertSingleMutation("441delA");
        this.assertSingleMutation("241delAT");
        this.assertSingleMutation("deltaF508");
        this.assertSingleMutation("\u0394F508");
        this.assertSingleMutation("241delAT");
        this.assertSingleMutation("852del22");
        this.assertSingleMutation("(441delA", "441delA");
        this.assertSingleMutation(",441delA ", "441delA");
        this.assertSingleMutation("(241delAT)", "241delAT");
        this.assertSingleMutation(" deltaF508,", "deltaF508");
        this.assertSingleMutation("c [\u0394F508 ", "\u0394F508");
        this.assertSingleMutation("d 241delAT ", "241delAT");
        this.assertSingleMutation("e 852del22 ", "852del22");
        this.assertSingleMutation("G85A");
        this.assertSingleMutation("D44G");
        this.assertSingleMutation("A455E");
        this.assertSingleMutation("S549R");
        this.assertSingleMutation("Gly to Ala substitution at codon 86");
        this.assertSingleMutation("Tyr to stop at codon 76");
        this.assertSingleMutation("G85A, ", "G85A");
        this.assertSingleMutation(" D44G; ", "D44G");
        this.assertSingleMutation("(A455E)", "A455E");
        this.assertSingleMutation("S549R and", "S549R");
        this.assertSingleMutation(" Gly to Ala substitution at codon 86", "Gly to Ala substitution at codon 86");
        this.assertSingleMutation("Tyr to stop at codon 76 ", "Tyr to stop at codon 76");
        this.assertSingleMutation("621+1G->T");
        this.assertSingleMutation("621+1G\u2192T");
        this.assertSingleMutation("622-2A->C");
        this.assertSingleMutation("622-2A-->C");
        this.assertSingleMutation("622-2A -> C");
        this.assertSingleMutation("622-2A\u2192C");
        this.assertSingleMutation("622-2A\u2192 C");
        this.assertSingleMutation("622-2A \u2192C");
        this.assertSingleMutation("622-2A \u2192 C");
        this.assertSingleMutation("M/V470");
        this.assertSingleMutation("M/V 470");
        this.assertSingleMutation("Met/Val470");
        this.assertSingleMutation("Met/Val 470");
        this.assertSingleMutation("1716G/A");
        this.assertSingleMutation("1716 G/A");
        this.assertSingleMutation("125G/C");
        this.assertSingleMutation("125 G/C");
        this.assertSingleMutation("A->G at 263");
        this.assertSingleMutation("C->A at 1496");
        this.assertSingleMutation("Asp->Gly at 44");
        this.assertSingleMutation("Ala->Glu at 455");
        this.assertSingleMutation("Ser->Arg at 549");
        this.assertSingleMutation("Gln->Stop at 39");
    }

    @Test
    public void testBla() throws Exception {
        this.assertSingleMutation("G54C");
        this.assertSingleMutation("Arg250Ter");
        this.assertSingleMutation("R250X");
        this.assertSingleMutation("Phe508del");
        this.assertSingleMutation("Phe508del, ", "Phe508del");
    }

    @Test
    public void testFoo() throws Exception {
        this.assertSingleMutation("G54C");
        this.assertSingleMutation("54G\u2192C");
        this.assertSingleMutation("\u0394F508");
        this.assertSingleMutation("F508del");
        this.assertSingleMutation("T702del");
        this.assertSingleMutation("G54C ", "G54C");
        this.assertSingleMutation("54G\u2192C,", "54G\u2192C");
        this.assertSingleMutation("(\u0394F508)", "\u0394F508");
        this.assertSingleMutation(" F508del ", "F508del");
        this.assertSingleMutation(" T702del ", "T702del");
        this.assertSingleMutation("IVS4+1G>T");
        this.assertSingleMutation("IVS4+1G->T");
        this.assertSingleMutation("IVS4+1G-->T");
        this.assertSingleMutation("IVS4+1G\u2192T");
        this.assertSingleMutation(" IVS4+1G>T ", "IVS4+1G>T");
        this.assertSingleMutation("(IVS4+1G->T) ", "IVS4+1G->T");
        this.assertSingleMutation("IVS4+1G-->T,", "IVS4+1G-->T");
        this.assertSingleMutation(", IVS4+1G\u2192T, ", "IVS4+1G\u2192T");
        this.assertSingleMutation("IVS3-2A>T");
        this.assertSingleMutation("IVS3-2A->T");
        this.assertSingleMutation("IVS3-2A-->T");
        this.assertSingleMutation("IVS3-2A\u2192T");
        this.assertSingleMutation("2472G\u2192T");
        this.assertSingleMutation("2472G-->T");
        this.assertSingleMutation("Y76X");
        this.assertSingleMutation("411delA");
        this.assertSingleMutation("241delAT");
        this.assertSingleMutation("852del22");
        this.assertSingleMutation("435insA");
        this.assertSingleMutation("3320ins5");
    }

    @Test
    public void testBar() throws Exception {
        this.assertSingleMutation("R408W");
        this.assertSingleMutation("1347 C->T");
        this.assertSingleMutation("\u0394508");
        this.assertSingleMutation("delta508");
        this.assertSingleMutation("Delta508");
        this.assertSingleMutation("1507del");
        this.assertSingleMutation("241delAT");
        this.assertSingleMutation("852del22");
        this.assertSingleMutation("1154insTC");
        this.assertSingleMutation("IVS4+1G->T");
        this.assertSingleMutation("IVS4-2A->C");
        this.assertSingleMutation("M/V470");
        this.assertSingleMutation("1716G/A");
    }

    @Test
    public void testFooBar() throws Exception {
        this.assertSingleMutation("1997delT");
        this.assertSingleMutation("1997-1999del");
        this.assertSingleMutation("1997-1999delTTC");
        this.assertSingleMutation("1997-1998delTG");
        this.assertSingleMutation("1997-1998insT");
        this.assertSingleMutation("1997-1998insTG");
        this.assertSingleMutation("IVS4-2A>C");
        this.assertSingleMutation("c.1997+1G>T");
        this.assertSingleMutation("c.1997-2A>C");
        this.assertSingleMutation("Y97S");
        this.assertSingleMutation("R97X");
        this.assertSingleMutation("T97del");
    }

    @Test
    public void testDenDunnen2000() throws Exception {
        this.assertSingleMutation("c.1997G>T");
        this.assertSingleMutation("c.1997-1999del");
        this.assertSingleMutation("c.1997-1999delTTC");
        this.assertSingleMutation("IVS4-2A>C");
        this.assertSingleMutation("IVS4+1G>T");
        this.assertSingleMutation("13_14delTT");
        this.assertSingleMutation("13_14del");
        this.assertSingleMutation("13_14insT");
        this.assertSingleMutation("r.15c>u");
    }

    @Test
    public void testDenDunnen2001() throws Exception {
        this.assertSingleMutation("g.76A>T");
        this.assertSingleMutation("c.76A>T");
        this.assertSingleMutation("m.76A>T");
        this.assertSingleMutation("r.76a>u");
        this.assertSingleMutation("p.K76A");
        this.assertSingleMutation("p.T26P");
        this.assertSingleMutation("IVS2+1G>T");
        this.assertSingleMutation("c.88+1G>T");
        this.assertSingleMutation("IVS2-2A>C");
        this.assertSingleMutation("c.89-2A>C");
        this.assertSingleMutation("c.76_78del");
        this.assertSingleMutation("c.76_78delACT");
        this.assertSingleMutation("c.77-79dup");
        this.assertSingleMutation("c.77_79dup");
        this.assertSingleMutation("c.82_83dupTG");
        this.assertSingleMutation("c.82_83insTG");
        this.assertSingleMutation("c.112_117delinsTG");
        this.assertSingleMutation("c.203_506inv");
        this.assertSingleMutation("r.76a>c");
        this.assertSingleMutation("r.88+2t>c");
        this.assertSingleMutation("p.K29del");
        this.assertSingleMutation("p.C28_M30del");
        this.assertSingleMutation("p.G31_Q33dup");
        this.assertSingleMutation("p.K29_M29insQSK");
        this.assertSingleMutation("p.C28_K29delinsW");
        this.assertSingleMutation("p.C28_K29delinsWV");
        this.assertSingleMutation("p.R97fsX121");
    }

    @Test
    public void testWildemann2008() throws Exception {
        this.assertSingleMutation("c.3_4insG");
        this.assertSingleMutation("c.3_400del");
        this.assertSingleMutation("c.510-54A>G");
        this.assertSingleMutation("c.*19G>T");
        this.assertSingleMutation("c.76_77delinsTT");
        this.assertSingleMutation("g.7872G>T");
    }

    @Test
    public void testTaschner2011() throws Exception {
        this.assertSingleMutation("c.76A>C");
        this.assertSingleMutation("c.77T>G");
        this.assertSingleMutation("c.76_77delinsCG");
        this.assertSingleMutation("g.5delT");
        this.assertSingleMutation("g.5_10del");
        this.assertSingleMutation("g.5_6insTA");
    }

    @Test
    public void testLaros2011() throws Exception {
        this.assertSingleMutation("NM_003002.2:c.274G>T");
        this.assertSingleMutation("c.274G>T");
    }

    @Test
    public void testErrors() throws Exception {
        this.assertSingleMutation("+2740 A>G");
        this.assertSingleMutation("IVS19-37G/C");
        this.assertSingleMutation("3097delG");
        this.assertSingleMutation("1782-83delAG");
        this.assertSingleMutation("1494del6");
        this.assertSingleMutation("Y248del");
        this.assertSingleMutation("1009delA");
        this.assertSingleMutation("1009 delA");
        this.assertSingleMutation("1631delC");
        this.assertSingleMutation("DeltaG91");
        this.assertSingleMutation("Delta32");
        this.assertSingleMutation("3432delT");
        this.assertSingleMutation("-134delA");
    }
}

